/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.encrypt.ProducerDb;
import net.named_data.jndn.encrypt.Sqlite3ProducerDbBase;
import net.named_data.jndn.util.Blob;

public class Sqlite3ProducerDb
extends Sqlite3ProducerDbBase {
    Connection database_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sqlite3ProducerDb(String databaseFilePath) throws ProducerDb.Error {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Sqlite3ProducerDb.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        try {
            this.database_ = DriverManager.getConnection("jdbc:sqlite:" + databaseFilePath);
            try (Statement statement = this.database_.createStatement();){
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS                         \n  contentkeys(                                     \n    rowId            INTEGER PRIMARY KEY,          \n    timeslot         INTEGER,                      \n    key              BLOB NOT NULL                 \n  );                                               \n");
                statement.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS                  \n   timeslotIndex ON contentkeys(timeslot);         \n");
            }
        }
        catch (SQLException exception) {
            throw new ProducerDb.Error("Sqlite3ProducerDb: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasContentKey(double timeSlot) throws ProducerDb.Error {
        int fixedTimeSlot = Sqlite3ProducerDb.getFixedTimeSlot(timeSlot);
        try {
            statement.setInt(1, fixedTimeSlot);
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT key FROM contentkeys where timeslot=?");){
                ResultSet result = statement.executeQuery();
                if (result.next()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException exception) {
            throw new ProducerDb.Error("Sqlite3ProducerDb.hasContentKey: SQLite error: " + exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Blob getContentKey(double timeSlot) throws ProducerDb.Error {
        int fixedTimeSlot = Sqlite3ProducerDb.getFixedTimeSlot(timeSlot);
        try {
            statement.setInt(1, fixedTimeSlot);
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT key FROM contentkeys where timeslot=?");){
                ResultSet result = statement.executeQuery();
                if (!result.next()) throw new ProducerDb.Error("Sqlite3ProducerDb.getContentKey: Cannot get the key from the database");
                Blob blob = new Blob(result.getBytes(1));
                return blob;
            }
        }
        catch (SQLException exception) {
            throw new ProducerDb.Error("Sqlite3ProducerDb.getContentKey: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContentKey(double timeSlot, Blob key) throws ProducerDb.Error {
        int fixedTimeSlot = Sqlite3ProducerDb.getFixedTimeSlot(timeSlot);
        try {
            PreparedStatement statement = this.database_.prepareStatement("INSERT INTO contentkeys (timeslot, key) values (?, ?)");
            statement.setInt(1, fixedTimeSlot);
            statement.setBytes(2, key.getImmutableArray());
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new ProducerDb.Error("Sqlite3ProducerDb.addContentKey: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteContentKey(double timeSlot) throws ProducerDb.Error {
        int fixedTimeSlot = Sqlite3ProducerDb.getFixedTimeSlot(timeSlot);
        try {
            statement.setInt(1, fixedTimeSlot);
            try (PreparedStatement statement = this.database_.prepareStatement("DELETE FROM contentkeys WHERE timeslot=?");){
                statement.executeUpdate();
            }
        }
        catch (SQLException exception) {
            throw new ProducerDb.Error("Sqlite3ProducerDb.deleteContentKey: SQLite error: " + exception);
        }
    }
}

