/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import net.named_data.jndn.encrypt.GroupManagerDb;

public abstract class Sqlite3GroupManagerDbBase
extends GroupManagerDb {
    protected static final String INITIALIZATION1 = "CREATE TABLE IF NOT EXISTS                         \n  schedules(                                       \n    schedule_id         INTEGER PRIMARY KEY,       \n    schedule_name       TEXT NOT NULL,             \n    schedule            BLOB NOT NULL              \n  );                                               \n";
    protected static final String INITIALIZATION2 = "CREATE UNIQUE INDEX IF NOT EXISTS                  \n   scheduleNameIndex ON schedules(schedule_name);  \n";
    protected static final String INITIALIZATION3 = "CREATE TABLE IF NOT EXISTS                         \n  members(                                         \n    member_id           INTEGER PRIMARY KEY,       \n    schedule_id         INTEGER NOT NULL,          \n    member_name         BLOB NOT NULL,             \n    key_name            BLOB NOT NULL,             \n    pubkey              BLOB NOT NULL,             \n    FOREIGN KEY(schedule_id)                       \n      REFERENCES schedules(schedule_id)            \n      ON DELETE CASCADE                            \n      ON UPDATE CASCADE                            \n  );                                               \n";
    protected static final String INITIALIZATION4 = "CREATE UNIQUE INDEX IF NOT EXISTS                  \n   memNameIndex ON members(member_name);           \n";
    protected static final String PRAGMA_foreign_keys = "PRAGMA foreign_keys = ON";
    protected static final String SELECT_hasSchedule = "SELECT schedule_id FROM schedules where schedule_name=?";
    protected static final String SELECT_listAllScheduleNames = "SELECT schedule_name FROM schedules";
    protected static final String SELECT_getSchedule = "SELECT schedule FROM schedules WHERE schedule_name=?";
    protected static final String SELECT_getScheduleMembers = "SELECT key_name, pubkey FROM members JOIN schedules ON members.schedule_id=schedules.schedule_id WHERE schedule_name=?";
    protected static final String INSERT_addSchedule = "INSERT INTO schedules (schedule_name, schedule) values (?, ?)";
    protected static final String DELETE_deleteSchedule = "DELETE FROM schedules WHERE schedule_name=?";
    protected static final String WHERE_renameSchedule = "schedule_name=?";
    protected static final String UPDATE_renameSchedule = "UPDATE schedules SET schedule_name=? WHERE schedule_name=?";
    protected static final String WHERE_updateSchedule = "schedule_name=?";
    protected static final String UPDATE_updateSchedule = "UPDATE schedules SET schedule=? WHERE schedule_name=?";
    protected static final String SELECT_getScheduleId = "SELECT schedule_id FROM schedules WHERE schedule_name=?";
    protected static final String SELECT_hasMember = "SELECT member_id FROM members WHERE member_name=?";
    protected static final String SELECT_listAllMembers = "SELECT member_name FROM members";
    protected static final String SELECT_getMemberSchedule = "SELECT schedule_name FROM schedules JOIN members ON schedules.schedule_id = members.schedule_id WHERE member_name=?";
    protected static final String INSERT_addMember = "INSERT INTO members(schedule_id, member_name, key_name, pubkey) values (?, ?, ?, ?)";
    protected static final String UPDATE_updateMemberSchedule = "UPDATE members SET schedule_id=? WHERE member_name=?";
    protected static final String DELETE_deleteMember = "DELETE FROM members WHERE member_name=?";

    protected static void checkAddSchedule(String name) throws GroupManagerDb.Error {
        if (name.length() == 0) {
            throw new GroupManagerDb.Error("addSchedule: The schedule name cannot be empty");
        }
    }

    protected static void checkRenameSchedule(String newName) throws GroupManagerDb.Error {
        if (newName.length() == 0) {
            throw new GroupManagerDb.Error("renameSchedule: The schedule newName cannot be empty");
        }
    }
}

