/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.TlvWireFormat;
import net.named_data.jndn.encrypt.ConsumerDb;
import net.named_data.jndn.encrypt.Sqlite3ConsumerDbBase;
import net.named_data.jndn.util.Blob;

public class Sqlite3ConsumerDb
extends Sqlite3ConsumerDbBase {
    Connection database_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sqlite3ConsumerDb(String databaseFilePath) throws ConsumerDb.Error {
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Sqlite3ConsumerDb.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        try {
            this.database_ = DriverManager.getConnection("jdbc:sqlite:" + databaseFilePath);
            try (Statement statement = this.database_.createStatement();){
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS                         \n  decryptionkeys(                                  \n    key_id              INTEGER PRIMARY KEY,       \n    key_name            BLOB NOT NULL,             \n    key_buf             BLOB NOT NULL              \n  );                                               \n");
                statement.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS                  \n   KeyNameIndex ON decryptionkeys(key_name);       \n");
            }
        }
        catch (SQLException exception) {
            throw new ConsumerDb.Error("Sqlite3ConsumerDb: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getKey(Name keyName) throws ConsumerDb.Error {
        try {
            PreparedStatement statement = this.database_.prepareStatement("SELECT key_buf FROM decryptionkeys WHERE key_name=?");
            statement.setBytes(1, keyName.wireEncode(TlvWireFormat.get()).getImmutableArray());
            Blob key = new Blob();
            try {
                ResultSet result = statement.executeQuery();
                if (result.next()) {
                    key = new Blob(result.getBytes(1));
                }
            }
            finally {
                statement.close();
            }
            return key;
        }
        catch (SQLException exception) {
            throw new ConsumerDb.Error("Sqlite3ConsumerDb.getKey: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKey(Name keyName, Blob keyBlob) throws ConsumerDb.Error {
        try {
            PreparedStatement statement = this.database_.prepareStatement("INSERT INTO decryptionkeys(key_name, key_buf) values (?, ?)");
            statement.setBytes(1, keyName.wireEncode(TlvWireFormat.get()).getImmutableArray());
            statement.setBytes(2, keyBlob.getImmutableArray());
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new ConsumerDb.Error("Sqlite3ConsumerDb.addKey: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteKey(Name keyName) throws ConsumerDb.Error {
        try {
            statement.setBytes(1, keyName.wireEncode(TlvWireFormat.get()).getImmutableArray());
            try (PreparedStatement statement = this.database_.prepareStatement("DELETE FROM decryptionkeys WHERE key_name=?");){
                statement.executeUpdate();
            }
        }
        catch (SQLException exception) {
            throw new ConsumerDb.Error("Sqlite3ConsumerDb.deleteKey: SQLite error: " + exception);
        }
    }
}

