/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encoding;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import net.named_data.jndn.ContentType;
import net.named_data.jndn.ControlParameters;
import net.named_data.jndn.Data;
import net.named_data.jndn.DelegationSet;
import net.named_data.jndn.DigestSha256Signature;
import net.named_data.jndn.Exclude;
import net.named_data.jndn.ForwardingFlags;
import net.named_data.jndn.Interest;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.LocalControlHeader;
import net.named_data.jndn.MetaInfo;
import net.named_data.jndn.Name;
import net.named_data.jndn.Sha256WithEcdsaSignature;
import net.named_data.jndn.Sha256WithRsaSignature;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.SignatureHolder;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.tlv.TlvDecoder;
import net.named_data.jndn.encoding.tlv.TlvEncoder;
import net.named_data.jndn.encrypt.EncryptedContent;
import net.named_data.jndn.encrypt.algo.EncryptAlgorithmType;
import net.named_data.jndn.util.Blob;

public class Tlv0_1_1WireFormat
extends WireFormat {
    private static final SecureRandom random_ = new SecureRandom();
    private static Tlv0_1_1WireFormat instance_ = new Tlv0_1_1WireFormat();

    @Override
    public Blob encodeName(Name name) {
        TlvEncoder encoder = new TlvEncoder();
        Tlv0_1_1WireFormat.encodeName(name, new int[1], new int[1], encoder);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeName(Name name, ByteBuffer input) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        Tlv0_1_1WireFormat.decodeName(name, new int[1], new int[1], decoder);
    }

    @Override
    public Blob encodeInterest(Interest interest, int[] signedPortionBeginOffset, int[] signedPortionEndOffset) {
        ByteBuffer nonce;
        TlvEncoder encoder = new TlvEncoder();
        int saveLength = encoder.getLength();
        encoder.writeOptionalNonNegativeIntegerTlv(32, interest.getSelectedDelegationIndex());
        try {
            Blob linkWireEncoding = interest.getLinkWireEncoding(this);
            if (!linkWireEncoding.isNull()) {
                encoder.writeBuffer(linkWireEncoding.buf());
            }
        }
        catch (EncodingException ex) {
            throw new Error(ex.getMessage());
        }
        encoder.writeOptionalNonNegativeIntegerTlvFromDouble(12, interest.getInterestLifetimeMilliseconds());
        if (interest.getNonce().size() == 0) {
            nonce = ByteBuffer.allocate(4);
            random_.nextBytes(nonce.array());
            encoder.writeBlobTlv(10, nonce);
        } else if (interest.getNonce().size() < 4) {
            nonce = ByteBuffer.allocate(4);
            nonce.put(interest.getNonce().buf());
            for (int i = 0; i < 4 - interest.getNonce().size(); ++i) {
                nonce.put((byte)random_.nextInt());
            }
            nonce.flip();
            encoder.writeBlobTlv(10, nonce);
        } else if (interest.getNonce().size() == 4) {
            encoder.writeBlobTlv(10, interest.getNonce().buf());
        } else {
            nonce = interest.getNonce().buf();
            nonce.limit(nonce.position() + 4);
            encoder.writeBlobTlv(10, nonce);
        }
        Tlv0_1_1WireFormat.encodeSelectors(interest, encoder);
        int[] tempSignedPortionBeginOffset = new int[1];
        int[] tempSignedPortionEndOffset = new int[1];
        Tlv0_1_1WireFormat.encodeName(interest.getName(), tempSignedPortionBeginOffset, tempSignedPortionEndOffset, encoder);
        int signedPortionBeginOffsetFromBack = encoder.getLength() - tempSignedPortionBeginOffset[0];
        int signedPortionEndOffsetFromBack = encoder.getLength() - tempSignedPortionEndOffset[0];
        encoder.writeTypeAndLength(5, encoder.getLength() - saveLength);
        signedPortionBeginOffset[0] = encoder.getLength() - signedPortionBeginOffsetFromBack;
        signedPortionEndOffset[0] = encoder.getLength() - signedPortionEndOffsetFromBack;
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeInterest(Interest interest, ByteBuffer input, int[] signedPortionBeginOffset, int[] signedPortionEndOffset) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = decoder.readNestedTlvsStart(5);
        Tlv0_1_1WireFormat.decodeName(interest.getName(), signedPortionBeginOffset, signedPortionEndOffset, decoder);
        if (decoder.peekType(9, endOffset)) {
            Tlv0_1_1WireFormat.decodeSelectors(interest, decoder);
        }
        ByteBuffer nonce = decoder.readBlobTlv(10);
        interest.setInterestLifetimeMilliseconds(decoder.readOptionalNonNegativeIntegerTlv(12, endOffset));
        if (decoder.peekType(6, endOffset)) {
            int linkBeginOffset = decoder.getOffset();
            int linkEndOffset = decoder.readNestedTlvsStart(6);
            decoder.seek(linkEndOffset);
            ByteBuffer linkEncoding = input.duplicate();
            linkEncoding.limit(linkEndOffset);
            linkEncoding.position(linkBeginOffset);
            interest.setLinkWireEncoding(new Blob(linkEncoding, true), this);
        } else {
            interest.unsetLink();
        }
        interest.setSelectedDelegationIndex((int)decoder.readOptionalNonNegativeIntegerTlv(32, endOffset));
        if (interest.getSelectedDelegationIndex() >= 0 && !interest.hasLink()) {
            throw new EncodingException("Interest has a selected delegation, but no link object");
        }
        interest.setNonce(new Blob(nonce, true));
        decoder.finishNestedTlvs(endOffset);
    }

    @Override
    public Blob encodeData(Data data, int[] signedPortionBeginOffset, int[] signedPortionEndOffset) {
        TlvEncoder encoder = new TlvEncoder(1500);
        int saveLength = encoder.getLength();
        encoder.writeBlobTlv(23, data.getSignature().getSignature().buf());
        int signedPortionEndOffsetFromBack = encoder.getLength();
        this.encodeSignatureInfo(data.getSignature(), encoder);
        encoder.writeBlobTlv(21, data.getContent().buf());
        Tlv0_1_1WireFormat.encodeMetaInfo(data.getMetaInfo(), encoder);
        Tlv0_1_1WireFormat.encodeName(data.getName(), new int[1], new int[1], encoder);
        int signedPortionBeginOffsetFromBack = encoder.getLength();
        encoder.writeTypeAndLength(6, encoder.getLength() - saveLength);
        signedPortionBeginOffset[0] = encoder.getLength() - signedPortionBeginOffsetFromBack;
        signedPortionEndOffset[0] = encoder.getLength() - signedPortionEndOffsetFromBack;
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeData(Data data, ByteBuffer input, int[] signedPortionBeginOffset, int[] signedPortionEndOffset) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = decoder.readNestedTlvsStart(6);
        signedPortionBeginOffset[0] = decoder.getOffset();
        Tlv0_1_1WireFormat.decodeName(data.getName(), new int[1], new int[1], decoder);
        Tlv0_1_1WireFormat.decodeMetaInfo(data.getMetaInfo(), decoder);
        data.setContent(new Blob(decoder.readBlobTlv(21), true));
        Tlv0_1_1WireFormat.decodeSignatureInfo(data, decoder);
        signedPortionEndOffset[0] = decoder.getOffset();
        data.getSignature().setSignature(new Blob(decoder.readBlobTlv(23), true));
        decoder.finishNestedTlvs(endOffset);
    }

    @Override
    public Blob encodeControlParameters(ControlParameters controlParameters) {
        int flags;
        TlvEncoder encoder = new TlvEncoder(256);
        int saveLength = encoder.getLength();
        encoder.writeOptionalNonNegativeIntegerTlvFromDouble(109, controlParameters.getExpirationPeriod());
        if (controlParameters.getStrategy().size() != 0) {
            int strategySaveLength = encoder.getLength();
            Tlv0_1_1WireFormat.encodeName(controlParameters.getStrategy(), new int[1], new int[1], encoder);
            encoder.writeTypeAndLength(107, encoder.getLength() - strategySaveLength);
        }
        if ((flags = controlParameters.getForwardingFlags().getNfdForwardingFlags()) != new ForwardingFlags().getNfdForwardingFlags()) {
            encoder.writeNonNegativeIntegerTlv(108, flags);
        }
        encoder.writeOptionalNonNegativeIntegerTlv(106, controlParameters.getCost());
        encoder.writeOptionalNonNegativeIntegerTlv(111, controlParameters.getOrigin());
        encoder.writeOptionalNonNegativeIntegerTlv(110, controlParameters.getLocalControlFeature());
        if (controlParameters.getUri().length() != 0) {
            encoder.writeBlobTlv(114, new Blob(controlParameters.getUri()).buf());
        }
        encoder.writeOptionalNonNegativeIntegerTlv(105, controlParameters.getFaceId());
        if (controlParameters.getName() != null) {
            Tlv0_1_1WireFormat.encodeName(controlParameters.getName(), new int[1], new int[1], encoder);
        }
        encoder.writeTypeAndLength(104, encoder.getLength() - saveLength);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeControlParameters(ControlParameters controlParameters, ByteBuffer input) throws EncodingException {
        controlParameters.clear();
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = decoder.readNestedTlvsStart(104);
        if (decoder.peekType(7, endOffset)) {
            Name name = new Name();
            Tlv0_1_1WireFormat.decodeName(name, new int[1], new int[1], decoder);
            controlParameters.setName(name);
        }
        controlParameters.setFaceId((int)decoder.readOptionalNonNegativeIntegerTlv(105, endOffset));
        if (decoder.peekType(114, endOffset)) {
            Blob uri = new Blob(decoder.readOptionalBlobTlv(114, endOffset), true);
            controlParameters.setUri("" + uri);
        }
        controlParameters.setLocalControlFeature((int)decoder.readOptionalNonNegativeIntegerTlv(110, endOffset));
        controlParameters.setOrigin((int)decoder.readOptionalNonNegativeIntegerTlv(111, endOffset));
        controlParameters.setCost((int)decoder.readOptionalNonNegativeIntegerTlv(106, endOffset));
        if (decoder.peekType(108, endOffset)) {
            ForwardingFlags flags = new ForwardingFlags();
            flags.setNfdForwardingFlags((int)decoder.readNonNegativeIntegerTlv(108));
            controlParameters.setForwardingFlags(flags);
        }
        if (decoder.peekType(107, endOffset)) {
            int strategyEndOffset = decoder.readNestedTlvsStart(107);
            Tlv0_1_1WireFormat.decodeName(controlParameters.getStrategy(), new int[1], new int[1], decoder);
            decoder.finishNestedTlvs(strategyEndOffset);
        }
        controlParameters.setExpirationPeriod(decoder.readOptionalNonNegativeIntegerTlv(109, endOffset));
        decoder.finishNestedTlvs(endOffset);
    }

    @Override
    public Blob encodeSignatureInfo(Signature signature) {
        TlvEncoder encoder = new TlvEncoder(256);
        this.encodeSignatureInfo(signature, encoder);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public Signature decodeSignatureInfoAndValue(ByteBuffer signatureInfo, ByteBuffer signatureValue) throws EncodingException {
        SimpleSignatureHolder signatureHolder = new SimpleSignatureHolder();
        TlvDecoder decoder = new TlvDecoder(signatureInfo);
        Tlv0_1_1WireFormat.decodeSignatureInfo(signatureHolder, decoder);
        decoder = new TlvDecoder(signatureValue);
        signatureHolder.getSignature().setSignature(new Blob(decoder.readBlobTlv(23), true));
        return signatureHolder.getSignature();
    }

    @Override
    public Blob encodeSignatureValue(Signature signature) {
        TlvEncoder encoder = new TlvEncoder(256);
        encoder.writeBlobTlv(23, signature.getSignature().buf());
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public Blob encodeLocalControlHeader(LocalControlHeader localControlHeader) {
        TlvEncoder encoder = new TlvEncoder(256);
        int saveLength = encoder.getLength();
        encoder.writeBuffer(localControlHeader.getPayloadWireEncoding().buf());
        encoder.writeOptionalNonNegativeIntegerTlv(82, localControlHeader.getNextHopFaceId());
        encoder.writeOptionalNonNegativeIntegerTlv(81, localControlHeader.getIncomingFaceId());
        encoder.writeTypeAndLength(80, encoder.getLength() - saveLength);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeLocalControlHeader(LocalControlHeader localControlHeader, ByteBuffer input) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = decoder.readNestedTlvsStart(80);
        localControlHeader.setIncomingFaceId(decoder.readOptionalNonNegativeIntegerTlv(81, endOffset));
        localControlHeader.setNextHopFaceId(decoder.readOptionalNonNegativeIntegerTlv(82, endOffset));
        if (decoder.peekType(83, endOffset)) {
            int cachingPolicyEndOffset = decoder.readNestedTlvsStart(83);
            decoder.finishNestedTlvs(cachingPolicyEndOffset);
        }
        ByteBuffer payload = input.duplicate();
        payload.limit(endOffset);
        payload.position(decoder.getOffset());
        localControlHeader.setPayloadWireEncoding(new Blob(payload, false));
    }

    @Override
    public Blob encodeDelegationSet(DelegationSet delegationSet) {
        TlvEncoder encoder = new TlvEncoder(256);
        for (int i = delegationSet.size() - 1; i >= 0; --i) {
            int saveLength = encoder.getLength();
            Tlv0_1_1WireFormat.encodeName(delegationSet.get(i).getName(), new int[1], new int[1], encoder);
            encoder.writeNonNegativeIntegerTlv(30, delegationSet.get(i).getPreference());
            encoder.writeTypeAndLength(31, encoder.getLength() - saveLength);
        }
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeDelegationSet(DelegationSet delegationSet, ByteBuffer input) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = input.limit();
        delegationSet.clear();
        while (decoder.getOffset() < endOffset) {
            decoder.readTypeAndLength(31);
            int preference = (int)decoder.readNonNegativeIntegerTlv(30);
            Name name = new Name();
            Tlv0_1_1WireFormat.decodeName(name, new int[1], new int[1], decoder);
            delegationSet.addUnsorted(preference, name);
        }
    }

    @Override
    public Blob encodeEncryptedContent(EncryptedContent encryptedContent) {
        TlvEncoder encoder = new TlvEncoder(256);
        int saveLength = encoder.getLength();
        encoder.writeBlobTlv(132, encryptedContent.getPayload().buf());
        encoder.writeOptionalBlobTlv(133, encryptedContent.getInitialVector().buf());
        encoder.writeNonNegativeIntegerTlv(131, encryptedContent.getAlgorithmType().getNumericType());
        Tlv0_1_1WireFormat.encodeKeyLocator(28, encryptedContent.getKeyLocator(), encoder);
        encoder.writeTypeAndLength(130, encoder.getLength() - saveLength);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeEncryptedContent(EncryptedContent encryptedContent, ByteBuffer input) throws EncodingException {
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = decoder.readNestedTlvsStart(130);
        Tlv0_1_1WireFormat.decodeKeyLocator(28, encryptedContent.getKeyLocator(), decoder);
        int algorithmType = (int)decoder.readNonNegativeIntegerTlv(131);
        if (algorithmType == EncryptAlgorithmType.AesEcb.getNumericType()) {
            encryptedContent.setAlgorithmType(EncryptAlgorithmType.AesEcb);
        } else if (algorithmType == EncryptAlgorithmType.AesCbc.getNumericType()) {
            encryptedContent.setAlgorithmType(EncryptAlgorithmType.AesCbc);
        } else if (algorithmType == EncryptAlgorithmType.RsaPkcs.getNumericType()) {
            encryptedContent.setAlgorithmType(EncryptAlgorithmType.RsaPkcs);
        } else if (algorithmType == EncryptAlgorithmType.RsaOaep.getNumericType()) {
            encryptedContent.setAlgorithmType(EncryptAlgorithmType.RsaOaep);
        } else {
            throw new EncodingException("Unrecognized EncryptionAlgorithm code " + algorithmType);
        }
        encryptedContent.setInitialVector(new Blob(decoder.readOptionalBlobTlv(133, endOffset), true));
        encryptedContent.setPayload(new Blob(decoder.readBlobTlv(132), true));
        decoder.finishNestedTlvs(endOffset);
    }

    public static Tlv0_1_1WireFormat get() {
        return instance_;
    }

    private static void encodeName(Name name, int[] signedPortionBeginOffset, int[] signedPortionEndOffset, TlvEncoder encoder) {
        int saveLength = encoder.getLength();
        int signedPortionEndOffsetFromBack = 0;
        for (int i = name.size() - 1; i >= 0; --i) {
            encoder.writeBlobTlv(8, name.get(i).getValue().buf());
            if (i != name.size() - 1) continue;
            signedPortionEndOffsetFromBack = encoder.getLength();
        }
        int signedPortionBeginOffsetFromBack = encoder.getLength();
        encoder.writeTypeAndLength(7, encoder.getLength() - saveLength);
        signedPortionBeginOffset[0] = encoder.getLength() - signedPortionBeginOffsetFromBack;
        signedPortionEndOffset[0] = name.size() == 0 ? signedPortionBeginOffset[0] : encoder.getLength() - signedPortionEndOffsetFromBack;
    }

    private static void decodeName(Name name, int[] signedPortionBeginOffset, int[] signedPortionEndOffset, TlvDecoder decoder) throws EncodingException {
        name.clear();
        int endOffset = decoder.readNestedTlvsStart(7);
        signedPortionBeginOffset[0] = decoder.getOffset();
        signedPortionEndOffset[0] = signedPortionBeginOffset[0];
        while (decoder.getOffset() < endOffset) {
            signedPortionEndOffset[0] = decoder.getOffset();
            name.append(new Blob(decoder.readBlobTlv(8), true));
        }
        decoder.finishNestedTlvs(endOffset);
    }

    private static void encodeSelectors(Interest interest, TlvEncoder encoder) {
        int saveLength = encoder.getLength();
        if (interest.getMustBeFresh()) {
            encoder.writeTypeAndLength(18, 0);
        }
        encoder.writeOptionalNonNegativeIntegerTlv(17, interest.getChildSelector());
        if (interest.getExclude().size() > 0) {
            Tlv0_1_1WireFormat.encodeExclude(interest.getExclude(), encoder);
        }
        if (interest.getKeyLocator().getType() != KeyLocatorType.NONE) {
            Tlv0_1_1WireFormat.encodeKeyLocator(15, interest.getKeyLocator(), encoder);
        }
        encoder.writeOptionalNonNegativeIntegerTlv(14, interest.getMaxSuffixComponents());
        encoder.writeOptionalNonNegativeIntegerTlv(13, interest.getMinSuffixComponents());
        if (encoder.getLength() != saveLength) {
            encoder.writeTypeAndLength(9, encoder.getLength() - saveLength);
        }
    }

    private static void decodeSelectors(Interest interest, TlvDecoder decoder) throws EncodingException {
        int endOffset = decoder.readNestedTlvsStart(9);
        interest.setMinSuffixComponents((int)decoder.readOptionalNonNegativeIntegerTlv(13, endOffset));
        interest.setMaxSuffixComponents((int)decoder.readOptionalNonNegativeIntegerTlv(14, endOffset));
        if (decoder.peekType(15, endOffset)) {
            Tlv0_1_1WireFormat.decodeKeyLocator(15, interest.getKeyLocator(), decoder);
        } else {
            interest.getKeyLocator().clear();
        }
        if (decoder.peekType(16, endOffset)) {
            Tlv0_1_1WireFormat.decodeExclude(interest.getExclude(), decoder);
        } else {
            interest.getExclude().clear();
        }
        interest.setChildSelector((int)decoder.readOptionalNonNegativeIntegerTlv(17, endOffset));
        interest.setMustBeFresh(decoder.readBooleanTlv(18, endOffset));
        decoder.finishNestedTlvs(endOffset);
    }

    private static void encodeExclude(Exclude exclude, TlvEncoder encoder) {
        int saveLength = encoder.getLength();
        for (int i = exclude.size() - 1; i >= 0; --i) {
            Exclude.Entry entry = exclude.get(i);
            if (entry.getType() == Exclude.Type.ANY) {
                encoder.writeTypeAndLength(19, 0);
                continue;
            }
            encoder.writeBlobTlv(8, entry.getComponent().getValue().buf());
        }
        encoder.writeTypeAndLength(16, encoder.getLength() - saveLength);
    }

    private static void decodeExclude(Exclude exclude, TlvDecoder decoder) throws EncodingException {
        int endOffset = decoder.readNestedTlvsStart(16);
        exclude.clear();
        while (true) {
            if (decoder.peekType(8, endOffset)) {
                exclude.appendComponent(new Name.Component(new Blob(decoder.readBlobTlv(8), true)));
                continue;
            }
            if (!decoder.readBooleanTlv(19, endOffset)) break;
            exclude.appendAny();
        }
        decoder.finishNestedTlvs(endOffset);
    }

    private static void encodeKeyLocator(int type, KeyLocator keyLocator, TlvEncoder encoder) {
        int saveLength = encoder.getLength();
        if (keyLocator.getType() != KeyLocatorType.NONE) {
            if (keyLocator.getType() == KeyLocatorType.KEYNAME) {
                Tlv0_1_1WireFormat.encodeName(keyLocator.getKeyName(), new int[1], new int[1], encoder);
            } else if (keyLocator.getType() == KeyLocatorType.KEY_LOCATOR_DIGEST && keyLocator.getKeyData().size() > 0) {
                encoder.writeBlobTlv(29, keyLocator.getKeyData().buf());
            } else {
                throw new Error("Unrecognized KeyLocatorType " + (Object)((Object)keyLocator.getType()));
            }
        }
        encoder.writeTypeAndLength(type, encoder.getLength() - saveLength);
    }

    private static void decodeKeyLocator(int expectedType, KeyLocator keyLocator, TlvDecoder decoder) throws EncodingException {
        int endOffset = decoder.readNestedTlvsStart(expectedType);
        keyLocator.clear();
        if (decoder.getOffset() == endOffset) {
            return;
        }
        if (decoder.peekType(7, endOffset)) {
            keyLocator.setType(KeyLocatorType.KEYNAME);
            Tlv0_1_1WireFormat.decodeName(keyLocator.getKeyName(), new int[1], new int[1], decoder);
        } else if (decoder.peekType(29, endOffset)) {
            keyLocator.setType(KeyLocatorType.KEY_LOCATOR_DIGEST);
            keyLocator.setKeyData(new Blob(decoder.readBlobTlv(29), true));
        } else {
            throw new EncodingException("decodeKeyLocator: Unrecognized key locator type");
        }
        decoder.finishNestedTlvs(endOffset);
    }

    private void encodeSignatureInfo(Signature signature, TlvEncoder encoder) {
        int saveLength = encoder.getLength();
        if (signature instanceof Sha256WithRsaSignature) {
            Tlv0_1_1WireFormat.encodeKeyLocator(28, ((Sha256WithRsaSignature)signature).getKeyLocator(), encoder);
            encoder.writeNonNegativeIntegerTlv(27, 1L);
        } else if (signature instanceof Sha256WithEcdsaSignature) {
            Tlv0_1_1WireFormat.encodeKeyLocator(28, ((Sha256WithEcdsaSignature)signature).getKeyLocator(), encoder);
            encoder.writeNonNegativeIntegerTlv(27, 3L);
        } else if (signature instanceof DigestSha256Signature) {
            encoder.writeNonNegativeIntegerTlv(27, 0L);
        } else {
            throw new Error("encodeSignatureInfo: Unrecognized Signature object type");
        }
        encoder.writeTypeAndLength(22, encoder.getLength() - saveLength);
    }

    private static void decodeSignatureInfo(SignatureHolder signatureHolder, TlvDecoder decoder) throws EncodingException {
        int endOffset = decoder.readNestedTlvsStart(22);
        int signatureType = (int)decoder.readNonNegativeIntegerTlv(27);
        if (signatureType == 1) {
            signatureHolder.setSignature(new Sha256WithRsaSignature());
            Sha256WithRsaSignature signatureInfo = (Sha256WithRsaSignature)signatureHolder.getSignature();
            Tlv0_1_1WireFormat.decodeKeyLocator(28, signatureInfo.getKeyLocator(), decoder);
        } else if (signatureType == 3) {
            signatureHolder.setSignature(new Sha256WithEcdsaSignature());
            Sha256WithEcdsaSignature signatureInfo = (Sha256WithEcdsaSignature)signatureHolder.getSignature();
            Tlv0_1_1WireFormat.decodeKeyLocator(28, signatureInfo.getKeyLocator(), decoder);
        } else if (signatureType == 0) {
            signatureHolder.setSignature(new DigestSha256Signature());
        } else {
            throw new EncodingException("decodeSignatureInfo: unrecognized SignatureInfo type" + signatureType);
        }
        decoder.finishNestedTlvs(endOffset);
    }

    private static void encodeMetaInfo(MetaInfo metaInfo, TlvEncoder encoder) {
        int saveLength = encoder.getLength();
        ByteBuffer finalBlockIdBuf = metaInfo.getFinalBlockId().getValue().buf();
        if (finalBlockIdBuf != null && finalBlockIdBuf.remaining() > 0) {
            int finalBlockIdSaveLength = encoder.getLength();
            encoder.writeBlobTlv(8, finalBlockIdBuf);
            encoder.writeTypeAndLength(26, encoder.getLength() - finalBlockIdSaveLength);
        }
        encoder.writeOptionalNonNegativeIntegerTlvFromDouble(25, metaInfo.getFreshnessPeriod());
        if (metaInfo.getType() != ContentType.BLOB) {
            if (metaInfo.getType() == ContentType.LINK || metaInfo.getType() == ContentType.KEY || metaInfo.getType() == ContentType.NACK) {
                encoder.writeNonNegativeIntegerTlv(24, metaInfo.getType().getNumericType());
            } else {
                throw new Error("unrecognized TLV ContentType");
            }
        }
        encoder.writeTypeAndLength(20, encoder.getLength() - saveLength);
    }

    private static void decodeMetaInfo(MetaInfo metaInfo, TlvDecoder decoder) throws EncodingException {
        int endOffset = decoder.readNestedTlvsStart(20);
        int type = (int)decoder.readOptionalNonNegativeIntegerTlv(24, endOffset);
        if (type == ContentType.LINK.getNumericType()) {
            metaInfo.setType(ContentType.LINK);
        } else if (type == ContentType.KEY.getNumericType()) {
            metaInfo.setType(ContentType.KEY);
        } else if (type == ContentType.NACK.getNumericType()) {
            metaInfo.setType(ContentType.NACK);
        } else {
            metaInfo.setType(ContentType.BLOB);
        }
        metaInfo.setFreshnessPeriod(decoder.readOptionalNonNegativeIntegerTlv(25, endOffset));
        if (decoder.peekType(26, endOffset)) {
            int finalBlockIdEndOffset = decoder.readNestedTlvsStart(26);
            metaInfo.setFinalBlockId(new Name.Component(new Blob(decoder.readBlobTlv(8), true)));
            decoder.finishNestedTlvs(finalBlockIdEndOffset);
        } else {
            metaInfo.setFinalBlockId(null);
        }
        decoder.finishNestedTlvs(endOffset);
    }

    private static class SimpleSignatureHolder
    implements SignatureHolder {
        private Signature signature_;

        private SimpleSignatureHolder() {
        }

        @Override
        public Data setSignature(Signature signature) {
            this.signature_ = signature;
            return null;
        }

        @Override
        public Signature getSignature() {
            return this.signature_;
        }
    }
}

