/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.tlv.TlvEncoder;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.ChangeCountable;

public class Name
implements ChangeCountable,
Comparable {
    private final ArrayList components_;
    private long changeCount_ = 0L;
    private boolean haveHashCode_ = false;
    private int hashCode_;
    private long hashCodeChangeCount_ = 0L;

    public Name() {
        this.components_ = new ArrayList();
    }

    public Name(Name name) {
        this.components_ = new ArrayList(name.components_);
    }

    public Name(ArrayList components) {
        this.components_ = new ArrayList(components);
    }

    public Name(Component[] components) {
        this.components_ = new ArrayList();
        for (int i = 0; i < components.length; ++i) {
            this.components_.add(components[i]);
        }
    }

    public Name(String uri) {
        this.components_ = new ArrayList();
        this.set(uri);
    }

    public final int size() {
        return this.components_.size();
    }

    public final Component get(int i) {
        if (i >= 0) {
            return (Component)this.components_.get(i);
        }
        return (Component)this.components_.get(this.components_.size() - -i);
    }

    public final void set(String uri) {
        int iFirstSlash;
        this.clear();
        uri = uri.trim();
        if (uri.length() == 0) {
            return;
        }
        int iColon = uri.indexOf(58);
        if (iColon >= 0 && ((iFirstSlash = uri.indexOf(47)) < 0 || iColon < iFirstSlash)) {
            uri = uri.substring(iColon + 1).trim();
        }
        if (uri.charAt(0) == '/') {
            if (uri.length() >= 2 && uri.charAt(1) == '/') {
                int iAfterAuthority = uri.indexOf(47, 2);
                if (iAfterAuthority < 0) {
                    return;
                }
                uri = uri.substring(iAfterAuthority + 1).trim();
            } else {
                uri = uri.substring(1).trim();
            }
        }
        int iComponentStart = 0;
        while (iComponentStart < uri.length()) {
            Component component;
            int iComponentEnd = uri.indexOf("/", iComponentStart);
            if (iComponentEnd < 0) {
                iComponentEnd = uri.length();
            }
            if (!(component = new Component(Name.fromEscapedString(uri, iComponentStart, iComponentEnd))).getValue().isNull()) {
                this.append(component);
            }
            iComponentStart = iComponentEnd + 1;
        }
    }

    public final void clear() {
        this.components_.clear();
        ++this.changeCount_;
    }

    public final Name append(byte[] value) {
        return this.append(new Component(value));
    }

    public final Name append(Blob value) {
        return this.append(new Component(value));
    }

    public final Name append(Component component) {
        this.components_.add(component);
        ++this.changeCount_;
        return this;
    }

    public final Name append(Name name) {
        if (name == this) {
            return this.append(new Name(name));
        }
        for (int i = 0; i < name.components_.size(); ++i) {
            this.append(name.get(i));
        }
        return this;
    }

    public final Name append(String value) {
        return this.append(new Component(value));
    }

    public final Name getSubName(int iStartComponent, int nComponents) {
        if (iStartComponent < 0) {
            iStartComponent = this.components_.size() - -iStartComponent;
        }
        Name result = new Name();
        int iEnd = iStartComponent + nComponents;
        for (int i = iStartComponent; i < iEnd && i < this.components_.size(); ++i) {
            result.components_.add(this.components_.get(i));
        }
        return result;
    }

    public final Name getSubName(int iStartComponent) {
        if (iStartComponent < 0) {
            iStartComponent = this.components_.size() - -iStartComponent;
        }
        Name result = new Name();
        for (int i = iStartComponent; i < this.components_.size(); ++i) {
            result.components_.add(this.components_.get(i));
        }
        return result;
    }

    public final Name getPrefix(int nComponents) {
        if (nComponents < 0) {
            return this.getSubName(0, this.components_.size() + nComponents);
        }
        return this.getSubName(0, nComponents);
    }

    public final String toUri(boolean includeScheme) {
        if (this.components_.isEmpty()) {
            return includeScheme ? "ndn:/" : "/";
        }
        StringBuffer result = new StringBuffer();
        if (includeScheme) {
            result.append("ndn:");
        }
        for (int i = 0; i < this.components_.size(); ++i) {
            result.append("/");
            Name.toEscapedString(this.get(i).getValue().buf(), result);
        }
        return result.toString();
    }

    public final String toUri() {
        return this.toUri(false);
    }

    public String toString() {
        return this.toUri();
    }

    public final Name appendSegment(long segment) {
        return this.append(Component.fromNumberWithMarker(segment, 0));
    }

    public final Name appendSegmentOffset(long segmentOffset) {
        return this.append(Component.fromNumberWithMarker(segmentOffset, 251));
    }

    public final Name appendVersion(long version) {
        return this.append(Component.fromNumberWithMarker(version, 253));
    }

    public final Name appendTimestamp(long timestamp) {
        return this.append(Component.fromNumberWithMarker(timestamp, 252));
    }

    public final Name appendSequenceNumber(long sequenceNumber) {
        return this.append(Component.fromNumberWithMarker(sequenceNumber, 254));
    }

    public boolean equals(Name name) {
        if (this.components_.size() != name.components_.size()) {
            return false;
        }
        for (int i = this.components_.size() - 1; i >= 0; --i) {
            if (this.get(i).getValue().equals(name.get(i).getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Name)) {
            return false;
        }
        return this.equals((Name)other);
    }

    public int hashCode() {
        if (this.hashCodeChangeCount_ != this.getChangeCount()) {
            this.haveHashCode_ = false;
            this.hashCodeChangeCount_ = this.getChangeCount();
        }
        if (!this.haveHashCode_) {
            int hashCode = 0;
            for (int i = 0; i < this.components_.size(); ++i) {
                hashCode = 37 * hashCode + ((Component)this.components_.get(i)).hashCode();
            }
            this.hashCode_ = hashCode;
            this.haveHashCode_ = true;
        }
        return this.hashCode_;
    }

    public final boolean match(Name name) {
        if (this.components_.size() > name.components_.size()) {
            return false;
        }
        for (int i = this.components_.size() - 1; i >= 0; --i) {
            if (this.get(i).getValue().equals(name.get(i).getValue())) continue;
            return false;
        }
        return true;
    }

    public final Blob wireEncode(WireFormat wireFormat) {
        return wireFormat.encodeName(this);
    }

    public final Blob wireEncode() {
        return this.wireEncode(WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(ByteBuffer input, WireFormat wireFormat) throws EncodingException {
        wireFormat.decodeName(this, input);
    }

    public final void wireDecode(ByteBuffer input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        this.wireDecode(input.buf(), wireFormat);
    }

    public final void wireDecode(Blob input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final int compare(Name other) {
        for (int i = 0; i < this.size() && i < other.size(); ++i) {
            int comparison = ((Component)this.components_.get(i)).compare((Component)other.components_.get(i));
            if (comparison == 0) continue;
            return comparison;
        }
        if (this.size() < other.size()) {
            return -1;
        }
        if (this.size() > other.size()) {
            return 1;
        }
        return 0;
    }

    public final int compareTo(Object o) {
        return this.compare((Name)o);
    }

    public final int CompareTo(Object o) {
        return this.compare((Name)o);
    }

    @Override
    public final long getChangeCount() {
        return this.changeCount_;
    }

    public static Blob fromEscapedString(String escapedString, int beginOffset, int endOffset) {
        String trimmedString = escapedString.substring(beginOffset, endOffset).trim();
        ByteBuffer value = Name.unescape(trimmedString);
        boolean gotNonDot = false;
        for (int i = value.position(); i < value.limit(); ++i) {
            if (value.get(i) == 46) continue;
            gotNonDot = true;
            break;
        }
        if (!gotNonDot) {
            if (value.remaining() <= 2) {
                return new Blob();
            }
            value.position(value.position() + 3);
            return new Blob(value, false);
        }
        return new Blob(value, false);
    }

    public static Blob fromEscapedString(String escapedString) {
        return Name.fromEscapedString(escapedString, 0, escapedString.length());
    }

    public static void toEscapedString(ByteBuffer value, StringBuffer result) {
        int i;
        boolean gotNonDot = false;
        for (i = value.position(); i < value.limit(); ++i) {
            if (value.get(i) == 46) continue;
            gotNonDot = true;
            break;
        }
        if (!gotNonDot) {
            result.append("...");
            for (i = value.position(); i < value.limit(); ++i) {
                result.append('.');
            }
        } else {
            for (i = value.position(); i < value.limit(); ++i) {
                int x = value.get(i) & 0xFF;
                if (x >= 48 && x <= 57 || x >= 65 && x <= 90 || x >= 97 && x <= 122 || x == 43 || x == 45 || x == 46 || x == 95) {
                    result.append((char)x);
                    continue;
                }
                result.append('%');
                if (x < 16) {
                    result.append('0');
                }
                result.append(Integer.toHexString(x).toUpperCase());
            }
        }
    }

    public static String toEscapedString(ByteBuffer value) {
        StringBuffer result = new StringBuffer(value.remaining());
        Name.toEscapedString(value, result);
        return result.toString();
    }

    private static int fromHexChar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return -1;
    }

    private static ByteBuffer unescape(String str) {
        ByteBuffer result = ByteBuffer.allocate(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '%' && i + 2 < str.length()) {
                int hi = Name.fromHexChar(str.charAt(i + 1));
                int lo = Name.fromHexChar(str.charAt(i + 2));
                if (hi < 0 || lo < 0) {
                    result.put((byte)str.charAt(i)).put((byte)str.charAt(i + 1)).put((byte)str.charAt(i + 2));
                } else {
                    result.put((byte)(16 * hi + lo));
                }
                i += 2;
                continue;
            }
            result.put((byte)str.charAt(i));
        }
        result.flip();
        return result;
    }

    public static class Component
    implements Comparable {
        private final Blob value_;

        public Component() {
            this.value_ = new Blob(ByteBuffer.allocate(0), false);
        }

        public Component(Blob value) {
            if (value == null) {
                throw new NullPointerException("Component: Blob value may not be null");
            }
            this.value_ = value;
        }

        public Component(Component component) {
            this.value_ = component.value_;
        }

        public Component(byte[] value) {
            this.value_ = new Blob(value);
        }

        public Component(String value) {
            this.value_ = new Blob(value);
        }

        public final Blob getValue() {
            return this.value_;
        }

        public final void toEscapedString(StringBuffer result) {
            Name.toEscapedString(this.value_.buf(), result);
        }

        public final String toEscapedString() {
            return Name.toEscapedString(this.value_.buf());
        }

        public final long toNumber() {
            ByteBuffer buffer = this.value_.buf();
            if (buffer == null) {
                return 0L;
            }
            long result = 0L;
            for (int i = buffer.position(); i < buffer.limit(); ++i) {
                result *= 256L;
                result += (long)(buffer.get(i) & 0xFF);
            }
            return result;
        }

        public final long toNumberWithMarker(int marker) throws EncodingException {
            ByteBuffer buffer = this.value_.buf();
            if (buffer == null || buffer.remaining() <= 0 || buffer.get(0) != (byte)marker) {
                throw new EncodingException("Name component does not begin with the expected marker.");
            }
            long result = 0L;
            for (int i = buffer.position() + 1; i < buffer.limit(); ++i) {
                result *= 256L;
                result += (long)(buffer.get(i) & 0xFF);
            }
            return result;
        }

        public final long toSegment() throws EncodingException {
            return this.toNumberWithMarker(0);
        }

        public final long toSegmentOffset() throws EncodingException {
            return this.toNumberWithMarker(251);
        }

        public final long toVersion() throws EncodingException {
            return this.toNumberWithMarker(253);
        }

        public final long toTimestamp() throws EncodingException {
            return this.toNumberWithMarker(252);
        }

        public final long toSequenceNumber() throws EncodingException {
            return this.toNumberWithMarker(254);
        }

        public static Component fromNumber(long number) {
            if (number < 0L) {
                number = 0L;
            }
            TlvEncoder encoder = new TlvEncoder(8);
            encoder.writeNonNegativeInteger(number);
            return new Component(new Blob(encoder.getOutput(), false));
        }

        public static Component fromNumberWithMarker(long number, int marker) {
            if (number < 0L) {
                number = 0L;
            }
            TlvEncoder encoder = new TlvEncoder(9);
            encoder.writeNonNegativeInteger(number);
            encoder.writeNonNegativeInteger(marker);
            return new Component(new Blob(encoder.getOutput(), false));
        }

        public final boolean equals(Component other) {
            return this.value_.equals(other.value_);
        }

        public boolean equals(Object other) {
            if (!(other instanceof Component)) {
                return false;
            }
            return this.equals((Component)other);
        }

        public int hashCode() {
            return this.value_.hashCode();
        }

        public final int compare(Component other) {
            if (this.value_.size() < other.value_.size()) {
                return -1;
            }
            if (this.value_.size() > other.value_.size()) {
                return 1;
            }
            return this.value_.compare(other.value_);
        }

        public final int compareTo(Object o) {
            return this.compare((Component)o);
        }

        public final int CompareTo(Object o) {
            return this.compare((Component)o);
        }

        private static void reverse(ByteBuffer buffer, int position, int limit) {
            int from = position;
            for (int to = limit - 1; from < to; --to, ++from) {
                byte temp = buffer.get(from);
                buffer.put(from, buffer.get(to));
                buffer.put(to, temp);
            }
        }
    }
}

