/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import net.named_data.jndn.Name;
import net.named_data.jndn.util.Common;
import net.named_data.jndn.util.NdnRegexMatcher;

public class InterestFilter {
    private final Name prefix_;
    private final String regexFilter_;
    private final String regexFilterPattern_;
    private static Common dummyCommon_ = new Common();

    public InterestFilter(Name prefix) {
        this.prefix_ = new Name(prefix);
        this.regexFilter_ = null;
        this.regexFilterPattern_ = null;
    }

    public InterestFilter(String prefixUri) {
        this.prefix_ = new Name(prefixUri);
        this.regexFilter_ = null;
        this.regexFilterPattern_ = null;
    }

    public InterestFilter(Name prefix, String regexFilter) {
        this.prefix_ = new Name(prefix);
        this.regexFilter_ = regexFilter;
        this.regexFilterPattern_ = InterestFilter.makePattern(regexFilter);
    }

    public InterestFilter(String prefixUri, String regexFilter) {
        this.prefix_ = new Name(prefixUri);
        this.regexFilter_ = regexFilter;
        this.regexFilterPattern_ = InterestFilter.makePattern(regexFilter);
    }

    public InterestFilter(InterestFilter interestFilter) {
        this.prefix_ = new Name(interestFilter.prefix_);
        this.regexFilter_ = interestFilter.regexFilter_;
        this.regexFilterPattern_ = interestFilter.regexFilterPattern_;
    }

    public final boolean doesMatch(Name name) {
        if (name.size() < this.prefix_.size()) {
            return false;
        }
        if (this.hasRegexFilter()) {
            if (!this.prefix_.match(name)) {
                return false;
            }
            return null != NdnRegexMatcher.match(this.regexFilterPattern_, name.getSubName(this.prefix_.size()));
        }
        return this.prefix_.match(name);
    }

    public final Name getPrefix() {
        return this.prefix_;
    }

    public final boolean hasRegexFilter() {
        return this.regexFilter_ != null;
    }

    public final String getRegexFilter() {
        return this.regexFilter_;
    }

    private static String makePattern(String regexFilter) {
        String pattern = regexFilter;
        if (!pattern.startsWith("^")) {
            pattern = "^" + pattern;
        }
        if (!pattern.endsWith("$")) {
            pattern = pattern + "$";
        }
        return pattern;
    }
}

