/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import java.nio.ByteBuffer;
import net.named_data.jndn.util.Blob;

public class SignedBlob
extends Blob {
    private ByteBuffer signedBuffer_;
    private int signedPortionBeginOffset_;
    private int signedPortionEndOffset_;

    public SignedBlob() {
    }

    public SignedBlob(SignedBlob signedBlob) {
        super(signedBlob.buf(), false);
        this.signedPortionBeginOffset_ = signedBlob.signedPortionBeginOffset_;
        this.signedPortionEndOffset_ = signedBlob.signedPortionEndOffset_;
        this.setSignedBuffer();
    }

    public SignedBlob(Blob blob, int signedPortionBeginOffset, int signedPortionEndOffset) {
        super(blob);
        this.signedPortionBeginOffset_ = signedPortionBeginOffset;
        this.signedPortionEndOffset_ = signedPortionEndOffset;
        this.setSignedBuffer();
    }

    public SignedBlob(ByteBuffer buffer, boolean copy, int signedPortionBeginOffset, int signedPortionEndOffset) {
        super(buffer, copy);
        this.signedPortionBeginOffset_ = signedPortionBeginOffset;
        this.signedPortionEndOffset_ = signedPortionEndOffset;
        this.setSignedBuffer();
    }

    public SignedBlob(byte[] value, int signedPortionBeginOffset, int signedPortionEndOffset) {
        super(value);
        this.signedPortionBeginOffset_ = signedPortionBeginOffset;
        this.signedPortionEndOffset_ = signedPortionEndOffset;
        this.setSignedBuffer();
    }

    public final int signedSize() {
        if (this.signedBuffer_ != null) {
            return this.signedBuffer_.limit();
        }
        return 0;
    }

    public final ByteBuffer signedBuf() {
        if (this.signedBuffer_ != null) {
            return this.signedBuffer_.asReadOnlyBuffer();
        }
        return null;
    }

    private void setSignedBuffer() {
        if (!this.isNull()) {
            ByteBuffer tempBuffer = this.buf();
            tempBuffer.position(this.signedPortionBeginOffset_);
            tempBuffer.limit(this.signedPortionEndOffset_);
            this.signedBuffer_ = tempBuffer.slice();
        } else {
            this.signedBuffer_ = null;
        }
    }
}

