/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Common {
    public static final int MAX_NDN_PACKET_SIZE = 8800;
    private static Base64ConverterType base64ConverterType_ = Base64ConverterType.UNINITIALIZED;
    private static Class base64Converter_ = null;

    public static double getNowMilliseconds() {
        return System.currentTimeMillis();
    }

    public static byte[] digestSha256(ByteBuffer data) {
        MessageDigest sha256;
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException exception) {
            throw new Error("MessageDigest: SHA-256 is not supported: " + exception.getMessage());
        }
        int savePosition = data.position();
        sha256.update(data);
        data.position(savePosition);
        return sha256.digest();
    }

    public static String toHex(byte[] buffer) {
        StringBuffer output = new StringBuffer(buffer.length * 2);
        for (int i = 0; i < buffer.length; ++i) {
            String hex = Integer.toHexString(buffer[i] & 0xFF);
            if (hex.length() <= 1) {
                output.append("0");
            }
            output.append(hex);
        }
        return output.toString();
    }

    public static String base64Encode(byte[] input) {
        Common.establishBase64Converter();
        try {
            if (base64ConverterType_ == Base64ConverterType.ANDROID) {
                return (String)base64Converter_.getDeclaredMethod("encodeToString", byte[].class, Integer.TYPE).invoke(null, input, 2);
            }
            return (String)base64Converter_.getDeclaredMethod("printBase64Binary", byte[].class).invoke(null, new Object[]{input});
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("base64Encode: Error invoking method: " + ex);
        }
    }

    public static byte[] base64Decode(String encoding) throws SecurityException {
        Common.establishBase64Converter();
        try {
            if (base64ConverterType_ == Base64ConverterType.ANDROID) {
                return (byte[])base64Converter_.getDeclaredMethod("decode", String.class, Integer.TYPE).invoke(null, encoding, 0);
            }
            return (byte[])base64Converter_.getDeclaredMethod("parseBase64Binary", String.class).invoke(null, encoding);
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("base64Decode: Error invoking method: " + ex);
        }
    }

    private static void establishBase64Converter() {
        if (base64ConverterType_ == Base64ConverterType.UNINITIALIZED) {
            try {
                base64Converter_ = Class.forName("javax.xml.bind.DatatypeConverter");
                base64ConverterType_ = Base64ConverterType.JAVAX;
                return;
            }
            catch (ClassNotFoundException ex) {
                try {
                    base64Converter_ = Class.forName("android.util.Base64");
                    base64ConverterType_ = Base64ConverterType.ANDROID;
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    base64ConverterType_ = Base64ConverterType.UNSUPPORTED;
                }
            }
        }
        if (base64ConverterType_ == Base64ConverterType.UNSUPPORTED) {
            throw new UnsupportedOperationException("Common.establishBase64Converter: Cannot load a Base64 converter");
        }
    }

    private static enum Base64ConverterType {
        UNINITIALIZED,
        JAVAX,
        ANDROID,
        UNSUPPORTED;

    }
}

