/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.tlv.TlvEncoder;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class CommandInterestGenerator {
    private double lastTimestamp_;
    private final Object lastTimestampLock_ = new Object();
    private static final SecureRandom random_ = new SecureRandom();

    public CommandInterestGenerator() {
        this.lastTimestamp_ = Math.round(Common.getNowMilliseconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Interest interest, KeyChain keyChain, Name certificateName, WireFormat wireFormat) throws SecurityException {
        double timestamp;
        Object object = this.lastTimestampLock_;
        synchronized (object) {
            for (timestamp = (double)Math.round(Common.getNowMilliseconds()); timestamp <= this.lastTimestamp_; timestamp += 1.0) {
            }
            this.lastTimestamp_ = timestamp;
        }
        TlvEncoder encoder = new TlvEncoder(8);
        encoder.writeNonNegativeInteger((long)timestamp);
        interest.getName().append(new Blob(encoder.getOutput(), false));
        ByteBuffer randomBuffer = ByteBuffer.allocate(8);
        random_.nextBytes(randomBuffer.array());
        interest.getName().append(new Blob(randomBuffer, false));
        keyChain.sign(interest, certificateName, wireFormat);
        if (interest.getInterestLifetimeMilliseconds() < 0.0) {
            interest.setInterestLifetimeMilliseconds(1000.0);
        }
    }

    public void generate(Interest interest, KeyChain keyChain, Name certificateName) throws SecurityException {
        this.generate(interest, keyChain, certificateName, WireFormat.getDefaultWireFormat());
    }
}

