/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.policy;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import net.named_data.jndn.Data;
import net.named_data.jndn.DigestSha256Signature;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.Sha256WithEcdsaSignature;
import net.named_data.jndn.Sha256WithRsaSignature;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.security.OnVerified;
import net.named_data.jndn.security.OnVerifiedInterest;
import net.named_data.jndn.security.OnVerifyFailed;
import net.named_data.jndn.security.OnVerifyInterestFailed;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.ValidationRequest;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;
import net.named_data.jndn.util.SignedBlob;

public abstract class PolicyManager {
    public abstract boolean skipVerifyAndTrust(Data var1);

    public abstract boolean skipVerifyAndTrust(Interest var1);

    public abstract boolean requireVerify(Data var1);

    public abstract boolean requireVerify(Interest var1);

    public abstract ValidationRequest checkVerificationPolicy(Data var1, int var2, OnVerified var3, OnVerifyFailed var4) throws SecurityException;

    public abstract ValidationRequest checkVerificationPolicy(Interest var1, int var2, OnVerifiedInterest var3, OnVerifyInterestFailed var4, WireFormat var5) throws SecurityException;

    public ValidationRequest checkVerificationPolicy(Interest interest, int stepCount, OnVerifiedInterest onVerified, OnVerifyInterestFailed onVerifyFailed) throws SecurityException {
        return this.checkVerificationPolicy(interest, stepCount, onVerified, onVerifyFailed, WireFormat.getDefaultWireFormat());
    }

    public abstract boolean checkSigningPolicy(Name var1, Name var2);

    public abstract Name inferSigningIdentity(Name var1);

    protected static boolean verifySignature(Signature signature, SignedBlob signedBlob, Blob publicKeyDer) throws SecurityException {
        if (signature instanceof Sha256WithRsaSignature) {
            if (publicKeyDer.isNull()) {
                return false;
            }
            return PolicyManager.verifySha256WithRsaSignature(signature.getSignature(), signedBlob, publicKeyDer);
        }
        if (signature instanceof Sha256WithEcdsaSignature) {
            if (publicKeyDer.isNull()) {
                return false;
            }
            return PolicyManager.verifySha256WithEcdsaSignature(signature.getSignature(), signedBlob, publicKeyDer);
        }
        if (signature instanceof DigestSha256Signature) {
            return PolicyManager.verifyDigestSha256Signature(signature.getSignature(), signedBlob);
        }
        throw new SecurityException("PolicyManager.verify: Signature type is unknown");
    }

    protected static boolean verifySha256WithRsaSignature(Blob signature, SignedBlob signedBlob, Blob publicKeyDer) throws SecurityException {
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException exception) {
            throw new SecurityException("RSA is not supported: " + exception.getMessage());
        }
        PublicKey publicKey = null;
        try {
            publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyDer.getImmutableArray()));
        }
        catch (InvalidKeySpecException exception) {
            throw new SecurityException("X509EncodedKeySpec is not supported: " + exception.getMessage());
        }
        java.security.Signature rsaSignature = null;
        try {
            rsaSignature = java.security.Signature.getInstance("SHA256withRSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("SHA256withRSA algorithm is not supported");
        }
        try {
            rsaSignature.initVerify(publicKey);
        }
        catch (InvalidKeyException exception) {
            throw new SecurityException("InvalidKeyException: " + exception.getMessage());
        }
        try {
            rsaSignature.update(signedBlob.signedBuf());
            return rsaSignature.verify(signature.getImmutableArray());
        }
        catch (SignatureException exception) {
            throw new SecurityException("SignatureException: " + exception.getMessage());
        }
    }

    protected static boolean verifySha256WithEcdsaSignature(Blob signature, SignedBlob signedBlob, Blob publicKeyDer) throws SecurityException {
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("EC");
        }
        catch (NoSuchAlgorithmException exception) {
            throw new SecurityException("EC is not supported: " + exception.getMessage());
        }
        PublicKey publicKey = null;
        try {
            publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyDer.getImmutableArray()));
        }
        catch (InvalidKeySpecException exception) {
            throw new SecurityException("X509EncodedKeySpec is not supported: " + exception.getMessage());
        }
        java.security.Signature ecSignature = null;
        try {
            ecSignature = java.security.Signature.getInstance("SHA256withECDSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("SHA256withECDSA algorithm is not supported");
        }
        try {
            ecSignature.initVerify(publicKey);
        }
        catch (InvalidKeyException exception) {
            throw new SecurityException("InvalidKeyException: " + exception.getMessage());
        }
        try {
            ecSignature.update(signedBlob.signedBuf());
            return ecSignature.verify(signature.getImmutableArray());
        }
        catch (SignatureException exception) {
            throw new SecurityException("SignatureException: " + exception.getMessage());
        }
    }

    protected static boolean verifyDigestSha256Signature(Blob signature, SignedBlob signedBlob) {
        byte[] signedPortionDigest = Common.digestSha256(signedBlob.signedBuf());
        return Arrays.equals(signedPortionDigest, signature.getImmutableArray());
    }
}

