/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.policy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.named_data.jndn.Data;
import net.named_data.jndn.Interest;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.Name;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.der.DerDecodingException;
import net.named_data.jndn.security.OnVerified;
import net.named_data.jndn.security.OnVerifiedInterest;
import net.named_data.jndn.security.OnVerifyFailed;
import net.named_data.jndn.security.OnVerifyInterestFailed;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.ValidationRequest;
import net.named_data.jndn.security.certificate.IdentityCertificate;
import net.named_data.jndn.security.policy.CertificateCache;
import net.named_data.jndn.security.policy.PolicyManager;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.BoostInfoParser;
import net.named_data.jndn.util.BoostInfoTree;
import net.named_data.jndn.util.Common;
import net.named_data.jndn.util.NdnRegexMatcher;
import net.named_data.jndn.util.SignedBlob;

public class ConfigPolicyManager
extends PolicyManager {
    private CertificateCache certificateCache_ = new CertificateCache();
    private int maxDepth_ = 5;
    private double keyGraceInterval_ = 3000.0;
    private double keyTimestampTtl_ = 3600000.0;
    private int maxTrackedKeys_ = 1000;
    private final HashMap fixedCertificateCache_ = new HashMap();
    private final HashMap keyTimestamps_ = new HashMap();
    private BoostInfoParser config_ = new BoostInfoParser();
    private boolean requiresVerification_ = true;
    private TrustAnchorRefreshManager refreshManager_ = new TrustAnchorRefreshManager();

    public ConfigPolicyManager(String configFileName, CertificateCache certificateCache, int searchDepth, double graceInterval, double keyTimestampTtl, int maxTrackedKeys) throws IOException, SecurityException {
        this.certificateCache_ = certificateCache;
        this.maxDepth_ = searchDepth;
        this.keyGraceInterval_ = graceInterval;
        this.keyTimestampTtl_ = keyTimestampTtl;
        this.maxTrackedKeys_ = maxTrackedKeys;
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager(String configFileName, CertificateCache certificateCache, int searchDepth, double graceInterval, double keyTimestampTtl) throws IOException, SecurityException {
        this.certificateCache_ = certificateCache;
        this.maxDepth_ = searchDepth;
        this.keyGraceInterval_ = graceInterval;
        this.keyTimestampTtl_ = keyTimestampTtl;
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager(String configFileName, CertificateCache certificateCache, int searchDepth, double graceInterval) throws IOException, SecurityException {
        this.certificateCache_ = certificateCache;
        this.maxDepth_ = searchDepth;
        this.keyGraceInterval_ = graceInterval;
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager(String configFileName, CertificateCache certificateCache, int searchDepth) throws IOException, SecurityException {
        this.certificateCache_ = certificateCache;
        this.maxDepth_ = searchDepth;
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager(String configFileName, CertificateCache certificateCache) throws IOException, SecurityException {
        this.certificateCache_ = certificateCache;
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager(String configFileName) throws IOException, SecurityException {
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager() {
    }

    public final void reset() {
        this.certificateCache_.reset();
        this.fixedCertificateCache_.clear();
        this.keyTimestamps_.clear();
        this.requiresVerification_ = true;
        this.config_ = new BoostInfoParser();
        this.refreshManager_ = new TrustAnchorRefreshManager();
    }

    public final void load(String configFileName) throws IOException, SecurityException {
        this.reset();
        this.config_.read(configFileName);
        this.loadTrustAnchorCertificates();
    }

    public void load(String input, String inputName) throws IOException, SecurityException {
        this.reset();
        this.config_.read(input, inputName);
        this.loadTrustAnchorCertificates();
    }

    @Override
    public final boolean skipVerifyAndTrust(Data data) {
        return !this.requiresVerification_;
    }

    @Override
    public final boolean skipVerifyAndTrust(Interest interest) {
        return !this.requiresVerification_;
    }

    @Override
    public final boolean requireVerify(Data data) {
        return this.requiresVerification_;
    }

    @Override
    public final boolean requireVerify(Interest interest) {
        return this.requiresVerification_;
    }

    @Override
    public final ValidationRequest checkVerificationPolicy(Data data, int stepCount, OnVerified onVerified, OnVerifyFailed onVerifyFailed) throws SecurityException {
        Interest certificateInterest = this.getCertificateInterest(stepCount, "data", data.getName(), data.getSignature());
        if (certificateInterest == null) {
            onVerifyFailed.onVerifyFailed(data);
            return null;
        }
        if (certificateInterest.getName().size() > 0) {
            return new ValidationRequest(certificateInterest, new OnCertificateDownloadComplete(data, stepCount, onVerified, onVerifyFailed), onVerifyFailed, 2, stepCount + 1);
        }
        if (this.verify(data.getSignature(), data.wireEncode())) {
            onVerified.onVerified(data);
        } else {
            onVerifyFailed.onVerifyFailed(data);
        }
        return null;
    }

    @Override
    public final ValidationRequest checkVerificationPolicy(Interest interest, int stepCount, OnVerifiedInterest onVerified, OnVerifyInterestFailed onVerifyFailed, WireFormat wireFormat) throws SecurityException {
        double timestamp;
        Signature signature = ConfigPolicyManager.extractSignature(interest, wireFormat);
        if (signature == null) {
            onVerifyFailed.onVerifyInterestFailed(interest);
            return null;
        }
        Interest certificateInterest = this.getCertificateInterest(stepCount, "interest", interest.getName().getPrefix(-4), signature);
        if (certificateInterest == null) {
            onVerifyFailed.onVerifyInterestFailed(interest);
            return null;
        }
        if (certificateInterest.getName().size() > 0) {
            return new ValidationRequest(certificateInterest, new OnCertificateDownloadCompleteForInterest(interest, stepCount, onVerified, onVerifyFailed, wireFormat), new OnVerifyInterestFailedWrapper(onVerifyFailed, interest), 2, stepCount + 1);
        }
        Name signatureName = KeyLocator.getFromSignature(signature).getKeyName();
        Name keyName = IdentityCertificate.certificateNameToPublicKeyName(signatureName);
        if (!this.interestTimestampIsFresh(keyName, timestamp = (double)interest.getName().get(-4).toNumber())) {
            onVerifyFailed.onVerifyInterestFailed(interest);
            return null;
        }
        if (this.verify(signature, interest.wireEncode())) {
            onVerified.onVerifiedInterest(interest);
            this.updateTimestampForKey(keyName, timestamp);
        } else {
            onVerifyFailed.onVerifyInterestFailed(interest);
        }
        return null;
    }

    @Override
    public final boolean checkSigningPolicy(Name dataName, Name certificateName) {
        return true;
    }

    @Override
    public final Name inferSigningIdentity(Name dataName) {
        throw new UnsupportedOperationException("ConfigPolicyManager::inferSigningIdentity is not implemented");
    }

    private void loadTrustAnchorCertificates() throws SecurityException {
        ArrayList anchors = this.config_.getRoot().get("validator/trust-anchor");
        for (int i = 0; i < anchors.size(); ++i) {
            BoostInfoTree anchor = (BoostInfoTree)anchors.get(i);
            String typeName = anchor.getFirstValue("type");
            boolean isPath = false;
            String certID = null;
            if (typeName.equals("file")) {
                certID = anchor.getFirstValue("file-name");
                isPath = true;
            } else if (typeName.equals("base64")) {
                certID = anchor.getFirstValue("base64-string");
                isPath = false;
            } else {
                if (typeName.equals("dir")) {
                    String dirName = anchor.getFirstValue("dir");
                    double refreshPeriod = 0.0;
                    ArrayList refreshTrees = anchor.get("refresh");
                    if (refreshTrees.size() >= 1) {
                        String refreshPeriodStr = ((BoostInfoTree)refreshTrees.get(0)).getValue();
                        Pattern regex1 = Pattern.compile("(\\d+)([hms])");
                        Matcher refreshMatch = regex1.matcher(refreshPeriodStr);
                        if (!refreshMatch.find()) {
                            refreshPeriod = 0.0;
                        } else {
                            refreshPeriod = Integer.parseInt(refreshMatch.group(1));
                            if (!refreshMatch.group(2).equals("s")) {
                                refreshPeriod *= 60.0;
                                if (!refreshMatch.group(2).equals("m")) {
                                    refreshPeriod *= 60.0;
                                }
                            }
                        }
                    }
                    this.refreshManager_.addDirectory(dirName, refreshPeriod * 1000.0);
                    continue;
                }
                if (typeName.equals("any")) {
                    this.requiresVerification_ = false;
                    break;
                }
            }
            this.lookupCertificate(certID, isPath);
        }
    }

    private boolean checkSignatureMatch(Name signatureName, Name objectName, BoostInfoTree rule) throws SecurityException {
        BoostInfoTree checker = (BoostInfoTree)rule.get("checker").get(0);
        String checkerType = checker.getFirstValue("type");
        if (checkerType.equals("fixed-signer")) {
            BoostInfoTree signerInfo = (BoostInfoTree)checker.get("signer").get(0);
            String signerType = signerInfo.getFirstValue("type");
            IdentityCertificate cert = null;
            if (signerType.equals("file")) {
                cert = this.lookupCertificate(signerInfo.getFirstValue("file-name"), true);
            } else if (signerType.equals("base64")) {
                cert = this.lookupCertificate(signerInfo.getFirstValue("base64-string"), false);
            } else {
                return false;
            }
            if (cert == null) {
                return false;
            }
            return cert.getName().equals(signatureName);
        }
        if (checkerType.equals("hierarchical")) {
            String identityRegex = "^([^<KEY>]*)<KEY>(<>*)<ksk-.+><ID-CERT>";
            Matcher identityMatch = NdnRegexMatcher.match(identityRegex, signatureName);
            if (identityMatch != null) {
                Name identityPrefix = new Name(identityMatch.group(1)).append(new Name(identityMatch.group(2)));
                return ConfigPolicyManager.matchesRelation(objectName, identityPrefix, "is-prefix-of");
            }
            return false;
        }
        if (checkerType.equals("customized")) {
            BoostInfoTree keyLocatorInfo = (BoostInfoTree)checker.get("key-locator").get(0);
            String simpleRelationType = keyLocatorInfo.getFirstValue("relation");
            if (simpleRelationType != null) {
                Name matchName = new Name(keyLocatorInfo.getFirstValue("name"));
                return ConfigPolicyManager.matchesRelation(signatureName, matchName, simpleRelationType);
            }
            String simpleKeyRegex = keyLocatorInfo.getFirstValue("regex");
            if (simpleKeyRegex != null) {
                return NdnRegexMatcher.match(simpleKeyRegex, signatureName) != null;
            }
            ArrayList hyperRelationList = keyLocatorInfo.get("hyper-relation");
            if (hyperRelationList.size() >= 1) {
                BoostInfoTree hyperRelation = (BoostInfoTree)hyperRelationList.get(0);
                String keyRegex = hyperRelation.getFirstValue("k-regex");
                String keyExpansion = hyperRelation.getFirstValue("k-expand");
                String nameRegex = hyperRelation.getFirstValue("p-regex");
                String nameExpansion = hyperRelation.getFirstValue("p-expand");
                String relationType = hyperRelation.getFirstValue("h-relation");
                if (keyRegex != null && keyExpansion != null && nameRegex != null && nameExpansion != null && relationType != null) {
                    Matcher keyMatch = NdnRegexMatcher.match(keyRegex, signatureName);
                    if (keyMatch == null || keyMatch.groupCount() < 1) {
                        return false;
                    }
                    String keyMatchPrefix = ConfigPolicyManager.expand(keyMatch, keyExpansion);
                    Matcher nameMatch = NdnRegexMatcher.match(nameRegex, objectName);
                    if (nameMatch == null || nameMatch.groupCount() < 1) {
                        return false;
                    }
                    String nameMatchStr = ConfigPolicyManager.expand(nameMatch, nameExpansion);
                    return ConfigPolicyManager.matchesRelation(new Name(nameMatchStr), new Name(keyMatchPrefix), relationType);
                }
            }
        }
        return false;
    }

    private static String expand(Matcher match, String expansion) {
        String result = "";
        int beginIndex = 0;
        Pattern regex = Pattern.compile("\\\\(\\d)");
        Matcher expansionMatcher = regex.matcher(expansion);
        while (expansionMatcher.find()) {
            result = result + expansion.substring(beginIndex, expansionMatcher.start());
            result = result + match.group(Integer.parseInt(expansionMatcher.group(1)));
            beginIndex = expansionMatcher.end();
        }
        result = result + expansion.substring(beginIndex, expansion.length());
        return result;
    }

    private IdentityCertificate lookupCertificate(String certID, boolean isPath) throws SecurityException {
        IdentityCertificate cert;
        if (!this.fixedCertificateCache_.containsKey(certID)) {
            if (isPath) {
                cert = TrustAnchorRefreshManager.loadIdentityCertificateFromFile(certID);
            } else {
                byte[] certData = Common.base64Decode(certID);
                cert = new IdentityCertificate();
                try {
                    cert.wireDecode(new Blob(certData));
                }
                catch (EncodingException ex) {
                    throw new SecurityException("Cannot base64 decode the cert data: " + ex.getMessage());
                }
            }
            String certUri = cert.getName().getPrefix(-1).toUri();
            this.fixedCertificateCache_.put(certID, certUri);
            this.certificateCache_.insertCertificate(cert);
        } else {
            cert = this.certificateCache_.getCertificate(new Name((String)this.fixedCertificateCache_.get(certID)));
        }
        return cert;
    }

    private BoostInfoTree findMatchingRule(Name objName, String matchType) {
        ArrayList rules = this.config_.getRoot().get("validator/rule");
        for (int iRule = 0; iRule < rules.size(); ++iRule) {
            BoostInfoTree r = (BoostInfoTree)rules.get(iRule);
            if (!r.getFirstValue("for").equals(matchType)) continue;
            boolean passed = true;
            ArrayList filters = r.get("filter");
            if (filters.isEmpty()) {
                return r;
            }
            for (int iFilter = 0; iFilter < filters.size(); ++iFilter) {
                BoostInfoTree f = (BoostInfoTree)filters.get(iFilter);
                String regexPattern = f.getFirstValue("regex");
                if (regexPattern == null) {
                    String matchRelation = f.getFirstValue("relation");
                    String matchUri = f.getFirstValue("name");
                    Name matchName = new Name(matchUri);
                    passed = ConfigPolicyManager.matchesRelation(objName, matchName, matchRelation);
                } else {
                    boolean bl = passed = NdnRegexMatcher.match(regexPattern, objName) != null;
                }
                if (!passed) break;
            }
            if (!passed) continue;
            return r;
        }
        return null;
    }

    private static boolean matchesRelation(Name name, Name matchName, String matchRelation) {
        boolean passed = false;
        if (matchRelation.equals("is-strict-prefix-of")) {
            if (matchName.size() == name.size()) {
                passed = false;
            } else if (matchName.match(name)) {
                passed = true;
            }
        } else if (matchRelation.equals("is-prefix-of")) {
            if (matchName.match(name)) {
                passed = true;
            }
        } else if (matchRelation.equals("equal") && matchName.equals(name)) {
            passed = true;
        }
        return passed;
    }

    private static Signature extractSignature(Interest interest, WireFormat wireFormat) {
        if (interest.getName().size() < 2) {
            return null;
        }
        try {
            return wireFormat.decodeSignatureInfoAndValue(interest.getName().get(-2).getValue().buf(), interest.getName().get(-1).getValue().buf());
        }
        catch (EncodingException ex) {
            return null;
        }
    }

    private boolean interestTimestampIsFresh(Name keyName, double timestamp) {
        String keyNameUri = keyName.toUri();
        if (!this.keyTimestamps_.containsKey(keyNameUri)) {
            double now = Common.getNowMilliseconds();
            double notBefore = now - this.keyGraceInterval_;
            double notAfter = now + this.keyGraceInterval_;
            return timestamp > notBefore && timestamp < notAfter;
        }
        double lastTimestamp = (Double)this.keyTimestamps_.get(keyNameUri);
        return timestamp > lastTimestamp;
    }

    private void updateTimestampForKey(Name keyName, double timestamp) {
        this.keyTimestamps_.put(keyName.toUri(), timestamp);
        if (this.keyTimestamps_.size() >= this.maxTrackedKeys_) {
            int i;
            double now;
            double oldestTimestamp = now = Common.getNowMilliseconds();
            String oldestKey = "";
            ArrayList<String> keysToErase = new ArrayList<String>();
            Object[] keys = this.keyTimestamps_.keySet().toArray();
            for (i = 0; i < keys.length; ++i) {
                String keyUri = (String)keys[i];
                double ts = (Double)this.keyTimestamps_.get(keyUri);
                if (now - ts > this.keyTimestampTtl_) {
                    keysToErase.add(keyUri);
                    continue;
                }
                if (!(ts < oldestTimestamp)) continue;
                oldestTimestamp = ts;
                oldestKey = keyUri;
            }
            for (i = 0; i < keysToErase.size(); ++i) {
                this.keyTimestamps_.remove(keysToErase.get(i));
            }
            if (this.keyTimestamps_.size() > this.maxTrackedKeys_ && !oldestKey.isEmpty()) {
                this.keyTimestamps_.remove(oldestKey);
            }
        }
    }

    private boolean verify(Signature signatureInfo, SignedBlob signedBlob) throws SecurityException {
        KeyLocator keyLocator = KeyLocator.getFromSignature(signatureInfo);
        if (keyLocator.getType() == KeyLocatorType.KEYNAME) {
            Name signatureName = keyLocator.getKeyName();
            IdentityCertificate certificate = this.refreshManager_.getCertificate(signatureName);
            if (certificate == null) {
                certificate = this.certificateCache_.getCertificate(signatureName);
            }
            if (certificate == null) {
                return false;
            }
            Blob publicKeyDer = certificate.getPublicKeyInfo().getKeyDer();
            if (publicKeyDer.isNull()) {
                return false;
            }
            return ConfigPolicyManager.verifySignature(signatureInfo, signedBlob, publicKeyDer);
        }
        return false;
    }

    private Interest getCertificateInterest(int stepCount, String matchType, Name objectName, Signature signature) throws SecurityException {
        if (stepCount > this.maxDepth_) {
            return null;
        }
        if (!KeyLocator.canGetFromSignature(signature)) {
            return null;
        }
        KeyLocator keyLocator = KeyLocator.getFromSignature(signature);
        Name signatureName = keyLocator.getKeyName();
        if (signatureName.size() == 0) {
            return null;
        }
        BoostInfoTree matchedRule = this.findMatchingRule(objectName, matchType);
        if (matchedRule == null) {
            return null;
        }
        boolean signatureMatches = this.checkSignatureMatch(signatureName, objectName, matchedRule);
        if (!signatureMatches) {
            return null;
        }
        this.refreshManager_.refreshAnchors();
        IdentityCertificate foundCert = this.refreshManager_.getCertificate(signatureName);
        if (foundCert == null) {
            foundCert = this.certificateCache_.getCertificate(signatureName);
        }
        if (foundCert == null) {
            return new Interest(signatureName);
        }
        return new Interest();
    }

    public static void setFriendAccess(Friend friend) {
        if (friend.getClass().getName().equals("src.net.named_data.jndn.tests.integration_tests.TestPolicyManager") || friend.getClass().getName().equals("src.net.named_data.jndn.tests.integration_tests.TestVerificationRules")) {
            friend.setConfigPolicyManagerFriendAccess(new FriendAccessImpl());
        }
    }

    private static class FriendAccessImpl
    extends FriendAccess {
        private FriendAccessImpl() {
        }

        @Override
        public BoostInfoTree findMatchingRule(ConfigPolicyManager policyManager, Name objName, String matchType) {
            return policyManager.findMatchingRule(objName, matchType);
        }

        @Override
        public boolean checkSignatureMatch(ConfigPolicyManager policyManager, Name signatureName, Name objectName, BoostInfoTree rule) throws SecurityException {
            return policyManager.checkSignatureMatch(signatureName, objectName, rule);
        }
    }

    public static abstract class FriendAccess {
        public abstract BoostInfoTree findMatchingRule(ConfigPolicyManager var1, Name var2, String var3);

        public abstract boolean checkSignatureMatch(ConfigPolicyManager var1, Name var2, Name var3, BoostInfoTree var4) throws SecurityException;
    }

    public static interface Friend {
        public void setConfigPolicyManagerFriendAccess(FriendAccess var1);
    }

    private class OnVerifyInterestFailedWrapper
    implements OnVerifyFailed {
        private final OnVerifyInterestFailed onVerifyFailed_;
        private final Interest interest_;

        public OnVerifyInterestFailedWrapper(OnVerifyInterestFailed onVerifyFailed, Interest interest) {
            this.onVerifyFailed_ = onVerifyFailed;
            this.interest_ = interest;
        }

        @Override
        public final void onVerifyFailed(Data data) {
            this.onVerifyFailed_.onVerifyInterestFailed(this.interest_);
        }
    }

    private class OnCertificateDownloadCompleteForInterest
    implements OnVerified {
        private final Interest originalInterest_;
        private final int stepCount_;
        private final OnVerifiedInterest onVerified_;
        private final OnVerifyInterestFailed onVerifyFailed_;
        private final WireFormat wireFormat_;

        public OnCertificateDownloadCompleteForInterest(Interest originalInterest, int stepCount, OnVerifiedInterest onVerified, OnVerifyInterestFailed onVerifyFailed, WireFormat wireFormat) {
            this.originalInterest_ = originalInterest;
            this.stepCount_ = stepCount;
            this.onVerified_ = onVerified;
            this.onVerifyFailed_ = onVerifyFailed;
            this.wireFormat_ = wireFormat;
        }

        @Override
        public final void onVerified(Data data) {
            IdentityCertificate certificate;
            try {
                certificate = new IdentityCertificate(data);
            }
            catch (DerDecodingException ex) {
                this.onVerifyFailed_.onVerifyInterestFailed(this.originalInterest_);
                return;
            }
            ConfigPolicyManager.this.certificateCache_.insertCertificate(certificate);
            try {
                ConfigPolicyManager.this.checkVerificationPolicy(this.originalInterest_, this.stepCount_ + 1, this.onVerified_, this.onVerifyFailed_, this.wireFormat_);
            }
            catch (SecurityException ex) {
                this.onVerifyFailed_.onVerifyInterestFailed(this.originalInterest_);
            }
        }
    }

    private class OnCertificateDownloadComplete
    implements OnVerified {
        private final Data originalData_;
        private final int stepCount_;
        private final OnVerified onVerified_;
        private final OnVerifyFailed onVerifyFailed_;

        public OnCertificateDownloadComplete(Data originalData, int stepCount, OnVerified onVerified, OnVerifyFailed onVerifyFailed) {
            this.originalData_ = originalData;
            this.stepCount_ = stepCount;
            this.onVerified_ = onVerified;
            this.onVerifyFailed_ = onVerifyFailed;
        }

        @Override
        public final void onVerified(Data data) {
            IdentityCertificate certificate;
            try {
                certificate = new IdentityCertificate(data);
            }
            catch (DerDecodingException ex) {
                this.onVerifyFailed_.onVerifyFailed(this.originalData_);
                return;
            }
            ConfigPolicyManager.this.certificateCache_.insertCertificate(certificate);
            try {
                ConfigPolicyManager.this.checkVerificationPolicy(this.originalData_, this.stepCount_ + 1, this.onVerified_, this.onVerifyFailed_);
            }
            catch (SecurityException ex) {
                this.onVerifyFailed_.onVerifyFailed(this.originalData_);
            }
        }
    }

    private static class TrustAnchorRefreshManager {
        private final CertificateCache certificateCache_ = new CertificateCache();
        private final HashMap refreshDirectories_ = new HashMap();

        private TrustAnchorRefreshManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static IdentityCertificate loadIdentityCertificateFromFile(String filename) throws SecurityException {
            StringBuilder encodedData = new StringBuilder();
            try (BufferedReader certFile = new BufferedReader(new FileReader(filename));){
                String line;
                while ((line = certFile.readLine()) != null) {
                    encodedData.append(line);
                }
            }
            catch (FileNotFoundException ex) {
                throw new SecurityException("Can't find IdentityCertificate file " + filename + ": " + ex.getMessage());
            }
            catch (IOException ex) {
                throw new SecurityException("Error reading IdentityCertificate file " + filename + ": " + ex.getMessage());
            }
            byte[] decodedData = Common.base64Decode(encodedData.toString());
            IdentityCertificate cert = new IdentityCertificate();
            try {
                cert.wireDecode(new Blob(decodedData));
            }
            catch (EncodingException ex) {
                throw new SecurityException("Can't decode the IdentityCertificate from file " + filename + ": " + ex.getMessage());
            }
            return cert;
        }

        public IdentityCertificate getCertificate(Name certificateName) {
            return this.certificateCache_.getCertificate(certificateName);
        }

        public void addDirectory(String directoryName, double refreshPeriod) throws SecurityException {
            File[] allFiles = new File(directoryName).listFiles();
            if (allFiles == null) {
                throw new SecurityException("Cannot find files in directory " + directoryName);
            }
            ArrayList<String> certificateNames = new ArrayList<String>();
            for (int i = 0; i < allFiles.length; ++i) {
                IdentityCertificate cert;
                File file = allFiles[i];
                try {
                    cert = TrustAnchorRefreshManager.loadIdentityCertificateFromFile(file.getPath());
                }
                catch (SecurityException ex) {
                    continue;
                }
                String certUri = cert.getName().getPrefix(-1).toUri();
                this.certificateCache_.insertCertificate(cert);
                certificateNames.add(certUri);
            }
            this.refreshDirectories_.put(directoryName, new DirectoryInfo(certificateNames, Common.getNowMilliseconds() + refreshPeriod, refreshPeriod));
        }

        public void refreshAnchors() throws SecurityException {
            double refreshTime = Common.getNowMilliseconds();
            Object[] directories = this.refreshDirectories_.keySet().toArray();
            for (int iDirectory = 0; iDirectory < directories.length; ++iDirectory) {
                String directory = (String)directories[iDirectory];
                DirectoryInfo info = (DirectoryInfo)this.refreshDirectories_.get(directory);
                double nextRefreshTime = info.nextRefresh_;
                if (!(nextRefreshTime <= refreshTime)) continue;
                ArrayList certificateList = (ArrayList)info.certificateNames_.clone();
                for (int i = 0; i < certificateList.size(); ++i) {
                    this.certificateCache_.deleteCertificate(new Name((String)certificateList.get(i)));
                }
                this.addDirectory(directory, info.refreshPeriod_);
            }
        }

        private static class DirectoryInfo {
            ArrayList certificateNames_;
            double nextRefresh_;
            double refreshPeriod_;

            public DirectoryInfo(ArrayList certificateNames, double nextRefresh, double refreshPeriod) {
                this.certificateNames_ = certificateNames;
                this.nextRefresh_ = nextRefresh;
                this.refreshPeriod_ = refreshPeriod;
            }
        }
    }
}

