/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.identity;

import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.DigestAlgorithm;
import net.named_data.jndn.security.EcdsaKeyParams;
import net.named_data.jndn.security.KeyClass;
import net.named_data.jndn.security.KeyParams;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.RsaKeyParams;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.certificate.PublicKey;
import net.named_data.jndn.security.identity.PrivateKeyStorage;
import net.named_data.jndn.util.Blob;

public class MemoryPrivateKeyStorage
extends PrivateKeyStorage {
    private final HashMap publicKeyStore_ = new HashMap();
    private final HashMap privateKeyStore_ = new HashMap();

    public final void setPublicKeyForKeyName(Name keyName, KeyType keyType, ByteBuffer publicKeyDer) throws SecurityException {
        this.publicKeyStore_.put(keyName.toUri(), new PublicKey(new Blob(publicKeyDer, true)));
    }

    public final void setPrivateKeyForKeyName(Name keyName, KeyType keyType, ByteBuffer privateKeyDer) throws SecurityException {
        this.privateKeyStore_.put(keyName.toUri(), new PrivateKey(keyType, privateKeyDer));
    }

    public final void setKeyPairForKeyName(Name keyName, KeyType keyType, ByteBuffer publicKeyDer, ByteBuffer privateKeyDer) throws SecurityException {
        this.setPublicKeyForKeyName(keyName, keyType, publicKeyDer);
        this.setPrivateKeyForKeyName(keyName, keyType, privateKeyDer);
    }

    public final void setKeyPairForKeyName(Name keyName, ByteBuffer publicKeyDer, ByteBuffer privateKeyDer) throws SecurityException {
        this.setKeyPairForKeyName(keyName, KeyType.RSA, publicKeyDer, privateKeyDer);
    }

    @Override
    public void generateKeyPair(Name keyName, KeyParams params) throws SecurityException {
        int keySize;
        String keyAlgorithm;
        if (this.doesKeyExist(keyName, KeyClass.PUBLIC)) {
            throw new SecurityException("Public Key already exists");
        }
        if (this.doesKeyExist(keyName, KeyClass.PRIVATE)) {
            throw new SecurityException("Private Key already exists");
        }
        if (params.getKeyType() == KeyType.RSA) {
            keyAlgorithm = "RSA";
            keySize = ((RsaKeyParams)params).getKeySize();
        } else if (params.getKeyType() == KeyType.ECDSA) {
            keyAlgorithm = "EC";
            keySize = ((EcdsaKeyParams)params).getKeySize();
        } else {
            throw new SecurityException("Cannot generate a key pair of type " + (Object)((Object)params.getKeyType()));
        }
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance(keyAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("FilePrivateKeyStorage: Could not create the key generator: " + e.getMessage());
        }
        generator.initialize(keySize);
        KeyPair pair = generator.generateKeyPair();
        this.setKeyPairForKeyName(keyName, params.getKeyType(), ByteBuffer.wrap(pair.getPublic().getEncoded()), ByteBuffer.wrap(pair.getPrivate().getEncoded()));
    }

    @Override
    public void deleteKeyPair(Name keyName) throws SecurityException {
        String keyUri = keyName.toUri();
        this.publicKeyStore_.remove(keyUri);
        this.privateKeyStore_.remove(keyUri);
    }

    @Override
    public PublicKey getPublicKey(Name keyName) throws SecurityException {
        PublicKey publicKey = (PublicKey)this.publicKeyStore_.get(keyName.toUri());
        if (publicKey == null) {
            throw new SecurityException("MemoryPrivateKeyStorage: Cannot find public key " + keyName.toUri());
        }
        return publicKey;
    }

    @Override
    public Blob sign(ByteBuffer data, Name keyName, DigestAlgorithm digestAlgorithm) throws SecurityException {
        if (digestAlgorithm != DigestAlgorithm.SHA256) {
            throw new SecurityException("MemoryPrivateKeyStorage.sign: Unsupported digest algorithm");
        }
        PrivateKey privateKey = (PrivateKey)this.privateKeyStore_.get(keyName.toUri());
        if (privateKey == null) {
            throw new SecurityException("MemoryPrivateKeyStorage: Cannot find private key " + keyName.toUri());
        }
        Signature signature = null;
        if (privateKey.getKeyType() == KeyType.RSA) {
            try {
                signature = Signature.getInstance("SHA256withRSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("SHA256withRSA algorithm is not supported");
            }
        } else if (privateKey.getKeyType() == KeyType.ECDSA) {
            try {
                signature = Signature.getInstance("SHA256withECDSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("SHA256withECDSA algorithm is not supported");
            }
        } else {
            throw new SecurityException("Unrecognized private key type");
        }
        try {
            signature.initSign(privateKey.getPrivateKey());
        }
        catch (InvalidKeyException exception) {
            throw new SecurityException("InvalidKeyException: " + exception.getMessage());
        }
        try {
            signature.update(data);
            return new Blob(signature.sign());
        }
        catch (SignatureException exception) {
            throw new SecurityException("SignatureException: " + exception.getMessage());
        }
    }

    @Override
    public Blob decrypt(Name keyName, ByteBuffer data, boolean isSymmetric) throws SecurityException {
        throw new UnsupportedOperationException("MemoryPrivateKeyStorage.decrypt is not implemented");
    }

    @Override
    public Blob encrypt(Name keyName, ByteBuffer data, boolean isSymmetric) throws SecurityException {
        throw new UnsupportedOperationException("MemoryPrivateKeyStorage.encrypt is not implemented");
    }

    @Override
    public void generateKey(Name keyName, KeyParams params) throws SecurityException {
        throw new UnsupportedOperationException("MemoryPrivateKeyStorage.generateKey is not implemented");
    }

    @Override
    public boolean doesKeyExist(Name keyName, KeyClass keyClass) throws SecurityException {
        if (keyClass == KeyClass.PUBLIC) {
            return this.publicKeyStore_.containsKey(keyName.toUri());
        }
        if (keyClass == KeyClass.PRIVATE) {
            return this.privateKeyStore_.containsKey(keyName.toUri());
        }
        return false;
    }

    class PrivateKey {
        private KeyType keyType_;
        private java.security.PrivateKey privateKey_;

        public PrivateKey(KeyType keyType, ByteBuffer keyDer) throws SecurityException {
            this.keyType_ = keyType;
            if (keyType == KeyType.RSA) {
                KeyFactory keyFactory = null;
                try {
                    keyFactory = KeyFactory.getInstance("RSA");
                }
                catch (NoSuchAlgorithmException exception) {
                    throw new SecurityException("KeyFactory: RSA is not supported: " + exception.getMessage());
                }
                try {
                    this.privateKey_ = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyDer.array()));
                }
                catch (InvalidKeySpecException exception) {
                    throw new SecurityException("KeyFactory: PKCS8EncodedKeySpec is not supported for RSA: " + exception.getMessage());
                }
            }
            if (keyType == KeyType.ECDSA) {
                KeyFactory keyFactory = null;
                try {
                    keyFactory = KeyFactory.getInstance("EC");
                }
                catch (NoSuchAlgorithmException exception) {
                    throw new SecurityException("KeyFactory: EC is not supported: " + exception.getMessage());
                }
                try {
                    this.privateKey_ = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyDer.array()));
                }
                catch (InvalidKeySpecException exception) {
                    throw new SecurityException("KeyFactory: PKCS8EncodedKeySpec is not supported for EC: " + exception.getMessage());
                }
            }
            throw new SecurityException("PrivateKey constructor: Unrecognized keyType");
        }

        public KeyType getKeyType() {
            return this.keyType_;
        }

        public java.security.PrivateKey getPrivateKey() {
            return this.privateKey_;
        }
    }
}

