/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.identity;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.der.DerDecodingException;
import net.named_data.jndn.encoding.der.DerNode;
import net.named_data.jndn.security.DigestAlgorithm;
import net.named_data.jndn.security.EcdsaKeyParams;
import net.named_data.jndn.security.KeyClass;
import net.named_data.jndn.security.KeyParams;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.RsaKeyParams;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.certificate.PublicKey;
import net.named_data.jndn.security.identity.PrivateKeyStorage;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class FilePrivateKeyStorage
extends PrivateKeyStorage {
    private static String RSA_ENCRYPTION_OID = "1.2.840.113549.1.1.1";
    private static String EC_ENCRYPTION_OID = "1.2.840.10045.2.1";
    private final File keyStorePath_;
    private static final HashMap keyTypeMap_ = new HashMap();

    public FilePrivateKeyStorage() {
        this.keyStorePath_ = new File(FilePrivateKeyStorage.getDefaultDirecoryPath(System.getProperty("user.home", ".")));
        this.keyStorePath_.mkdirs();
    }

    public FilePrivateKeyStorage(String keyStoreDirectoryPath) {
        this.keyStorePath_ = new File(keyStoreDirectoryPath);
        this.keyStorePath_.mkdirs();
    }

    public static String getDefaultDirecoryPath(File filesRoot) {
        return FilePrivateKeyStorage.getDefaultDirecoryPath(filesRoot.getAbsolutePath());
    }

    public static String getDefaultDirecoryPath(String filesRoot) {
        return new File(new File(filesRoot, ".ndn"), "ndnsec-tpm-file").getAbsolutePath();
    }

    @Override
    public final void generateKeyPair(Name keyName, KeyParams params) throws SecurityException {
        int keySize;
        String keyAlgorithm;
        if (this.doesKeyExist(keyName, KeyClass.PUBLIC)) {
            throw new SecurityException("Public Key already exists");
        }
        if (this.doesKeyExist(keyName, KeyClass.PRIVATE)) {
            throw new SecurityException("Private Key already exists");
        }
        if (params.getKeyType() == KeyType.RSA) {
            keyAlgorithm = "RSA";
            keySize = ((RsaKeyParams)params).getKeySize();
        } else if (params.getKeyType() == KeyType.ECDSA) {
            keyAlgorithm = "EC";
            keySize = ((EcdsaKeyParams)params).getKeySize();
        } else {
            throw new SecurityException("Cannot generate a key pair of type " + (Object)((Object)params.getKeyType()));
        }
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance(keyAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityException("FilePrivateKeyStorage: Could not create the key generator: " + e.getMessage());
        }
        generator.initialize(keySize);
        KeyPair pair = generator.generateKeyPair();
        this.write(keyName, KeyClass.PRIVATE, pair.getPrivate().getEncoded());
        this.write(keyName, KeyClass.PUBLIC, pair.getPublic().getEncoded());
    }

    @Override
    public void deleteKeyPair(Name keyName) throws SecurityException {
        try {
            this.deleteKey(keyName);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public final PublicKey getPublicKey(Name keyName) throws SecurityException {
        if (!this.doesKeyExist(keyName, KeyClass.PUBLIC)) {
            throw new SecurityException("Public key does not exist.");
        }
        byte[] der = this.read(keyName, KeyClass.PUBLIC);
        return new PublicKey(new Blob(der));
    }

    private PrivateKey getPrivateKey(Name keyName, KeyType[] keyType) throws SecurityException {
        KeyFactory kf;
        if (!this.doesKeyExist(keyName, KeyClass.PRIVATE)) {
            throw new SecurityException("FilePrivateKeyStorage: Private key does not exist.");
        }
        byte[] der = this.read(keyName, KeyClass.PRIVATE);
        String oidString = null;
        try {
            DerNode parsedNode = DerNode.parse(ByteBuffer.wrap(der), 0);
            List pkcs8Children = parsedNode.getChildren();
            List algorithmIdChildren = DerNode.getSequence(pkcs8Children, 1).getChildren();
            oidString = ((DerNode.DerOid)algorithmIdChildren.get(0)).toVal().toString();
        }
        catch (DerDecodingException ex) {
            throw new SecurityException("Cannot decode the PKCS #8 private key: " + ex);
        }
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(der);
        if (oidString.equals(RSA_ENCRYPTION_OID)) {
            keyType[0] = KeyType.RSA;
            try {
                kf = KeyFactory.getInstance("RSA");
                return kf.generatePrivate(spec);
            }
            catch (InvalidKeySpecException e) {
                throw new SecurityException("FilePrivateKeyStorage: RSA is not supported: " + e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("FilePrivateKeyStorage: PKCS8EncodedKeySpec is not supported for RSA: " + e.getMessage());
            }
        }
        if (oidString.equals(EC_ENCRYPTION_OID)) {
            keyType[0] = KeyType.ECDSA;
            try {
                kf = KeyFactory.getInstance("EC");
                return kf.generatePrivate(spec);
            }
            catch (InvalidKeySpecException e) {
                throw new SecurityException("FilePrivateKeyStorage: EC is not supported: " + e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("FilePrivateKeyStorage: PKCS8EncodedKeySpec is not supported for EC: " + e.getMessage());
            }
        }
        throw new SecurityException("FilePrivateKeyStorage::sign: Unrecognized private key OID: " + oidString);
    }

    private final SecretKey getSymmetricKey(Name keyName) throws SecurityException {
        if (!this.doesKeyExist(keyName, KeyClass.SYMMETRIC)) {
            throw new SecurityException("FilePrivateKeyStorage: Symmetric key does not exist.");
        }
        byte[] encoded = this.read(keyName, KeyClass.SYMMETRIC);
        return new SecretKeySpec(encoded, "AES");
    }

    @Override
    public final Blob sign(ByteBuffer data, Name keyName, DigestAlgorithm digestAlgorithm) throws SecurityException {
        if (!this.doesKeyExist(keyName, KeyClass.PRIVATE)) {
            throw new SecurityException("FilePrivateKeyStorage.sign: private key doesn't exist");
        }
        if (digestAlgorithm != DigestAlgorithm.SHA256) {
            throw new SecurityException("FilePrivateKeyStorage.sign: Unsupported digest algorithm");
        }
        KeyType[] keyType = new KeyType[1];
        PrivateKey privateKey = this.getPrivateKey(keyName, keyType);
        Signature signature = null;
        if (keyType[0] == KeyType.RSA) {
            try {
                signature = Signature.getInstance("SHA256withRSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("FilePrivateKeyStorage: The SHA256withRSA algorithm is not supported");
            }
        } else if (keyType[0] == KeyType.ECDSA) {
            try {
                signature = Signature.getInstance("SHA256withECDSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new SecurityException("FilePrivateKeyStorage: The SHA256withECDSA algorithm is not supported");
            }
        } else {
            throw new SecurityException("FilePrivateKeyStorage: Unsupported signature key type " + (Object)((Object)keyType[0]));
        }
        try {
            signature.initSign(privateKey);
        }
        catch (InvalidKeyException exception) {
            throw new SecurityException("FilePrivateKeyStorage: InvalidKeyException: " + exception.getMessage());
        }
        try {
            signature.update(data);
            return new Blob(signature.sign());
        }
        catch (SignatureException exception) {
            throw new SecurityException("FilePrivateKeyStorage: SignatureException: " + exception.getMessage());
        }
    }

    @Override
    public final Blob decrypt(Name keyName, ByteBuffer data, boolean isSymmetric) throws SecurityException {
        throw new UnsupportedOperationException("FilePrivateKeyStorage.decrypt is not implemented");
    }

    @Override
    public final Blob encrypt(Name keyName, ByteBuffer data, boolean isSymmetric) throws SecurityException {
        throw new UnsupportedOperationException("FilePrivateKeyStorage.encrypt is not implemented");
    }

    @Override
    public final void generateKey(Name keyName, KeyParams params) throws SecurityException {
        throw new UnsupportedOperationException("FilePrivateKeyStorage.generateKey is not implemented");
    }

    public final void deleteKey(Name keyName) throws SecurityException {
        int deletedFiles = 0;
        for (KeyClass keyClass : KeyClass.values()) {
            if (!this.doesKeyExist(keyName, keyClass)) continue;
            String extension = (String)keyTypeMap_.get((Object)keyClass);
            File file = this.nameTransform(keyName.toUri(), extension);
            file.delete();
            ++deletedFiles;
        }
        if (deletedFiles == 0) {
            throw new SecurityException("No key files found to delete");
        }
    }

    @Override
    public final boolean doesKeyExist(Name keyName, KeyClass keyClass) throws SecurityException {
        String keyURI = keyName.toUri();
        String extension = (String)keyTypeMap_.get((Object)keyClass);
        if (extension == null) {
            throw new SecurityException("Unrecognized key class");
        }
        return this.nameTransform(keyURI, extension).exists();
    }

    private File nameTransform(String keyName, String extension) throws SecurityException {
        MessageDigest sha256;
        try {
            sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException exception) {
            throw new Error("MessageDigest: SHA-256 is not supported: " + exception.getMessage());
        }
        sha256.update(keyName.getBytes());
        byte[] hash = sha256.digest();
        String digest = Common.base64Encode(hash);
        digest = digest.replace('/', '%');
        return new File(this.keyStorePath_, digest + extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Name keyName, KeyClass keyClass, byte[] data) throws SecurityException {
        String extension = (String)keyTypeMap_.get((Object)keyClass);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.nameTransform(keyName.toUri(), extension)));){
            String base64Data = Common.base64Encode(data);
            writer.write(base64Data, 0, base64Data.length());
            writer.flush();
        }
        catch (SecurityException e) {
            throw new SecurityException("FilePrivateKeyStorage: Failed to write key: " + e.getMessage());
        }
        catch (IOException e) {
            throw new SecurityException("FilePrivateKeyStorage: Failed to write key: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] read(Name keyName, KeyClass keyClass) throws SecurityException {
        String extension = (String)keyTypeMap_.get((Object)keyClass);
        StringBuilder contents = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.nameTransform(keyName.toUri(), extension)));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                contents.append(line);
            }
        }
        catch (SecurityException e) {
            throw new SecurityException("FilePrivateKeyStorage: Failed to read key: " + e.getMessage());
        }
        catch (IOException e) {
            throw new SecurityException("FilePrivateKeyStorage: Failed to read key: " + e.getMessage());
        }
        return Common.base64Decode(contents.toString());
    }

    static {
        keyTypeMap_.put(KeyClass.PUBLIC, ".pub");
        keyTypeMap_.put(KeyClass.PRIVATE, ".pri");
        keyTypeMap_.put(KeyClass.SYMMETRIC, ".key");
    }
}

