/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.InterestFilter;
import net.named_data.jndn.OnInterestCallback;

public class InterestFilterTable {
    private final List table_ = new ArrayList();
    private static final Logger logger_ = Logger.getLogger(InterestFilterTable.class.getName());

    public final synchronized void setInterestFilter(long interestFilterId, InterestFilter filter, OnInterestCallback onInterest, Face face) {
        this.table_.add(new Entry(interestFilterId, filter, onInterest, face));
    }

    public final synchronized void getMatchedFilters(Interest interest, ArrayList matchedFilters) {
        for (int i = 0; i < this.table_.size(); ++i) {
            Entry entry = (Entry)this.table_.get(i);
            if (!entry.getFilter().doesMatch(interest.getName())) continue;
            matchedFilters.add(entry);
        }
    }

    public final synchronized void unsetInterestFilter(long interestFilterId) {
        int count = 0;
        for (int i = this.table_.size() - 1; i >= 0; --i) {
            if (((Entry)this.table_.get(i)).getInterestFilterId() != interestFilterId) continue;
            ++count;
            this.table_.remove(i);
        }
        if (count == 0) {
            logger_.log(Level.WARNING, "unsetInterestFilter: Didn't find interestFilterId {0}", interestFilterId);
        }
    }

    public static class Entry {
        private final long interestFilterId_;
        private final InterestFilter filter_;
        private final OnInterestCallback onInterest_;
        private final Face face_;

        public Entry(long interestFilterId, InterestFilter filter, OnInterestCallback onInterest, Face face) {
            this.interestFilterId_ = interestFilterId;
            this.filter_ = filter;
            this.onInterest_ = onInterest;
            this.face_ = face;
        }

        public final long getInterestFilterId() {
            return this.interestFilterId_;
        }

        public final InterestFilter getFilter() {
            return this.filter_;
        }

        public final OnInterestCallback getOnInterest() {
            return this.onInterest_;
        }

        public final Face getFace() {
            return this.face_;
        }
    }
}

