/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.impl;

import java.util.ArrayList;
import java.util.List;
import net.named_data.jndn.util.Common;

public class DelayedCallTable {
    private final List table_ = new ArrayList();

    public final synchronized void callLater(double delayMilliseconds, Runnable callback) {
        int i;
        Entry delayedCall = new Entry(delayMilliseconds, callback);
        for (i = this.table_.size() - 1; i >= 0 && !(((Entry)this.table_.get(i)).getCallTime() <= delayedCall.getCallTime()); --i) {
        }
        this.table_.add(i + 1, delayedCall);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void callTimedOut() {
        double now = Common.getNowMilliseconds();
        while (true) {
            Entry delayedCall;
            DelayedCallTable delayedCallTable = this;
            synchronized (delayedCallTable) {
                if (this.table_.isEmpty()) {
                    break;
                }
                delayedCall = (Entry)this.table_.get(0);
                if (delayedCall.getCallTime() > now) {
                    break;
                }
                this.table_.remove(0);
            }
            delayedCall.callCallback();
        }
    }

    private static class Entry {
        private final Runnable callback_;
        private final double callTime_;

        public Entry(double delayMilliseconds, Runnable callback) {
            this.callback_ = callback;
            this.callTime_ = Common.getNowMilliseconds() + delayMilliseconds;
        }

        public final double getCallTime() {
            return this.callTime_;
        }

        public final void callCallback() {
            this.callback_.run();
        }
    }
}

