/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encoding;

import java.nio.ByteBuffer;
import net.named_data.jndn.encoding.BinaryXmlStructureDecoder;
import net.named_data.jndn.encoding.ElementListener;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.tlv.TlvStructureDecoder;
import net.named_data.jndn.util.DynamicByteBuffer;

public class ElementReader {
    private ElementListener elementListener_;
    private BinaryXmlStructureDecoder binaryXmlStructureDecoder_ = new BinaryXmlStructureDecoder();
    private TlvStructureDecoder tlvStructureDecoder_ = new TlvStructureDecoder();
    private boolean usePartialData_;
    private DynamicByteBuffer partialData_ = new DynamicByteBuffer(1000);
    private boolean useTlv_;

    public ElementReader(ElementListener elementListener) {
        this.elementListener_ = elementListener;
    }

    public void onReceivedData(ByteBuffer data) throws EncodingException {
        block11: {
            data = data.slice();
            do {
                ByteBuffer element;
                int offset;
                boolean gotElementEnd;
                try {
                    if (!this.usePartialData_) {
                        if (data.remaining() <= 0) {
                            return;
                        }
                        int firstByte = data.get(0) & 0xFF;
                        this.useTlv_ = firstByte == 5 || firstByte == 6 || firstByte == 80 || firstByte == 100;
                    }
                    if (this.useTlv_) {
                        this.tlvStructureDecoder_.seek(0);
                        gotElementEnd = this.tlvStructureDecoder_.findElementEnd(data);
                        offset = this.tlvStructureDecoder_.getOffset();
                    } else {
                        this.binaryXmlStructureDecoder_.seek(0);
                        gotElementEnd = this.binaryXmlStructureDecoder_.findElementEnd(data);
                        offset = this.binaryXmlStructureDecoder_.getOffset();
                    }
                }
                catch (EncodingException ex) {
                    this.usePartialData_ = false;
                    this.binaryXmlStructureDecoder_ = new BinaryXmlStructureDecoder();
                    this.tlvStructureDecoder_ = new TlvStructureDecoder();
                    throw ex;
                }
                if (!gotElementEnd) break block11;
                if (this.usePartialData_) {
                    this.partialData_.ensuredPut(data, 0, offset);
                    element = this.partialData_.flippedBuffer();
                    this.usePartialData_ = false;
                } else {
                    element = data.duplicate();
                    element.limit(offset);
                }
                data.position(offset);
                data = data.slice();
                this.binaryXmlStructureDecoder_ = new BinaryXmlStructureDecoder();
                this.tlvStructureDecoder_ = new TlvStructureDecoder();
                this.elementListener_.onReceivedElement(element);
            } while (data.remaining() > 0);
            return;
        }
        if (!this.usePartialData_) {
            this.usePartialData_ = true;
            this.partialData_.position(0);
        }
        if (this.partialData_.buffer().position() + data.remaining() > 8800) {
            this.usePartialData_ = false;
            this.binaryXmlStructureDecoder_ = new BinaryXmlStructureDecoder();
            this.tlvStructureDecoder_ = new TlvStructureDecoder();
            throw new EncodingException("The incoming packet exceeds the maximum limit Face.getMaxNdnPacketSize()");
        }
        this.partialData_.ensuredPut(data);
    }
}

