/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encoding;

import java.nio.ByteBuffer;
import net.named_data.jndn.ContentType;
import net.named_data.jndn.Data;
import net.named_data.jndn.Exclude;
import net.named_data.jndn.ForwardingEntry;
import net.named_data.jndn.Interest;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.KeyNameType;
import net.named_data.jndn.MetaInfo;
import net.named_data.jndn.Name;
import net.named_data.jndn.PublisherPublicKeyDigest;
import net.named_data.jndn.Sha256WithRsaSignature;
import net.named_data.jndn.encoding.BinaryXmlDecoder;
import net.named_data.jndn.encoding.BinaryXmlEncoder;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.util.Blob;

public class BinaryXmlWireFormat
extends WireFormat {
    private static final Blob DATA_BYTES = new Blob(ByteBuffer.wrap(new byte[]{12, 4, -64}), false);
    private static final Blob ENCR_BYTES = new Blob(ByteBuffer.wrap(new byte[]{16, -48, -111}), false);
    private static final Blob GONE_BYTES = new Blob(ByteBuffer.wrap(new byte[]{24, -29, 68}), false);
    private static final Blob KEY_BYTES = new Blob(ByteBuffer.wrap(new byte[]{40, 70, 63}), false);
    private static final Blob LINK_BYTES = new Blob(ByteBuffer.wrap(new byte[]{44, -125, 74}), false);
    private static final Blob NACK_BYTES = new Blob(ByteBuffer.wrap(new byte[]{52, 0, -118}), false);
    private static BinaryXmlWireFormat instance_ = new BinaryXmlWireFormat();

    public BinaryXmlWireFormat() {
        if (!WireFormat.ENABLE_NDNX) {
            throw new Error("BinaryXmlWireFormat (NDNx) is deprecated. To enable while you upgrade your code to use NDN-TLV, set WireFormat.ENABLE_NDNX = true");
        }
    }

    @Override
    public Blob encodeName(Name name) {
        BinaryXmlEncoder encoder = new BinaryXmlEncoder();
        BinaryXmlWireFormat.encodeName(name, new int[1], new int[1], encoder);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeName(Name name, ByteBuffer input) throws EncodingException {
        BinaryXmlDecoder decoder = new BinaryXmlDecoder(input);
        BinaryXmlWireFormat.decodeName(name, new int[1], new int[1], decoder);
    }

    @Override
    public Blob encodeInterest(Interest interest, int[] signedPortionBeginOffset, int[] signedPortionEndOffset) {
        BinaryXmlEncoder encoder = new BinaryXmlEncoder();
        BinaryXmlWireFormat.encodeInterest(interest, signedPortionBeginOffset, signedPortionEndOffset, encoder);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeInterest(Interest interest, ByteBuffer input, int[] signedPortionBeginOffset, int[] signedPortionEndOffset) throws EncodingException {
        BinaryXmlDecoder decoder = new BinaryXmlDecoder(input);
        BinaryXmlWireFormat.decodeInterest(interest, signedPortionBeginOffset, signedPortionEndOffset, decoder);
    }

    @Override
    public Blob encodeData(Data data, int[] signedPortionBeginOffset, int[] signedPortionEndOffset) {
        BinaryXmlEncoder encoder = new BinaryXmlEncoder(1500);
        BinaryXmlWireFormat.encodeData(data, signedPortionBeginOffset, signedPortionEndOffset, encoder);
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeData(Data data, ByteBuffer input, int[] signedPortionBeginOffset, int[] signedPortionEndOffset) throws EncodingException {
        BinaryXmlDecoder decoder = new BinaryXmlDecoder(input);
        BinaryXmlWireFormat.decodeData(data, input, signedPortionBeginOffset, signedPortionEndOffset, decoder);
    }

    @Override
    public Blob encodeForwardingEntry(ForwardingEntry forwardingEntry) {
        BinaryXmlEncoder encoder = new BinaryXmlEncoder();
        encoder.writeElementStartDTag(81);
        encoder.writeOptionalUDataDTagElement(73, new Blob(forwardingEntry.getAction()));
        BinaryXmlWireFormat.encodeName(forwardingEntry.getPrefix(), new int[1], new int[1], encoder);
        BinaryXmlWireFormat.encodePublisherPublicKeyDigest(forwardingEntry.getPublisherPublicKeyDigest(), encoder);
        encoder.writeOptionalUnsignedDecimalIntDTagElement(74, forwardingEntry.getFaceId());
        encoder.writeUnsignedDecimalIntDTagElement(79, forwardingEntry.getForwardingFlags().getForwardingEntryFlags());
        if (forwardingEntry.getFreshnessPeriod() >= 0.0) {
            encoder.writeOptionalUnsignedDecimalIntDTagElement(58, (int)Math.round(forwardingEntry.getFreshnessPeriod() / 1000.0));
        }
        encoder.writeElementClose();
        return new Blob(encoder.getOutput(), false);
    }

    @Override
    public void decodeForwardingEntry(ForwardingEntry forwardingEntry, ByteBuffer input) throws EncodingException {
        BinaryXmlDecoder decoder = new BinaryXmlDecoder(input);
        decoder.readElementStartDTag(81);
        ByteBuffer action = decoder.readOptionalUDataDTagElement(73);
        if (action != null) {
            forwardingEntry.setAction(new String(new Blob(action, true).getImmutableArray()));
        } else {
            forwardingEntry.setAction("");
        }
        BinaryXmlWireFormat.decodeName(forwardingEntry.getPrefix(), new int[1], new int[1], decoder);
        BinaryXmlWireFormat.decodeOptionalPublisherPublicKeyDigest(forwardingEntry.getPublisherPublicKeyDigest(), decoder);
        forwardingEntry.setFaceId(decoder.readOptionalUnsignedIntegerDTagElement(74));
        int forwardingEntryFlags = decoder.readOptionalUnsignedIntegerDTagElement(79);
        if (forwardingEntryFlags >= 0) {
            forwardingEntry.getForwardingFlags().setForwardingEntryFlags(forwardingEntryFlags);
        } else {
            forwardingEntry.setForwardingFlags(null);
        }
        int freshnessSeconds = decoder.readOptionalUnsignedIntegerDTagElement(58);
        forwardingEntry.setFreshnessPeriod(freshnessSeconds >= 0 ? (double)freshnessSeconds * 1000.0 : -1.0);
        decoder.readElementClose();
    }

    public static BinaryXmlWireFormat get() {
        return instance_;
    }

    private static void encodeName(Name name, int[] signedPortionBeginOffset, int[] signedPortionEndOffset, BinaryXmlEncoder encoder) {
        encoder.writeElementStartDTag(14);
        signedPortionBeginOffset[0] = encoder.getOffset();
        if (name.size() == 0) {
            signedPortionEndOffset[0] = signedPortionBeginOffset[0];
        } else {
            for (int i = 0; i < name.size(); ++i) {
                if (i == name.size() - 1) {
                    signedPortionEndOffset[0] = encoder.getOffset();
                }
                encoder.writeBlobDTagElement(15, name.get(i).getValue());
            }
        }
        encoder.writeElementClose();
    }

    private static void decodeName(Name name, int[] signedPortionBeginOffset, int[] signedPortionEndOffset, BinaryXmlDecoder decoder) throws EncodingException {
        decoder.readElementStartDTag(14);
        name.clear();
        signedPortionBeginOffset[0] = decoder.getOffset();
        signedPortionEndOffset[0] = signedPortionBeginOffset[0];
        while (decoder.peekDTag(15)) {
            signedPortionEndOffset[0] = decoder.getOffset();
            name.append(new Blob(decoder.readBinaryDTagElement(15), true));
        }
        decoder.readElementClose();
    }

    private static void encodeInterest(Interest interest, int[] signedPortionBeginOffset, int[] signedPortionEndOffset, BinaryXmlEncoder encoder) {
        encoder.writeElementStartDTag(26);
        BinaryXmlWireFormat.encodeName(interest.getName(), signedPortionBeginOffset, signedPortionEndOffset, encoder);
        encoder.writeOptionalUnsignedDecimalIntDTagElement(83, interest.getMinSuffixComponents());
        encoder.writeOptionalUnsignedDecimalIntDTagElement(84, interest.getMaxSuffixComponents());
        if (interest.getKeyLocator().getType() == KeyLocatorType.KEY_LOCATOR_DIGEST && interest.getKeyLocator().getKeyData().size() > 0) {
            encoder.writeBlobDTagElement(60, interest.getKeyLocator().getKeyData());
        } else {
            BinaryXmlWireFormat.encodePublisherPublicKeyDigest(interest.getPublisherPublicKeyDigest(), encoder);
        }
        BinaryXmlWireFormat.encodeExclude(interest.getExclude(), encoder);
        encoder.writeOptionalUnsignedDecimalIntDTagElement(85, interest.getChildSelector());
        if (interest.getAnswerOriginKind() >= 0 && interest.getAnswerOriginKind() != 3) {
            encoder.writeUnsignedDecimalIntDTagElement(47, interest.getAnswerOriginKind());
        }
        encoder.writeOptionalUnsignedDecimalIntDTagElement(42, interest.getScope());
        encoder.writeOptionalTimeMillisecondsDTagElement(48, interest.getInterestLifetimeMilliseconds());
        encoder.writeOptionalBlobDTagElement(41, interest.getNonce());
        encoder.writeElementClose();
    }

    private static void decodeInterest(Interest interest, int[] signedPortionBeginOffset, int[] signedPortionEndOffset, BinaryXmlDecoder decoder) throws EncodingException {
        decoder.readElementStartDTag(26);
        BinaryXmlWireFormat.decodeName(interest.getName(), signedPortionBeginOffset, signedPortionEndOffset, decoder);
        interest.setMinSuffixComponents(decoder.readOptionalUnsignedIntegerDTagElement(83));
        interest.setMaxSuffixComponents(decoder.readOptionalUnsignedIntegerDTagElement(84));
        interest.getKeyLocator().clear();
        BinaryXmlWireFormat.decodeOptionalPublisherPublicKeyDigest(interest.getPublisherPublicKeyDigest(), decoder);
        if (interest.getPublisherPublicKeyDigest().getPublisherPublicKeyDigest().size() > 0) {
            interest.getKeyLocator().setType(KeyLocatorType.KEY_LOCATOR_DIGEST);
            interest.getKeyLocator().setKeyData(interest.getPublisherPublicKeyDigest().getPublisherPublicKeyDigest());
        }
        if (decoder.peekDTag(43)) {
            BinaryXmlWireFormat.decodeExclude(interest.getExclude(), decoder);
        } else {
            interest.getExclude().clear();
        }
        interest.setChildSelector(decoder.readOptionalUnsignedIntegerDTagElement(85));
        interest.setAnswerOriginKind(decoder.readOptionalUnsignedIntegerDTagElement(47));
        interest.setScope(decoder.readOptionalUnsignedIntegerDTagElement(42));
        interest.setInterestLifetimeMilliseconds(decoder.readOptionalTimeMillisecondsDTagElement(48));
        interest.setNonce(new Blob(decoder.readOptionalBinaryDTagElement(41), true));
        decoder.readElementClose();
    }

    private static void encodeData(Data data, int[] signedPortionBeginOffset, int[] signedPortionEndOffset, BinaryXmlEncoder encoder) {
        encoder.writeElementStartDTag(64);
        BinaryXmlWireFormat.encodeSignature((Sha256WithRsaSignature)data.getSignature(), encoder);
        signedPortionBeginOffset[0] = encoder.getOffset();
        BinaryXmlWireFormat.encodeName(data.getName(), new int[1], new int[1], encoder);
        BinaryXmlWireFormat.encodeSignedInfo((Sha256WithRsaSignature)data.getSignature(), data.getMetaInfo(), encoder);
        encoder.writeBlobDTagElement(19, data.getContent());
        signedPortionEndOffset[0] = encoder.getOffset();
        encoder.writeElementClose();
    }

    private static void decodeData(Data data, ByteBuffer input, int[] signedPortionBeginOffset, int[] signedPortionEndOffset, BinaryXmlDecoder decoder) throws EncodingException {
        decoder.readElementStartDTag(64);
        data.setSignature(new Sha256WithRsaSignature());
        if (decoder.peekDTag(37)) {
            BinaryXmlWireFormat.decodeSignature((Sha256WithRsaSignature)data.getSignature(), decoder);
        }
        signedPortionBeginOffset[0] = decoder.getOffset();
        BinaryXmlWireFormat.decodeName(data.getName(), new int[1], new int[1], decoder);
        data.setMetaInfo(new MetaInfo());
        if (decoder.peekDTag(20)) {
            BinaryXmlWireFormat.decodeSignedInfo((Sha256WithRsaSignature)data.getSignature(), data.getMetaInfo(), decoder);
        }
        data.setContent(new Blob(decoder.readBinaryDTagElement(19, true), true));
        signedPortionEndOffset[0] = decoder.getOffset();
        decoder.readElementClose();
    }

    private static void encodePublisherPublicKeyDigest(PublisherPublicKeyDigest publisherPublicKeyDigest, BinaryXmlEncoder encoder) {
        if (publisherPublicKeyDigest.getPublisherPublicKeyDigest().size() <= 0) {
            return;
        }
        encoder.writeBlobDTagElement(60, publisherPublicKeyDigest.getPublisherPublicKeyDigest());
    }

    private static void decodePublisherPublicKeyDigest(PublisherPublicKeyDigest publisherPublicKeyDigest, BinaryXmlDecoder decoder) throws EncodingException {
        publisherPublicKeyDigest.setPublisherPublicKeyDigest(new Blob(decoder.readBinaryDTagElement(60), true));
    }

    private static void decodeOptionalPublisherPublicKeyDigest(PublisherPublicKeyDigest publisherPublicKeyDigest, BinaryXmlDecoder decoder) throws EncodingException {
        if (decoder.peekDTag(60)) {
            BinaryXmlWireFormat.decodePublisherPublicKeyDigest(publisherPublicKeyDigest, decoder);
        } else {
            publisherPublicKeyDigest.clear();
        }
    }

    private static void encodeExclude(Exclude exclude, BinaryXmlEncoder encoder) {
        if (exclude.size() <= 0) {
            return;
        }
        encoder.writeElementStartDTag(43);
        for (int i = 0; i < exclude.size(); ++i) {
            Exclude.Entry entry = exclude.get(i);
            if (entry.getType() == Exclude.Type.COMPONENT) {
                encoder.writeBlobDTagElement(15, entry.getComponent().getValue());
                continue;
            }
            encoder.writeElementStartDTag(13);
            encoder.writeElementClose();
        }
        encoder.writeElementClose();
    }

    private static void decodeExclude(Exclude exclude, BinaryXmlDecoder decoder) throws EncodingException {
        decoder.readElementStartDTag(43);
        exclude.clear();
        while (true) {
            if (decoder.peekDTag(15)) {
                exclude.appendComponent(new Name.Component(new Blob(decoder.readBinaryDTagElement(15), true)));
                continue;
            }
            if (decoder.peekDTag(13)) {
                decoder.readElementStartDTag(13);
                decoder.readElementClose();
                exclude.appendAny();
                continue;
            }
            if (!decoder.peekDTag(44)) break;
            decoder.readBinaryDTagElement(44);
            exclude.appendAny();
        }
        decoder.readElementClose();
    }

    private static void encodeSignature(Sha256WithRsaSignature signature, BinaryXmlEncoder encoder) {
        encoder.writeElementStartDTag(37);
        encoder.writeOptionalBlobDTagElement(53, signature.getWitness());
        encoder.writeBlobDTagElement(54, signature.getSignature());
        encoder.writeElementClose();
    }

    private static void decodeSignature(Sha256WithRsaSignature signature, BinaryXmlDecoder decoder) throws EncodingException {
        decoder.readElementStartDTag(37);
        signature.setDigestAlgorithm(new Blob());
        signature.setWitness(new Blob(decoder.readOptionalBinaryDTagElement(53), true));
        signature.setSignature(new Blob(decoder.readBinaryDTagElement(54), true));
        decoder.readElementClose();
    }

    private static void encodeKeyLocator(KeyLocator keyLocator, BinaryXmlEncoder encoder) {
        if (keyLocator.getType() == KeyLocatorType.NONE) {
            return;
        }
        if (keyLocator.getType() == KeyLocatorType.KEY_LOCATOR_DIGEST) {
            return;
        }
        encoder.writeElementStartDTag(28);
        if (keyLocator.getType() == KeyLocatorType.KEY) {
            encoder.writeBlobDTagElement(27, keyLocator.getKeyData());
        } else if (keyLocator.getType() == KeyLocatorType.CERTIFICATE) {
            encoder.writeBlobDTagElement(16, keyLocator.getKeyData());
        } else if (keyLocator.getType() == KeyLocatorType.KEYNAME) {
            encoder.writeElementStartDTag(29);
            BinaryXmlWireFormat.encodeName(keyLocator.getKeyName(), new int[1], new int[1], encoder);
            if (keyLocator.getKeyNameType() != KeyNameType.NONE && keyLocator.getKeyData().size() > 0) {
                if (keyLocator.getKeyNameType() == KeyNameType.PUBLISHER_PUBLIC_KEY_DIGEST) {
                    encoder.writeBlobDTagElement(60, keyLocator.getKeyData());
                } else if (keyLocator.getKeyNameType() == KeyNameType.PUBLISHER_CERTIFICATE_DIGEST) {
                    encoder.writeBlobDTagElement(61, keyLocator.getKeyData());
                } else if (keyLocator.getKeyNameType() == KeyNameType.PUBLISHER_ISSUER_KEY_DIGEST) {
                    encoder.writeBlobDTagElement(62, keyLocator.getKeyData());
                } else if (keyLocator.getKeyNameType() == KeyNameType.PUBLISHER_ISSUER_CERTIFICATE_DIGEST) {
                    encoder.writeBlobDTagElement(63, keyLocator.getKeyData());
                } else {
                    throw new Error("unrecognized KeyNameType");
                }
            }
            encoder.writeElementClose();
        } else {
            throw new Error("unrecognized KeyLocatorType");
        }
        encoder.writeElementClose();
    }

    private static void decodeKeyNameData(KeyLocator keyLocator, BinaryXmlDecoder decoder) throws EncodingException {
        if (decoder.peekDTag(60)) {
            keyLocator.setKeyNameType(KeyNameType.PUBLISHER_PUBLIC_KEY_DIGEST);
            keyLocator.setKeyData(new Blob(decoder.readBinaryDTagElement(60), true));
        } else if (decoder.peekDTag(61)) {
            keyLocator.setKeyNameType(KeyNameType.PUBLISHER_CERTIFICATE_DIGEST);
            keyLocator.setKeyData(new Blob(decoder.readBinaryDTagElement(61), true));
        } else if (decoder.peekDTag(62)) {
            keyLocator.setKeyNameType(KeyNameType.PUBLISHER_ISSUER_KEY_DIGEST);
            keyLocator.setKeyData(new Blob(decoder.readBinaryDTagElement(62), true));
        } else if (decoder.peekDTag(63)) {
            keyLocator.setKeyNameType(KeyNameType.PUBLISHER_ISSUER_CERTIFICATE_DIGEST);
            keyLocator.setKeyData(new Blob(decoder.readBinaryDTagElement(63), true));
        } else {
            keyLocator.setKeyNameType(KeyNameType.NONE);
            keyLocator.setKeyData(new Blob());
        }
    }

    private static void decodeKeyLocator(KeyLocator keyLocator, BinaryXmlDecoder decoder) throws EncodingException {
        keyLocator.clear();
        decoder.readElementStartDTag(28);
        if (decoder.peekDTag(27)) {
            keyLocator.setType(KeyLocatorType.KEY);
            keyLocator.setKeyData(new Blob(decoder.readBinaryDTagElement(27), true));
        } else if (decoder.peekDTag(16)) {
            keyLocator.setType(KeyLocatorType.CERTIFICATE);
            keyLocator.setKeyData(new Blob(decoder.readBinaryDTagElement(16), true));
        } else if (decoder.peekDTag(29)) {
            keyLocator.setType(KeyLocatorType.KEYNAME);
            decoder.readElementStartDTag(29);
            BinaryXmlWireFormat.decodeName(keyLocator.getKeyName(), new int[1], new int[1], decoder);
            BinaryXmlWireFormat.decodeKeyNameData(keyLocator, decoder);
            decoder.readElementClose();
        } else {
            throw new EncodingException("decodeKeyLocator: unrecognized key locator type");
        }
        decoder.readElementClose();
    }

    private static void decodeOptionalKeyLocator(KeyLocator keyLocator, BinaryXmlDecoder decoder) throws EncodingException {
        if (decoder.peekDTag(28)) {
            BinaryXmlWireFormat.decodeKeyLocator(keyLocator, decoder);
        } else {
            keyLocator.clear();
        }
    }

    private static void encodeSignedInfo(Sha256WithRsaSignature signature, MetaInfo metaInfo, BinaryXmlEncoder encoder) {
        encoder.writeElementStartDTag(20);
        if (signature.getPublisherPublicKeyDigest().getPublisherPublicKeyDigest().size() > 0) {
            BinaryXmlWireFormat.encodePublisherPublicKeyDigest(signature.getPublisherPublicKeyDigest(), encoder);
        } else if (signature.getKeyLocator().getType() == KeyLocatorType.KEY_LOCATOR_DIGEST && signature.getKeyLocator().getKeyData().size() > 0) {
            encoder.writeBlobDTagElement(60, signature.getKeyLocator().getKeyData());
        }
        encoder.writeOptionalTimeMillisecondsDTagElement(39, metaInfo.getTimestampMilliseconds());
        if (metaInfo.getType() != ContentType.DATA && metaInfo.getType() != ContentType.BLOB) {
            Blob typeBytes = null;
            if (metaInfo.getType() == ContentType.ENCR) {
                typeBytes = ENCR_BYTES;
            } else if (metaInfo.getType() == ContentType.GONE) {
                typeBytes = GONE_BYTES;
            } else if (metaInfo.getType() == ContentType.KEY) {
                typeBytes = KEY_BYTES;
            } else if (metaInfo.getType() == ContentType.LINK) {
                typeBytes = LINK_BYTES;
            } else if (metaInfo.getType() == ContentType.NACK) {
                typeBytes = NACK_BYTES;
            }
            encoder.writeBlobDTagElement(40, typeBytes);
        }
        encoder.writeOptionalUnsignedDecimalIntDTagElement(58, metaInfo.getFreshnessSeconds());
        encoder.writeOptionalBlobDTagElement(59, metaInfo.getFinalBlockId().getValue());
        BinaryXmlWireFormat.encodeKeyLocator(signature.getKeyLocator(), encoder);
        encoder.writeElementClose();
    }

    private static void decodeSignedInfo(Sha256WithRsaSignature signature, MetaInfo metaInfo, BinaryXmlDecoder decoder) throws EncodingException {
        decoder.readElementStartDTag(20);
        BinaryXmlWireFormat.decodeOptionalPublisherPublicKeyDigest(signature.getPublisherPublicKeyDigest(), decoder);
        metaInfo.setTimestampMilliseconds(decoder.readOptionalTimeMillisecondsDTagElement(39));
        ByteBuffer typeBytes = decoder.readOptionalBinaryDTagElement(40);
        if (typeBytes == null) {
            metaInfo.setType(ContentType.BLOB);
        } else if (typeBytes.equals(DATA_BYTES.buf())) {
            metaInfo.setType(ContentType.BLOB);
        } else if (typeBytes.equals(ENCR_BYTES.buf())) {
            metaInfo.setType(ContentType.ENCR);
        } else if (typeBytes.equals(GONE_BYTES.buf())) {
            metaInfo.setType(ContentType.GONE);
        } else if (typeBytes.equals(KEY_BYTES.buf())) {
            metaInfo.setType(ContentType.KEY);
        } else if (typeBytes.equals(LINK_BYTES.buf())) {
            metaInfo.setType(ContentType.LINK);
        } else if (typeBytes.equals(NACK_BYTES.buf())) {
            metaInfo.setType(ContentType.NACK);
        } else {
            throw new EncodingException("Unrecognized MetaInfo.ContentType");
        }
        metaInfo.setFreshnessSeconds(decoder.readOptionalUnsignedIntegerDTagElement(58));
        metaInfo.setFinalBlockId(new Name.Component(new Blob(decoder.readOptionalBinaryDTagElement(59), true)));
        BinaryXmlWireFormat.decodeOptionalKeyLocator(signature.getKeyLocator(), decoder);
        decoder.readElementClose();
    }
}

