/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encoding;

import java.nio.ByteBuffer;
import net.named_data.jndn.encoding.BinaryXmlDecoder;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.util.DynamicByteBuffer;

public class BinaryXmlStructureDecoder {
    private static final int READ_HEADER_OR_CLOSE = 0;
    private static final int READ_BYTES = 1;
    private boolean gotElementEnd_;
    private int offset_;
    private int level_;
    private int state_ = 0;
    private int headerLength_;
    private boolean useHeaderBuffer_;
    private final DynamicByteBuffer headerBuffer_ = new DynamicByteBuffer(10);
    private int nBytesToRead_;

    public boolean findElementEnd(ByteBuffer input) throws EncodingException {
        if (this.gotElementEnd_) {
            return true;
        }
        BinaryXmlDecoder decoder = new BinaryXmlDecoder(input);
        while (true) {
            if (this.offset_ >= input.limit()) {
                return false;
            }
            if (this.state_ == 0) {
                BinaryXmlDecoder.TypeAndValue typeAndVal;
                byte headerByte;
                if (this.headerLength_ == 0 && input.get(this.offset_) == 0) {
                    ++this.offset_;
                    --this.level_;
                    if (this.level_ == 0) {
                        this.gotElementEnd_ = true;
                        return true;
                    }
                    if (this.level_ < 0) {
                        throw new Error("BinaryXMLStructureDecoder: Unexpected close tag at offset " + (this.offset_ - 1));
                    }
                    this.startHeader();
                    continue;
                }
                int startingHeaderLength = this.headerLength_;
                do {
                    if (this.offset_ >= input.limit()) {
                        this.useHeaderBuffer_ = true;
                        int nNewBytes = this.headerLength_ - startingHeaderLength;
                        this.headerBuffer_.ensuredPut(input, this.offset_ - nNewBytes, this.offset_);
                        return false;
                    }
                    headerByte = input.get(this.offset_++);
                    ++this.headerLength_;
                } while ((headerByte & 0x80) == 0);
                if (this.useHeaderBuffer_) {
                    int nNewBytes = this.headerLength_ - startingHeaderLength;
                    this.headerBuffer_.ensuredPut(input, this.offset_ - nNewBytes, this.offset_);
                    typeAndVal = new BinaryXmlDecoder(this.headerBuffer_.flippedBuffer()).decodeTypeAndValue();
                } else {
                    decoder.seek(this.offset_ - this.headerLength_);
                    typeAndVal = decoder.decodeTypeAndValue();
                }
                int type = typeAndVal.getType();
                if (type == 4) {
                    this.startHeader();
                    continue;
                }
                if (type == 2 || type == 0) {
                    ++this.level_;
                    this.startHeader();
                    continue;
                }
                if (type == 1 || type == 3) {
                    if (type == 1) {
                        ++this.level_;
                    }
                    this.nBytesToRead_ = typeAndVal.getValue() + 1;
                    this.state_ = 1;
                    continue;
                }
                if (type == 5 || type == 6) {
                    this.nBytesToRead_ = typeAndVal.getValue();
                    this.state_ = 1;
                    continue;
                }
                throw new EncodingException("BinaryXMLStructureDecoder: Unrecognized header type " + type);
            }
            if (this.state_ != 1) break;
            int nRemainingBytes = input.limit() - this.offset_;
            if (nRemainingBytes < this.nBytesToRead_) {
                this.offset_ += nRemainingBytes;
                this.nBytesToRead_ -= nRemainingBytes;
                return false;
            }
            this.offset_ += this.nBytesToRead_;
            this.startHeader();
        }
        throw new EncodingException("BinaryXMLStructureDecoder: Unrecognized state " + this.state_);
    }

    public void seek(int offset) {
        this.offset_ = offset;
    }

    public int getOffset() {
        return this.offset_;
    }

    private void startHeader() {
        this.headerLength_ = 0;
        this.headerBuffer_.position(0);
        this.useHeaderBuffer_ = false;
        this.state_ = 0;
    }
}

