/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encoding;

import java.nio.ByteBuffer;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.DynamicByteBuffer;

public class BinaryXmlEncoder {
    public static final int ENCODING_LIMIT_1_BYTE = 15;
    public static final int ENCODING_LIMIT_2_BYTES = 2047;
    public static final int ENCODING_LIMIT_3_BYTES = 262143;
    private final DynamicByteBuffer output_;

    public BinaryXmlEncoder(int initialCapacity) {
        this.output_ = new DynamicByteBuffer(initialCapacity);
    }

    public BinaryXmlEncoder() {
        this.output_ = new DynamicByteBuffer(16);
    }

    public final int getOffset() {
        return this.output_.position();
    }

    public final ByteBuffer getOutput() {
        return this.output_.flippedBuffer();
    }

    public final void writeElementStartDTag(int tag) {
        this.encodeTypeAndValue(2, tag);
    }

    public final void writeElementClose() {
        this.output_.ensuredPut((byte)0);
    }

    public final void writeBlob(Blob value) {
        this.encodeTypeAndValue(5, value.size());
        if (value.size() > 0) {
            this.writeBuffer(value.buf());
        }
    }

    public final void writeBlobDTagElement(int tag, Blob value) {
        this.writeElementStartDTag(tag);
        this.writeBlob(value);
        this.writeElementClose();
    }

    public final void writeOptionalBlobDTagElement(int tag, Blob value) {
        if (value.buf() != null && value.size() > 0) {
            this.writeBlobDTagElement(tag, value);
        }
    }

    public final void writeUData(Blob value) {
        this.encodeTypeAndValue(6, value.size());
        this.writeBuffer(value.buf());
    }

    public final void writeUDataDTagElement(int tag, Blob value) {
        this.writeElementStartDTag(tag);
        this.writeUData(value);
        this.writeElementClose();
    }

    public final void writeOptionalUDataDTagElement(int tag, Blob value) {
        if (value.buf() != null && value.size() > 0) {
            this.writeUDataDTagElement(tag, value);
        }
    }

    public final void writeUnsignedDecimalInt(int value) {
        int startPosition = this.output_.position();
        this.encodeReversedUnsignedDecimalInt(value);
        this.reverseBufferAndInsertHeader(startPosition, 6);
    }

    public final void writeUnsignedDecimalIntDTagElement(int tag, int value) {
        this.writeElementStartDTag(tag);
        this.writeUnsignedDecimalInt(value);
        this.writeElementClose();
    }

    public final void writeOptionalUnsignedDecimalIntDTagElement(int tag, int value) {
        if (value >= 0) {
            this.writeUnsignedDecimalIntDTagElement(tag, value);
        }
    }

    public final void writeAbsDoubleBigEndianBlob(double value) {
        int startPosition = this.output_.position();
        for (long int64 = Math.round(Math.abs(value)); int64 != 0L; int64 >>= 8) {
            this.output_.ensuredPut((byte)(int64 & 0xFFL));
        }
        this.reverseBufferAndInsertHeader(startPosition, 5);
    }

    public final void writeTimeMillisecondsDTagElement(int tag, double milliseconds) {
        this.writeElementStartDTag(tag);
        this.writeAbsDoubleBigEndianBlob(milliseconds / 1000.0 * 4096.0);
        this.writeElementClose();
    }

    public final void writeOptionalTimeMillisecondsDTagElement(int tag, double milliseconds) {
        if (milliseconds >= 0.0) {
            this.writeTimeMillisecondsDTagElement(tag, milliseconds);
        }
    }

    private void encodeTypeAndValue(int type, int value) {
        if (type > 6) {
            throw new Error("Header type is out of range");
        }
        int nEncodingBytes = BinaryXmlEncoder.getNHeaderEncodingBytes(value);
        this.output_.ensureRemainingCapacity(nEncodingBytes);
        this.output_.buffer().put(this.output_.position() + nEncodingBytes - 1, (byte)(7 & type | (0xF & value) << 3 | 0x80));
        value >>= 4;
        for (int i = this.output_.position() + nEncodingBytes - 2; value != 0 && i >= this.output_.position(); value >>= 7, --i) {
            this.output_.buffer().put(i, (byte)(value & 0x7F));
        }
        if (value != 0) {
            throw new Error("EncodeTypeAndValue miscalculated N encoding bytes");
        }
        this.output_.position(this.output_.position() + nEncodingBytes);
    }

    private void writeBuffer(ByteBuffer buffer) {
        this.output_.ensuredPut(buffer, buffer.position(), buffer.limit());
    }

    private static int getNHeaderEncodingBytes(int x) {
        if (x <= 15) {
            return 1;
        }
        if (x <= 2047) {
            return 2;
        }
        if (x <= 262143) {
            return 3;
        }
        int nBytes = 1;
        x >>= 4;
        while (x != 0) {
            ++nBytes;
            x >>= 7;
        }
        return nBytes;
    }

    private static void reverse(ByteBuffer buffer, int startPosition, int length) {
        if (length == 0) {
            return;
        }
        int left = startPosition;
        for (int right = startPosition + length - 1; left < right; ++left, --right) {
            byte temp = buffer.get(left);
            buffer.put(left, buffer.get(right));
            buffer.put(right, temp);
        }
    }

    private void encodeReversedUnsignedDecimalInt(int x) {
        if (x < 0) {
            x = 0;
        }
        do {
            this.output_.ensuredPut((byte)(x % 10 + 48));
        } while ((x /= 10) != 0);
    }

    private void reverseBufferAndInsertHeader(int startPosition, int type) {
        int from;
        int nBufferBytes = this.output_.position() - startPosition;
        int nHeaderBytes = BinaryXmlEncoder.getNHeaderEncodingBytes(nBufferBytes);
        this.output_.ensureRemainingCapacity(nHeaderBytes);
        int fromEnd = from + nHeaderBytes;
        int to = startPosition + nBufferBytes + nHeaderBytes - 1;
        for (from = startPosition; from < fromEnd; ++from) {
            this.output_.buffer().put(to, this.output_.buffer().get(from));
            --to;
        }
        if (nBufferBytes > nHeaderBytes) {
            BinaryXmlEncoder.reverse(this.output_.buffer(), startPosition + nHeaderBytes, nBufferBytes - nHeaderBytes);
        }
        this.output_.position(startPosition);
        this.encodeTypeAndValue(type, nBufferBytes);
        this.output_.position(startPosition + nHeaderBytes + nBufferBytes);
    }
}

