/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encoding;

import java.nio.ByteBuffer;
import net.named_data.jndn.encoding.EncodingException;

public class BinaryXmlDecoder {
    private final ByteBuffer input_;
    private int previouslyPeekedDTagStartOffset_ = -1;
    private int previouslyPeekedDTagEndOffset_;
    private int previouslyPeekedDTag_;

    public BinaryXmlDecoder(ByteBuffer input) {
        this.input_ = input.duplicate();
    }

    public TypeAndValue decodeTypeAndValue() throws EncodingException {
        int value = 0;
        boolean gotFirstOctet = false;
        while (true) {
            byte octet = this.input_.get();
            if (!gotFirstOctet) {
                if (octet == 0) {
                    throw new EncodingException("The first header octet may not be zero");
                }
                gotFirstOctet = true;
            }
            if ((octet & 0x80) != 0) {
                value = value << 4 | octet >> 3 & 0xF;
                return new TypeAndValue(octet & 7, value);
            }
            value = value << 7 | octet & 0x7F;
        }
    }

    public final void readElementStartDTag(int expectedTag) throws EncodingException {
        if (this.input_.position() == this.previouslyPeekedDTagStartOffset_) {
            if (this.previouslyPeekedDTag_ != expectedTag) {
                throw new EncodingException("Did not get the expected DTAG " + expectedTag + ", got " + this.previouslyPeekedDTag_);
            }
            this.input_.position(this.previouslyPeekedDTagEndOffset_);
        } else {
            TypeAndValue typeAndValue = this.decodeTypeAndValue();
            if (typeAndValue.getType() != 2) {
                throw new EncodingException("Header type is not a DTAG");
            }
            if (typeAndValue.getValue() != expectedTag) {
                throw new EncodingException("Did not get the expected DTAG " + expectedTag + ", got " + typeAndValue.getValue());
            }
        }
    }

    public final void readElementClose() throws EncodingException {
        if (this.input_.get() != 0) {
            throw new EncodingException("Did not get the expected element close");
        }
    }

    public final boolean peekDTag(int expectedTag) throws EncodingException {
        if (this.input_.position() == this.previouslyPeekedDTagStartOffset_) {
            return this.previouslyPeekedDTag_ == expectedTag;
        }
        if (this.input_.get(this.input_.position()) == 0) {
            return false;
        }
        int savePosition = this.input_.position();
        TypeAndValue typeAndValue = this.decodeTypeAndValue();
        this.previouslyPeekedDTagEndOffset_ = this.input_.position();
        this.input_.position(savePosition);
        if (typeAndValue.getType() == 2) {
            this.previouslyPeekedDTagStartOffset_ = savePosition;
            this.previouslyPeekedDTag_ = typeAndValue.getValue();
            return typeAndValue.getValue() == expectedTag;
        }
        return false;
    }

    public final ByteBuffer readBinaryDTagElement(int expectedTag, boolean allowNull) throws EncodingException {
        this.readElementStartDTag(expectedTag);
        if (allowNull && this.input_.get(this.input_.position()) == 0) {
            this.input_.get();
            return null;
        }
        TypeAndValue typeAndValue = this.decodeTypeAndValue();
        int saveLimit = this.input_.limit();
        this.input_.limit(this.input_.position() + typeAndValue.getValue());
        ByteBuffer result = this.input_.slice();
        this.input_.limit(saveLimit);
        this.input_.position(this.input_.position() + typeAndValue.getValue());
        this.readElementClose();
        return result;
    }

    public final ByteBuffer readBinaryDTagElement(int expectedTag) throws EncodingException {
        return this.readBinaryDTagElement(expectedTag, false);
    }

    public final ByteBuffer readOptionalBinaryDTagElement(int expectedTag, boolean allowNull) throws EncodingException {
        if (this.peekDTag(expectedTag)) {
            return this.readBinaryDTagElement(expectedTag, allowNull);
        }
        return null;
    }

    public final ByteBuffer readOptionalBinaryDTagElement(int expectedTag) throws EncodingException {
        return this.readOptionalBinaryDTagElement(expectedTag, false);
    }

    public final ByteBuffer readUDataDTagElement(int expectedTag) throws EncodingException {
        this.readElementStartDTag(expectedTag);
        TypeAndValue typeAndValue = this.decodeTypeAndValue();
        if (typeAndValue.getType() != 6) {
            throw new EncodingException("The item is not UDATA");
        }
        int saveLimit = this.input_.limit();
        this.input_.limit(this.input_.position() + typeAndValue.getValue());
        ByteBuffer result = this.input_.slice();
        this.input_.limit(saveLimit);
        this.input_.position(this.input_.position() + typeAndValue.getValue());
        this.readElementClose();
        return result;
    }

    public final ByteBuffer readOptionalUDataDTagElement(int expectedTag) throws EncodingException {
        if (this.peekDTag(expectedTag)) {
            return this.readUDataDTagElement(expectedTag);
        }
        return null;
    }

    public final int readUnsignedIntegerDTagElement(int expectedTag) throws EncodingException {
        return this.parseUnsignedDecimalInt(this.readUDataDTagElement(expectedTag));
    }

    public final int readOptionalUnsignedIntegerDTagElement(int expectedTag) throws EncodingException {
        if (this.peekDTag(expectedTag)) {
            return this.readUnsignedIntegerDTagElement(expectedTag);
        }
        return -1;
    }

    public final double readTimeMillisecondsDTagElement(int expectedTag) throws EncodingException {
        return 1000.0 * this.unsignedBigEndianToDouble(this.readBinaryDTagElement(expectedTag)) / 4096.0;
    }

    public final double readOptionalTimeMillisecondsDTagElement(int expectedTag) throws EncodingException {
        if (this.peekDTag(expectedTag)) {
            return this.readTimeMillisecondsDTagElement(expectedTag);
        }
        return -1.0;
    }

    public final double unsignedBigEndianToDouble(ByteBuffer bytes) {
        double result = 0.0;
        for (int i = bytes.position(); i < bytes.limit(); ++i) {
            result *= 256.0;
            result += (double)(bytes.get(i) & 0xFF);
        }
        return result;
    }

    public final int getOffset() {
        return this.input_.position();
    }

    public final void seek(int position) {
        this.input_.position(position);
    }

    private int parseUnsignedDecimalInt(ByteBuffer value) throws EncodingException {
        int result = 0;
        for (int i = value.position(); i < value.limit(); ++i) {
            char digit = (char)value.get(i);
            if (digit < '0' || digit > '9') {
                throw new EncodingException("Element of the value is not a decimal digit:" + digit);
            }
            result *= 10;
            result += digit - 48;
        }
        return result;
    }

    public class TypeAndValue {
        private final int type_;
        private final int value_;

        public TypeAndValue(int type, int value) {
            this.type_ = type;
            this.value_ = value;
        }

        int getType() {
            return this.type_;
        }

        int getValue() {
            return this.value_;
        }
    }
}

