/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.transport.Transport;

public class ThreadPoolFace
extends Face {
    private final ScheduledExecutorService threadPool_;

    public ThreadPoolFace(ScheduledExecutorService threadPool, Transport transport, Transport.ConnectionInfo connectionInfo) {
        super(transport, connectionInfo);
        this.threadPool_ = threadPool;
    }

    @Override
    public long expressInterest(final Interest interest, final OnData onData, final OnTimeout onTimeout, final WireFormat wireFormat) throws IOException {
        final long pendingInterestId = this.node_.getNextEntryId();
        final OnData onDataSubmit = new OnData(){

            @Override
            public void onData(final Interest localInterest, final Data data) {
                ThreadPoolFace.this.threadPool_.submit(new Runnable(){

                    @Override
                    public void run() {
                        onData.onData(localInterest, data);
                    }
                });
            }
        };
        final OnTimeout onTimeoutSubmit = onTimeout == null ? null : new OnTimeout(){

            @Override
            public void onTimeout(final Interest localInterest) {
                ThreadPoolFace.this.threadPool_.submit(new Runnable(){

                    @Override
                    public void run() {
                        onTimeout.onTimeout(localInterest);
                    }
                });
            }
        };
        this.threadPool_.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ThreadPoolFace.this.node_.expressInterest(pendingInterestId, interest, onDataSubmit, onTimeoutSubmit, wireFormat, ThreadPoolFace.this);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        return pendingInterestId;
    }

    @Override
    public void callLater(double delayMilliseconds, final Runnable callback) {
        this.threadPool_.schedule(new Runnable(){

            @Override
            public void run() {
                callback.run();
            }
        }, (long)delayMilliseconds, TimeUnit.MILLISECONDS);
    }
}

