/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.PublisherPublicKeyDigest;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.ChangeCounter;

public class Sha256WithRsaSignature
extends Signature {
    private Blob digestAlgorithm_ = new Blob();
    private Blob witness_ = new Blob();
    private Blob signature_ = new Blob();
    private final ChangeCounter publisherPublicKeyDigest_ = new ChangeCounter(new PublisherPublicKeyDigest());
    private final ChangeCounter keyLocator_ = new ChangeCounter(new KeyLocator());
    private long changeCount_ = 0L;

    public Sha256WithRsaSignature() {
    }

    public Sha256WithRsaSignature(Sha256WithRsaSignature signature) {
        this.digestAlgorithm_ = signature.digestAlgorithm_;
        this.witness_ = signature.witness_;
        this.signature_ = signature.signature_;
        this.publisherPublicKeyDigest_.set(new PublisherPublicKeyDigest(signature.getPublisherPublicKeyDigest()));
        this.keyLocator_.set(new KeyLocator(signature.getKeyLocator()));
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new Sha256WithRsaSignature(this);
    }

    public final Blob getDigestAlgorithm() {
        if (!WireFormat.ENABLE_NDNX) {
            throw new Error("The Digest Algorithm is for the NDNx wire format and is deprecated. To enable while you upgrade your code to use NDN-TLV, set WireFormat.ENABLE_NDNX = true");
        }
        return this.digestAlgorithm_;
    }

    public final Blob getWitness() {
        if (!WireFormat.ENABLE_NDNX) {
            throw new Error("The Witness is for the NDNx wire format and is deprecated. To enable while you upgrade your code to use NDN-TLV, set WireFormat.ENABLE_NDNX = true");
        }
        return this.witness_;
    }

    @Override
    public final Blob getSignature() {
        return this.signature_;
    }

    public final PublisherPublicKeyDigest getPublisherPublicKeyDigest() {
        return (PublisherPublicKeyDigest)this.publisherPublicKeyDigest_.get();
    }

    public final KeyLocator getKeyLocator() {
        return (KeyLocator)this.keyLocator_.get();
    }

    public final void setDigestAlgorithm(Blob digestAlgorithm) {
        if (!WireFormat.ENABLE_NDNX) {
            throw new Error("The Digest Algorithm is for the NDNx wire format and is deprecated. To enable while you upgrade your code to use NDN-TLV, set WireFormat.ENABLE_NDNX = true");
        }
        this.digestAlgorithm_ = digestAlgorithm == null ? new Blob() : digestAlgorithm;
        ++this.changeCount_;
    }

    public final void setWitness(Blob witness) {
        if (!WireFormat.ENABLE_NDNX) {
            throw new Error("The Witness is for the NDNx wire format and is deprecated. To enable while you upgrade your code to use NDN-TLV, set WireFormat.ENABLE_NDNX = true");
        }
        this.witness_ = witness == null ? new Blob() : witness;
        ++this.changeCount_;
    }

    @Override
    public final void setSignature(Blob signature) {
        this.signature_ = signature == null ? new Blob() : signature;
        ++this.changeCount_;
    }

    public final void setPublisherPublicKeyDigest(PublisherPublicKeyDigest publisherPublicKeyDigest) {
        this.publisherPublicKeyDigest_.set(publisherPublicKeyDigest == null ? new PublisherPublicKeyDigest() : new PublisherPublicKeyDigest(publisherPublicKeyDigest));
        ++this.changeCount_;
    }

    public final void setKeyLocator(KeyLocator keyLocator) {
        this.keyLocator_.set(keyLocator == null ? new KeyLocator() : new KeyLocator(keyLocator));
        ++this.changeCount_;
    }

    @Override
    public final long getChangeCount() {
        boolean changed = this.publisherPublicKeyDigest_.checkChanged();
        boolean bl = changed = this.keyLocator_.checkChanged() || changed;
        if (changed) {
            ++this.changeCount_;
        }
        return this.changeCount_;
    }
}

