/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.ControlParameters;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.ForwardingEntry;
import net.named_data.jndn.ForwardingFlags;
import net.named_data.jndn.Interest;
import net.named_data.jndn.InterestFilter;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.LocalControlHeader;
import net.named_data.jndn.Name;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnInterestCallback;
import net.named_data.jndn.OnRegisterFailed;
import net.named_data.jndn.OnRegisterSuccess;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.Sha256WithRsaSignature;
import net.named_data.jndn.encoding.BinaryXmlDecoder;
import net.named_data.jndn.encoding.BinaryXmlWireFormat;
import net.named_data.jndn.encoding.ElementListener;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.TlvWireFormat;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.tlv.TlvDecoder;
import net.named_data.jndn.impl.DelayedCallTable;
import net.named_data.jndn.impl.InterestFilterTable;
import net.named_data.jndn.impl.PendingInterestTable;
import net.named_data.jndn.impl.RegisteredPrefixTable;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.transport.Transport;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.CommandInterestGenerator;
import net.named_data.jndn.util.Common;
import net.named_data.jndn.util.SignedBlob;

public class Node
implements ElementListener {
    private static final ByteBuffer SELFREG_PUBLIC_KEY_DER = Node.toBuffer(new int[]{48, 130, 1, 34, 48, 13, 6, 9, 42, 134, 72, 134, 247, 13, 1, 1, 1, 5, 0, 3, 130, 1, 15, 0, 48, 130, 1, 10, 2, 130, 1, 1, 0, 184, 9, 167, 89, 130, 132, 236, 79, 6, 250, 28, 178, 225, 56, 147, 83, 187, 125, 212, 172, 136, 26, 248, 37, 17, 228, 250, 29, 97, 36, 91, 130, 202, 205, 114, 206, 219, 102, 181, 141, 84, 189, 251, 35, 253, 232, 142, 175, 167, 179, 121, 190, 148, 181, 183, 186, 23, 182, 5, 174, 206, 67, 190, 59, 206, 110, 234, 7, 219, 191, 10, 126, 235, 188, 201, 123, 98, 60, 245, 225, 206, 225, 217, 141, 156, 254, 31, 199, 248, 251, 89, 192, 148, 11, 44, 217, 125, 188, 150, 235, 184, 121, 34, 138, 46, 160, 18, 29, 66, 7, 182, 93, 219, 225, 246, 177, 93, 123, 31, 84, 82, 28, 163, 17, 155, 249, 235, 190, 179, 149, 202, 165, 135, 63, 49, 24, 26, 201, 153, 1, 236, 170, 144, 253, 138, 54, 53, 94, 18, 129, 190, 132, 136, 161, 13, 25, 42, 74, 102, 193, 89, 60, 65, 131, 61, 61, 184, 212, 171, 52, 144, 6, 62, 26, 97, 116, 190, 4, 245, 122, 105, 27, 157, 86, 252, 131, 183, 96, 193, 94, 157, 133, 52, 253, 2, 26, 186, 44, 9, 114, 167, 74, 94, 24, 191, 192, 88, 167, 73, 52, 70, 97, 89, 14, 226, 110, 158, 210, 219, 253, 114, 47, 60, 71, 204, 95, 153, 98, 238, 13, 243, 31, 48, 37, 32, 146, 21, 75, 4, 254, 21, 25, 29, 220, 126, 92, 16, 33, 82, 33, 145, 84, 96, 139, 146, 65, 2, 3, 1, 0, 1});
    private static final ByteBuffer SELFREG_PRIVATE_KEY_DER = Node.toBuffer(new int[]{48, 130, 4, 191, 2, 1, 0, 48, 13, 6, 9, 42, 134, 72, 134, 247, 13, 1, 1, 1, 5, 0, 4, 130, 4, 169, 48, 130, 4, 165, 2, 1, 0, 2, 130, 1, 1, 0, 184, 9, 167, 89, 130, 132, 236, 79, 6, 250, 28, 178, 225, 56, 147, 83, 187, 125, 212, 172, 136, 26, 248, 37, 17, 228, 250, 29, 97, 36, 91, 130, 202, 205, 114, 206, 219, 102, 181, 141, 84, 189, 251, 35, 253, 232, 142, 175, 167, 179, 121, 190, 148, 181, 183, 186, 23, 182, 5, 174, 206, 67, 190, 59, 206, 110, 234, 7, 219, 191, 10, 126, 235, 188, 201, 123, 98, 60, 245, 225, 206, 225, 217, 141, 156, 254, 31, 199, 248, 251, 89, 192, 148, 11, 44, 217, 125, 188, 150, 235, 184, 121, 34, 138, 46, 160, 18, 29, 66, 7, 182, 93, 219, 225, 246, 177, 93, 123, 31, 84, 82, 28, 163, 17, 155, 249, 235, 190, 179, 149, 202, 165, 135, 63, 49, 24, 26, 201, 153, 1, 236, 170, 144, 253, 138, 54, 53, 94, 18, 129, 190, 132, 136, 161, 13, 25, 42, 74, 102, 193, 89, 60, 65, 131, 61, 61, 184, 212, 171, 52, 144, 6, 62, 26, 97, 116, 190, 4, 245, 122, 105, 27, 157, 86, 252, 131, 183, 96, 193, 94, 157, 133, 52, 253, 2, 26, 186, 44, 9, 114, 167, 74, 94, 24, 191, 192, 88, 167, 73, 52, 70, 97, 89, 14, 226, 110, 158, 210, 219, 253, 114, 47, 60, 71, 204, 95, 153, 98, 238, 13, 243, 31, 48, 37, 32, 146, 21, 75, 4, 254, 21, 25, 29, 220, 126, 92, 16, 33, 82, 33, 145, 84, 96, 139, 146, 65, 2, 3, 1, 0, 1, 2, 130, 1, 1, 0, 138, 5, 251, 115, 127, 22, 175, 159, 169, 76, 229, 63, 38, 248, 102, 77, 210, 252, 209, 6, 192, 96, 241, 159, 227, 166, 198, 10, 72, 179, 154, 202, 33, 205, 41, 128, 136, 61, 164, 133, 165, 123, 130, 33, 129, 40, 235, 242, 67, 36, 176, 118, 197, 82, 239, 194, 234, 75, 130, 65, 146, 194, 109, 166, 174, 240, 178, 38, 72, 161, 35, 127, 2, 207, 168, 144, 23, 162, 62, 138, 38, 189, 109, 138, 238, 166, 12, 49, 206, 194, 187, 146, 89, 181, 115, 226, 125, 145, 117, 226, 189, 140, 99, 226, 28, 139, 194, 106, 28, 254, 105, 192, 68, 203, 88, 87, 183, 19, 66, 240, 219, 80, 76, 224, 69, 9, 143, 202, 69, 138, 6, 254, 152, 209, 34, 245, 90, 154, 223, 137, 23, 202, 32, 204, 18, 169, 9, 61, 213, 247, 227, 235, 8, 74, 196, 18, 192, 185, 71, 108, 121, 80, 102, 163, 248, 175, 44, 250, 180, 107, 236, 3, 173, 203, 218, 36, 12, 82, 7, 135, 136, 192, 33, 243, 2, 232, 36, 68, 15, 205, 160, 173, 47, 27, 121, 171, 107, 73, 74, 230, 59, 208, 173, 195, 72, 185, 247, 241, 52, 9, 235, 122, 192, 213, 13, 57, 216, 69, 206, 54, 122, 216, 222, 60, 176, 33, 150, 151, 138, 255, 139, 35, 96, 79, 240, 61, 215, 143, 243, 44, 203, 29, 72, 63, 134, 196, 169, 0, 242, 35, 45, 114, 77, 102, 165, 1, 2, 129, 129, 0, 220, 79, 153, 68, 13, 127, 89, 70, 30, 143, 231, 45, 141, 221, 84, 192, 247, 250, 70, 13, 157, 53, 3, 241, 124, 18, 243, 90, 157, 131, 207, 221, 55, 33, 124, 183, 238, 195, 57, 210, 117, 143, 178, 45, 111, 236, 198, 3, 85, 215, 0, 103, 211, 155, 162, 104, 80, 111, 158, 40, 164, 118, 57, 43, 178, 101, 204, 114, 130, 147, 160, 207, 16, 5, 106, 117, 202, 133, 53, 153, 176, 166, 198, 239, 76, 77, 153, 125, 44, 56, 1, 33, 181, 49, 172, 128, 84, 196, 24, 75, 253, 239, 179, 48, 34, 81, 90, 234, 125, 155, 178, 157, 203, 186, 63, 192, 26, 107, 205, 176, 230, 47, 4, 51, 215, 58, 73, 113, 2, 129, 129, 0, 213, 217, 201, 112, 26, 19, 179, 57, 36, 2, 238, 176, 187, 132, 23, 18, 198, 189, 101, 115, 233, 52, 93, 67, 255, 220, 248, 85, 175, 42, 185, 225, 250, 113, 101, 78, 80, 15, 164, 59, 229, 104, 242, 73, 113, 175, 21, 136, 215, 175, 196, 157, 148, 132, 107, 91, 16, 213, 192, 170, 12, 19, 98, 153, 192, 139, 252, 144, 15, 135, 64, 77, 88, 136, 189, 226, 186, 62, 126, 45, 215, 105, 169, 60, 9, 100, 49, 182, 204, 77, 31, 35, 182, 158, 101, 214, 129, 220, 133, 204, 30, 241, 11, 132, 56, 171, 147, 95, 159, 146, 78, 147, 70, 149, 107, 62, 182, 195, 27, 215, 105, 161, 10, 151, 55, 120, 237, 209, 2, 129, 128, 51, 24, 195, 19, 101, 142, 3, 198, 159, 144, 0, 174, 48, 25, 5, 111, 60, 20, 111, 234, 248, 107, 51, 94, 238, 199, 246, 105, 45, 223, 68, 118, 170, 50, 186, 26, 110, 230, 24, 163, 23, 97, 28, 146, 45, 67, 93, 41, 168, 223, 20, 216, 255, 219, 56, 239, 184, 184, 42, 150, 130, 142, 104, 244, 25, 140, 66, 190, 204, 74, 49, 33, 213, 53, 108, 91, 165, 124, 255, 209, 133, 135, 40, 220, 151, 117, 232, 3, 128, 29, 253, 37, 52, 65, 49, 33, 18, 135, 232, 154, 183, 106, 192, 196, 137, 49, 21, 69, 13, 156, 238, 240, 106, 47, 232, 89, 69, 199, 123, 13, 108, 85, 187, 67, 202, 199, 90, 1, 2, 129, 129, 0, 171, 244, 213, 207, 120, 136, 130, 194, 221, 188, 37, 230, 162, 193, 210, 51, 220, 239, 10, 151, 43, 220, 89, 106, 134, 97, 78, 166, 199, 149, 153, 166, 166, 85, 108, 90, 142, 114, 37, 99, 172, 82, 185, 16, 105, 131, 153, 211, 81, 108, 26, 179, 131, 106, 255, 80, 88, 183, 40, 151, 19, 226, 186, 148, 91, 137, 180, 234, 186, 49, 205, 120, 228, 74, 0, 54, 66, 0, 98, 65, 198, 71, 70, 55, 234, 109, 80, 180, 102, 143, 85, 12, 200, 153, 145, 213, 236, 210, 64, 28, 36, 125, 58, 255, 116, 250, 50, 36, 224, 17, 43, 113, 173, 126, 20, 160, 119, 33, 104, 79, 204, 182, 27, 232, 0, 73, 19, 33, 2, 129, 129, 0, 182, 24, 115, 89, 44, 79, 146, 172, 162, 46, 95, 182, 190, 120, 93, 71, 113, 4, 146, 240, 215, 232, 197, 122, 132, 107, 184, 180, 48, 31, 216, 13, 88, 208, 100, 128, 167, 33, 26, 72, 0, 55, 214, 25, 113, 187, 145, 32, 157, 226, 195, 236, 219, 54, 28, 202, 72, 125, 3, 50, 116, 30, 101, 115, 2, 144, 115, 216, 63, 181, 82, 53, 121, 28, 238, 147, 163, 50, 139, 237, 137, 152, 241, 12, 216, 18, 242, 137, 127, 50, 35, 236, 103, 102, 82, 131, 137, 153, 94, 66, 43, 66, 75, 132, 80, 27, 62, 71, 109, 116, 251, 209, 166, 16, 32, 108, 110, 190, 68, 63, 185, 254, 188, 141, 218, 203, 234, 143});
    private final Transport transport_;
    private final Transport.ConnectionInfo connectionInfo_;
    private final PendingInterestTable pendingInterestTable_ = new PendingInterestTable();
    private final InterestFilterTable interestFilterTable_ = new InterestFilterTable();
    private final RegisteredPrefixTable registeredPrefixTable_ = new RegisteredPrefixTable(this.interestFilterTable_);
    private final DelayedCallTable delayedCallTable_ = new DelayedCallTable();
    private final List onConnectedCallbacks_ = Collections.synchronizedList(new ArrayList());
    private final Interest ndndIdFetcherInterest_;
    private Blob ndndId_ = new Blob();
    private final CommandInterestGenerator commandInterestGenerator_ = new CommandInterestGenerator();
    private final Name timeoutPrefix_ = new Name("/local/timeout");
    private long lastEntryId_;
    private final Object lastEntryIdLock_ = new Object();
    private ConnectStatus connectStatus_ = ConnectStatus.UNCONNECTED;
    private static final Logger logger_ = Logger.getLogger(Node.class.getName());

    public Node(Transport transport, Transport.ConnectionInfo connectionInfo) {
        this.transport_ = transport;
        this.connectionInfo_ = connectionInfo;
        this.ndndIdFetcherInterest_ = new Interest(new Name("/%C1.M.S.localhost/%C1.M.SRV/ndnd/KEY"), 4000.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void expressInterest(final long pendingInterestId, Interest interest, final OnData onData, final OnTimeout onTimeout, final WireFormat wireFormat, final Face face) throws IOException {
        final Interest interestCopy = new Interest(interest);
        if (this.connectStatus_ == ConnectStatus.CONNECT_COMPLETE) {
            this.expressInterestHelper(pendingInterestId, interestCopy, onData, onTimeout, wireFormat, face);
            return;
        }
        List list = this.onConnectedCallbacks_;
        synchronized (list) {
            if (!this.transport_.isAsync()) {
                this.transport_.connect(this.connectionInfo_, this, null);
                this.expressInterestHelper(pendingInterestId, interestCopy, onData, onTimeout, wireFormat, face);
                this.connectStatus_ = ConnectStatus.CONNECT_COMPLETE;
                return;
            }
            if (this.connectStatus_ == ConnectStatus.UNCONNECTED) {
                this.connectStatus_ = ConnectStatus.CONNECT_REQUESTED;
                this.onConnectedCallbacks_.add(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Node.this.expressInterestHelper(pendingInterestId, interestCopy, onData, onTimeout, wireFormat, face);
                        }
                        catch (IOException ex) {
                            logger_.log(Level.SEVERE, null, ex);
                        }
                    }
                });
                Runnable onConnected = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List list = Node.this.onConnectedCallbacks_;
                        synchronized (list) {
                            for (int i = 0; i < Node.this.onConnectedCallbacks_.size(); ++i) {
                                ((Runnable)Node.this.onConnectedCallbacks_.get(i)).run();
                            }
                            Node.this.onConnectedCallbacks_.clear();
                            Node.this.connectStatus_ = ConnectStatus.CONNECT_COMPLETE;
                        }
                    }
                };
                this.transport_.connect(this.connectionInfo_, this, onConnected);
            } else if (this.connectStatus_ == ConnectStatus.CONNECT_REQUESTED) {
                this.onConnectedCallbacks_.add(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Node.this.expressInterestHelper(pendingInterestId, interestCopy, onData, onTimeout, wireFormat, face);
                        }
                        catch (IOException ex) {
                            logger_.log(Level.SEVERE, null, ex);
                        }
                    }
                });
            } else if (this.connectStatus_ == ConnectStatus.CONNECT_COMPLETE) {
                this.expressInterestHelper(pendingInterestId, interestCopy, onData, onTimeout, wireFormat, face);
            } else {
                throw new Error("Node: Unrecognized _connectStatus " + (Object)((Object)this.connectStatus_));
            }
        }
    }

    public final void removePendingInterest(long pendingInterestId) {
        this.pendingInterestTable_.removePendingInterest(pendingInterestId);
    }

    void makeCommandInterest(Interest interest, KeyChain keyChain, Name certificateName, WireFormat wireFormat) throws SecurityException {
        this.commandInterestGenerator_.generate(interest, keyChain, certificateName, wireFormat);
    }

    public final void registerPrefix(long registeredPrefixId, Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, ForwardingFlags flags, WireFormat wireFormat, KeyChain commandKeyChain, Name commandCertificateName, Face face) throws IOException, SecurityException {
        if (this.ndndId_.size() != 0 || commandKeyChain == null) {
            if (!WireFormat.ENABLE_NDNX) {
                throw new Error("registerPrefix with NDNx is deprecated. To enable while you upgrade your code to use NFD, set WireFormat.ENABLE_NDNX = true");
            }
            if (this.ndndId_.size() == 0) {
                NdndIdFetcher fetcher = new NdndIdFetcher(new NdndIdFetcher.Info(this, registeredPrefixId, prefix, onInterest, onRegisterFailed, onRegisterSuccess, flags, wireFormat, face));
                this.expressInterest(this.getNextEntryId(), this.ndndIdFetcherInterest_, fetcher, fetcher, wireFormat, face);
            } else {
                this.registerPrefixHelper(registeredPrefixId, new Name(prefix), onInterest, onRegisterFailed, onRegisterSuccess, flags, wireFormat, face);
            }
        } else {
            this.nfdRegisterPrefix(registeredPrefixId, new Name(prefix), onInterest, onRegisterFailed, onRegisterSuccess, flags, commandKeyChain, commandCertificateName, wireFormat, face);
        }
    }

    public final void removeRegisteredPrefix(long registeredPrefixId) {
        this.registeredPrefixTable_.removeRegisteredPrefix(registeredPrefixId);
    }

    public final void setInterestFilter(long interestFilterId, InterestFilter filter, OnInterestCallback onInterest, Face face) {
        this.interestFilterTable_.setInterestFilter(interestFilterId, new InterestFilter(filter), onInterest, face);
    }

    public final void unsetInterestFilter(long interestFilterId) {
        this.interestFilterTable_.unsetInterestFilter(interestFilterId);
    }

    public final void putData(Data data, WireFormat wireFormat) throws IOException {
        SignedBlob encoding = data.wireEncode(wireFormat);
        if (encoding.size() > Node.getMaxNdnPacketSize()) {
            throw new Error("The encoded Data packet size exceeds the maximum limit getMaxNdnPacketSize()");
        }
        this.transport_.send(encoding.buf());
    }

    public final void send(ByteBuffer encoding) throws IOException {
        if (encoding.remaining() > Node.getMaxNdnPacketSize()) {
            throw new Error("The encoded packet size exceeds the maximum limit getMaxNdnPacketSize()");
        }
        this.transport_.send(encoding);
    }

    public final void processEvents() throws IOException, EncodingException {
        this.transport_.processEvents();
        this.delayedCallTable_.callTimedOut();
    }

    public final Transport getTransport() {
        return this.transport_;
    }

    public final Transport.ConnectionInfo getConnectionInfo() {
        return this.connectionInfo_;
    }

    @Override
    public final void onReceivedElement(ByteBuffer element) throws EncodingException {
        block14: {
            Data data;
            block13: {
                Object decoder;
                LocalControlHeader localControlHeader = null;
                if (element.get(0) == 80) {
                    localControlHeader = new LocalControlHeader();
                    localControlHeader.wireDecode(element, (WireFormat)TlvWireFormat.get());
                    element = localControlHeader.getPayloadWireEncoding().buf();
                }
                Interest interest = null;
                data = null;
                if (element.get(0) == 5 || element.get(0) == 6) {
                    decoder = new TlvDecoder(element);
                    if (((TlvDecoder)decoder).peekType(5, element.remaining())) {
                        interest = new Interest();
                        interest.wireDecode(element, (WireFormat)TlvWireFormat.get());
                        if (localControlHeader != null) {
                            interest.setLocalControlHeader(localControlHeader);
                        }
                    } else if (((TlvDecoder)decoder).peekType(6, element.remaining())) {
                        data = new Data();
                        data.wireDecode(element, (WireFormat)TlvWireFormat.get());
                        if (localControlHeader != null) {
                            data.setLocalControlHeader(localControlHeader);
                        }
                    }
                } else {
                    decoder = new BinaryXmlDecoder(element);
                    if (((BinaryXmlDecoder)decoder).peekDTag(26)) {
                        interest = new Interest();
                        interest.wireDecode(element, (WireFormat)BinaryXmlWireFormat.get());
                    } else if (((BinaryXmlDecoder)decoder).peekDTag(64)) {
                        data = new Data();
                        data.wireDecode(element, (WireFormat)BinaryXmlWireFormat.get());
                    }
                }
                if (interest == null) break block13;
                ArrayList matchedFilters = new ArrayList();
                this.interestFilterTable_.getMatchedFilters(interest, matchedFilters);
                for (int i = 0; i < matchedFilters.size(); ++i) {
                    InterestFilterTable.Entry entry = (InterestFilterTable.Entry)matchedFilters.get(i);
                    entry.getOnInterest().onInterest(entry.getFilter().getPrefix(), interest, entry.getFace(), entry.getInterestFilterId(), entry.getFilter());
                }
                break block14;
            }
            if (data == null) break block14;
            ArrayList pitEntries = new ArrayList();
            this.pendingInterestTable_.extractEntriesForExpressedInterest(data.getName(), pitEntries);
            for (int i = 0; i < pitEntries.size(); ++i) {
                PendingInterestTable.Entry pendingInterest = (PendingInterestTable.Entry)pitEntries.get(i);
                pendingInterest.getOnData().onData(pendingInterest.getInterest(), data);
            }
        }
    }

    public final boolean isLocal() throws IOException {
        return this.transport_.isLocal(this.connectionInfo_);
    }

    public final void shutdown() {
        try {
            this.transport_.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int getMaxNdnPacketSize() {
        return 8800;
    }

    public final void callLater(double delayMilliseconds, Runnable callback) {
        this.delayedCallTable_.callLater(delayMilliseconds, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextEntryId() {
        Object object = this.lastEntryIdLock_;
        synchronized (object) {
            return ++this.lastEntryId_;
        }
    }

    private void processInterestTimeout(PendingInterestTable.Entry pendingInterest) {
        if (this.pendingInterestTable_.removeEntry(pendingInterest)) {
            pendingInterest.callTimeout();
        }
    }

    private void expressInterestHelper(long pendingInterestId, Interest interestCopy, OnData onData, OnTimeout onTimeout, WireFormat wireFormat, Face face) throws IOException {
        final PendingInterestTable.Entry pendingInterest = this.pendingInterestTable_.add(pendingInterestId, interestCopy, onData, onTimeout);
        if (interestCopy.getInterestLifetimeMilliseconds() >= 0.0) {
            face.callLater(interestCopy.getInterestLifetimeMilliseconds(), new Runnable(){

                @Override
                public void run() {
                    Node.this.processInterestTimeout(pendingInterest);
                }
            });
        }
        if (!this.timeoutPrefix_.match(interestCopy.getName())) {
            SignedBlob encoding = interestCopy.wireEncode(wireFormat);
            if (encoding.size() > Node.getMaxNdnPacketSize()) {
                throw new Error("The encoded interest size exceeds the maximum limit getMaxNdnPacketSize()");
            }
            this.transport_.send(encoding.buf());
        }
    }

    private static ByteBuffer toBuffer(int[] array) {
        ByteBuffer result = ByteBuffer.allocate(array.length);
        for (int i = 0; i < array.length; ++i) {
            result.put((byte)(array[i] & 0xFF));
        }
        result.flip();
        return result;
    }

    private static void selfregSign(Data data, WireFormat wireFormat) {
        PrivateKey privateKey;
        data.setSignature(new Sha256WithRsaSignature());
        Sha256WithRsaSignature signature = (Sha256WithRsaSignature)data.getSignature();
        signature.getPublisherPublicKeyDigest().setPublisherPublicKeyDigest(new Blob(Common.digestSha256(SELFREG_PUBLIC_KEY_DER)));
        signature.getKeyLocator().setType(KeyLocatorType.KEY);
        signature.getKeyLocator().setKeyData(new Blob(SELFREG_PUBLIC_KEY_DER, false));
        KeyFactory keyFactory = null;
        try {
            keyFactory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new Error("KeyFactory: RSA is not supported: " + ex.getMessage());
        }
        try {
            privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(SELFREG_PRIVATE_KEY_DER.array()));
        }
        catch (InvalidKeySpecException ex) {
            throw new Error("KeyFactory: PKCS8EncodedKeySpec is not supported: " + ex.getMessage());
        }
        SignedBlob encoding = data.wireEncode(wireFormat);
        Signature securitySignature = null;
        try {
            securitySignature = Signature.getInstance("SHA256withRSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("SHA256withRSA algorithm is not supported");
        }
        try {
            securitySignature.initSign(privateKey);
        }
        catch (InvalidKeyException ex) {
            throw new Error("InvalidKeyException: " + ex.getMessage());
        }
        try {
            securitySignature.update(encoding.signedBuf());
            signature.setSignature(new Blob(securitySignature.sign()));
        }
        catch (SignatureException ex) {
            throw new Error("SignatureException: " + ex.getMessage());
        }
    }

    private void registerPrefixHelper(long registeredPrefixId, Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, ForwardingFlags flags, WireFormat wireFormat, Face face) {
        if (!WireFormat.ENABLE_NDNX) {
            throw new Error("registerPrefix with NDNx is deprecated. To enable while you upgrade your code to use NFD, set WireFormat.ENABLE_NDNX = true");
        }
        ForwardingEntry forwardingEntry = new ForwardingEntry();
        forwardingEntry.setAction("selfreg");
        forwardingEntry.setPrefix(prefix);
        forwardingEntry.setForwardingFlags(flags);
        Blob content = forwardingEntry.wireEncode(BinaryXmlWireFormat.get());
        Data data = new Data();
        data.setContent(content);
        data.getMetaInfo().setTimestampMilliseconds(Common.getNowMilliseconds());
        Node.selfregSign(data, BinaryXmlWireFormat.get());
        SignedBlob encodedData = data.wireEncode(BinaryXmlWireFormat.get());
        Name interestName = new Name().append("ndnx").append(this.ndndId_).append("selfreg").append(encodedData);
        Interest interest = new Interest(interestName);
        interest.setInterestLifetimeMilliseconds(4000.0);
        interest.setScope(1);
        if (registeredPrefixId != 0L) {
            long interestFilterId = 0L;
            if (onInterest != null) {
                interestFilterId = this.getNextEntryId();
                this.setInterestFilter(interestFilterId, new InterestFilter(prefix), onInterest, face);
            }
            this.registeredPrefixTable_.add(registeredPrefixId, prefix, interestFilterId);
        }
        RegisterResponse response = new RegisterResponse(new RegisterResponse.Info(this, prefix, onInterest, onRegisterFailed, onRegisterSuccess, flags, wireFormat, false, face, registeredPrefixId));
        try {
            this.expressInterest(this.getNextEntryId(), interest, response, response, wireFormat, face);
        }
        catch (IOException ex) {
            logger_.log(Level.INFO, "Register prefix failed: Error sending the register prefix interest to the forwarder: {0}", ex);
            onRegisterFailed.onRegisterFailed(prefix);
        }
    }

    private void nfdRegisterPrefix(long registeredPrefixId, Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, ForwardingFlags flags, KeyChain commandKeyChain, Name commandCertificateName, WireFormat wireFormat, Face face) throws SecurityException {
        boolean faceIsLocal;
        if (commandKeyChain == null) {
            throw new Error("registerPrefix: The command KeyChain has not been set. You must call setCommandSigningInfo.");
        }
        if (commandCertificateName.size() == 0) {
            throw new Error("registerPrefix: The command certificate name has not been set. You must call setCommandSigningInfo.");
        }
        ControlParameters controlParameters = new ControlParameters();
        controlParameters.setName(prefix);
        controlParameters.setForwardingFlags(flags);
        Interest commandInterest = new Interest();
        try {
            faceIsLocal = this.isLocal();
        }
        catch (IOException ex) {
            logger_.log(Level.INFO, "Register prefix failed: Error attempting to determine if the face is local: {0}", ex);
            onRegisterFailed.onRegisterFailed(prefix);
            return;
        }
        if (faceIsLocal) {
            commandInterest.setName(new Name("/localhost/nfd/rib/register"));
            commandInterest.setInterestLifetimeMilliseconds(2000.0);
        } else {
            commandInterest.setName(new Name("/localhop/nfd/rib/register"));
            commandInterest.setInterestLifetimeMilliseconds(4000.0);
        }
        commandInterest.getName().append(controlParameters.wireEncode(TlvWireFormat.get()));
        this.makeCommandInterest(commandInterest, commandKeyChain, commandCertificateName, TlvWireFormat.get());
        if (registeredPrefixId != 0L) {
            long interestFilterId = 0L;
            if (onInterest != null) {
                interestFilterId = this.getNextEntryId();
                this.setInterestFilter(interestFilterId, new InterestFilter(prefix), onInterest, face);
            }
            this.registeredPrefixTable_.add(registeredPrefixId, prefix, interestFilterId);
        }
        RegisterResponse response = new RegisterResponse(new RegisterResponse.Info(this, prefix, onInterest, onRegisterFailed, onRegisterSuccess, flags, wireFormat, true, face, registeredPrefixId));
        try {
            this.expressInterest(this.getNextEntryId(), commandInterest, response, response, wireFormat, face);
        }
        catch (IOException ex) {
            logger_.log(Level.INFO, "Register prefix failed: Error sending the register prefix interest to the forwarder: {0}", ex);
            onRegisterFailed.onRegisterFailed(prefix);
        }
    }

    private static class RegisterResponse
    implements OnData,
    OnTimeout {
        private final Info info_;

        public RegisterResponse(Info info) {
            this.info_ = info;
        }

        @Override
        public void onData(Interest interest, Data responseData) {
            if (this.info_.isNfdCommand_) {
                long statusCode;
                TlvDecoder decoder = new TlvDecoder(responseData.getContent().buf());
                try {
                    decoder.readNestedTlvsStart(101);
                    statusCode = decoder.readNonNegativeIntegerTlv(102);
                }
                catch (EncodingException ex) {
                    logger_.log(Level.INFO, "Register prefix failed: Error decoding the NFD response: {0}", ex);
                    this.info_.onRegisterFailed_.onRegisterFailed(this.info_.prefix_);
                    return;
                }
                if (statusCode != 200L) {
                    logger_.log(Level.INFO, "Register prefix failed: Expected NFD status code 200, got: {0}", statusCode);
                    this.info_.onRegisterFailed_.onRegisterFailed(this.info_.prefix_);
                    return;
                }
                logger_.log(Level.INFO, "Register prefix succeeded with the NFD forwarder for prefix {0}", this.info_.prefix_.toUri());
                if (this.info_.onRegisterSuccess_ != null) {
                    this.info_.onRegisterSuccess_.onRegisterSuccess(this.info_.prefix_, this.info_.registeredPrefixId_);
                }
            } else {
                Name expectedName = new Name("/ndnx/.../selfreg");
                if (responseData.getName().size() < 4 || !responseData.getName().get(0).equals(expectedName.get(0)) || !responseData.getName().get(2).equals(expectedName.get(2))) {
                    logger_.log(Level.INFO, "Register prefix failed: Unexpected name in NDNx response: {0}", responseData.getName().toUri());
                    this.info_.onRegisterFailed_.onRegisterFailed(this.info_.prefix_);
                    return;
                }
                logger_.log(Level.INFO, "Register prefix succeeded with the NDNx forwarder for prefix {0}", this.info_.prefix_.toUri());
                if (this.info_.onRegisterSuccess_ != null) {
                    this.info_.onRegisterSuccess_.onRegisterSuccess(this.info_.prefix_, this.info_.registeredPrefixId_);
                }
            }
        }

        @Override
        public void onTimeout(Interest timedOutInterest) {
            if (this.info_.isNfdCommand_) {
                logger_.log(Level.INFO, "Timeout for NFD register prefix command. Attempting an NDNx command...");
                if (this.info_.node_.ndndId_.size() == 0) {
                    NdndIdFetcher fetcher = new NdndIdFetcher(new NdndIdFetcher.Info(this.info_.node_, 0L, this.info_.prefix_, this.info_.onInterest_, this.info_.onRegisterFailed_, this.info_.onRegisterSuccess_, this.info_.flags_, this.info_.wireFormat_, this.info_.face_));
                    try {
                        this.info_.node_.expressInterest(this.info_.node_.getNextEntryId(), this.info_.node_.ndndIdFetcherInterest_, fetcher, fetcher, this.info_.wireFormat_, this.info_.face_);
                    }
                    catch (IOException ex) {
                        logger_.log(Level.INFO, "Register prefix failed: Error sending the register prefix interest to the forwarder: {0}", ex);
                        this.info_.onRegisterFailed_.onRegisterFailed(this.info_.prefix_);
                    }
                } else {
                    this.info_.node_.registerPrefixHelper(0L, new Name(this.info_.prefix_), this.info_.onInterest_, this.info_.onRegisterFailed_, this.info_.onRegisterSuccess_, this.info_.flags_, this.info_.wireFormat_, this.info_.face_);
                }
            } else {
                logger_.log(Level.INFO, "Register prefix failed: Timeout waiting for the response from the register prefix interest");
                this.info_.onRegisterFailed_.onRegisterFailed(this.info_.prefix_);
            }
        }

        public static class Info {
            public final Node node_;
            public final Name prefix_;
            public final OnInterestCallback onInterest_;
            public final OnRegisterFailed onRegisterFailed_;
            public final OnRegisterSuccess onRegisterSuccess_;
            public final ForwardingFlags flags_;
            public final WireFormat wireFormat_;
            public final boolean isNfdCommand_;
            public final Face face_;
            public final long registeredPrefixId_;

            public Info(Node node, Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, ForwardingFlags flags, WireFormat wireFormat, boolean isNfdCommand, Face face, long registeredPrefixId) {
                this.node_ = node;
                this.prefix_ = prefix;
                this.onInterest_ = onInterest;
                this.onRegisterFailed_ = onRegisterFailed;
                this.onRegisterSuccess_ = onRegisterSuccess;
                this.flags_ = flags;
                this.wireFormat_ = wireFormat;
                this.isNfdCommand_ = isNfdCommand;
                this.face_ = face;
                this.registeredPrefixId_ = registeredPrefixId;
            }
        }
    }

    private static class NdndIdFetcher
    implements OnData,
    OnTimeout {
        private Info info_;

        public NdndIdFetcher(Info info) {
            this.info_ = info;
        }

        @Override
        public void onData(Interest interest, Data ndndIdData) {
            if (ndndIdData.getContent().size() < 1 || ndndIdData.getContent().buf().get(0) != 48) {
                logger_.log(Level.INFO, "Register prefix failed: The content returned when fetching the NDNx ID does not appear to be a public key");
                this.info_.onRegisterFailed_.onRegisterFailed(this.info_.prefix_);
                return;
            }
            byte[] digest = Common.digestSha256(ndndIdData.getContent().buf());
            this.info_.node_.ndndId_ = new Blob(digest);
            this.info_.node_.registerPrefixHelper(this.info_.registeredPrefixId_, this.info_.prefix_, this.info_.onInterest_, this.info_.onRegisterFailed_, this.info_.onRegisterSuccess_, this.info_.flags_, this.info_.wireFormat_, this.info_.face_);
        }

        @Override
        public void onTimeout(Interest timedOutInterest) {
            logger_.log(Level.INFO, "Register prefix failed: Timeout fetching the NDNx ID");
            this.info_.onRegisterFailed_.onRegisterFailed(this.info_.prefix_);
        }

        private static class Info {
            public final Node node_;
            public final long registeredPrefixId_;
            public final Name prefix_;
            public final OnInterestCallback onInterest_;
            public final OnRegisterFailed onRegisterFailed_;
            public final OnRegisterSuccess onRegisterSuccess_;
            public final ForwardingFlags flags_;
            public final WireFormat wireFormat_;
            public final Face face_;

            public Info(Node node, long registeredPrefixId, Name prefix, OnInterestCallback onInterest, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, ForwardingFlags flags, WireFormat wireFormat, Face face) {
                this.node_ = node;
                this.registeredPrefixId_ = registeredPrefixId;
                this.prefix_ = new Name(prefix);
                this.onInterest_ = onInterest;
                this.onRegisterFailed_ = onRegisterFailed;
                this.onRegisterSuccess_ = onRegisterSuccess;
                this.flags_ = flags;
                this.wireFormat_ = wireFormat;
                this.face_ = face;
            }
        }
    }

    private static enum ConnectStatus {
        UNCONNECTED,
        CONNECT_REQUESTED,
        CONNECT_COMPLETE;

    }
}

