/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.nio.ByteBuffer;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.util.Blob;

public class LocalControlHeader {
    private long incomingFaceId_ = -1L;
    private long nextHopFaceId_ = -1L;
    private Blob payloadWireEncoding_ = new Blob();

    public LocalControlHeader() {
    }

    public LocalControlHeader(LocalControlHeader localControlHeader) {
        this.incomingFaceId_ = localControlHeader.incomingFaceId_;
        this.nextHopFaceId_ = localControlHeader.nextHopFaceId_;
        this.payloadWireEncoding_ = localControlHeader.payloadWireEncoding_;
    }

    public long getIncomingFaceId() {
        return this.incomingFaceId_;
    }

    public long getNextHopFaceId() {
        return this.nextHopFaceId_;
    }

    public Blob getPayloadWireEncoding() {
        return this.payloadWireEncoding_;
    }

    public void setIncomingFaceId(long incomingFaceId) {
        this.incomingFaceId_ = incomingFaceId;
    }

    public void setNextHopFaceId(long nextHopFaceId) {
        this.nextHopFaceId_ = nextHopFaceId;
    }

    public void setPayloadWireEncoding(Blob payloadWireEncoding) {
        this.payloadWireEncoding_ = payloadWireEncoding == null ? new Blob() : payloadWireEncoding;
    }

    public final Blob wireEncode(WireFormat wireFormat) {
        return wireFormat.encodeLocalControlHeader(this);
    }

    public final Blob wireEncode() {
        return this.wireEncode(WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(ByteBuffer input, WireFormat wireFormat) throws EncodingException {
        wireFormat.decodeLocalControlHeader(this, input);
    }

    public final void wireDecode(ByteBuffer input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        this.wireDecode(input.buf(), wireFormat);
    }

    public final void wireDecode(Blob input) throws EncodingException {
        this.wireDecode(input.buf());
    }
}

