/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.nio.ByteBuffer;
import net.named_data.jndn.Exclude;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.LocalControlHeader;
import net.named_data.jndn.Name;
import net.named_data.jndn.PublisherPublicKeyDigest;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.ChangeCountable;
import net.named_data.jndn.util.ChangeCounter;
import net.named_data.jndn.util.SignedBlob;

public class Interest
implements ChangeCountable {
    public static final int CHILD_SELECTOR_LEFT = 0;
    public static final int CHILD_SELECTOR_RIGHT = 1;
    public static final int ANSWER_NO_CONTENT_STORE = 0;
    public static final int ANSWER_CONTENT_STORE = 1;
    public static final int ANSWER_GENERATED = 2;
    public static final int ANSWER_STALE = 4;
    public static final int MARK_STALE = 16;
    public static final int DEFAULT_ANSWER_ORIGIN_KIND = 3;
    private final ChangeCounter name_ = new ChangeCounter(new Name());
    private int minSuffixComponents_ = -1;
    private int maxSuffixComponents_ = -1;
    private final ChangeCounter publisherPublicKeyDigest_ = new ChangeCounter(new PublisherPublicKeyDigest());
    private final ChangeCounter keyLocator_ = new ChangeCounter(new KeyLocator());
    private final ChangeCounter exclude_ = new ChangeCounter(new Exclude());
    private int childSelector_ = -1;
    private int answerOriginKind_ = -1;
    public int scope_ = -1;
    private double interestLifetimeMilliseconds_ = -1.0;
    private Blob nonce_ = new Blob();
    private long getNonceChangeCount_ = 0L;
    private LocalControlHeader localControlHeader_ = new LocalControlHeader();
    private SignedBlob defaultWireEncoding_ = new SignedBlob();
    private WireFormat defaultWireEncodingFormat_;
    private long getDefaultWireEncodingChangeCount_ = 0L;
    private long changeCount_ = 0L;

    public Interest(Name name, double interestLifetimeMilliseconds) {
        if (name != null) {
            this.name_.set(new Name(name));
        }
        this.interestLifetimeMilliseconds_ = interestLifetimeMilliseconds;
    }

    public Interest(Name name) {
        if (name != null) {
            this.name_.set(new Name(name));
        }
    }

    public Interest(Interest interest) {
        this.name_.set(new Name(interest.getName()));
        this.minSuffixComponents_ = interest.minSuffixComponents_;
        this.maxSuffixComponents_ = interest.maxSuffixComponents_;
        this.publisherPublicKeyDigest_.set(new PublisherPublicKeyDigest(interest.getPublisherPublicKeyDigest()));
        this.keyLocator_.set(new KeyLocator(interest.getKeyLocator()));
        this.exclude_.set(new Exclude(interest.getExclude()));
        this.childSelector_ = interest.childSelector_;
        this.answerOriginKind_ = interest.answerOriginKind_;
        this.interestLifetimeMilliseconds_ = interest.interestLifetimeMilliseconds_;
        this.scope_ = interest.scope_;
        this.nonce_ = interest.getNonce();
        this.setDefaultWireEncoding(interest.getDefaultWireEncoding(), interest.defaultWireEncodingFormat_);
    }

    public Interest() {
    }

    public final SignedBlob wireEncode(WireFormat wireFormat) {
        if (!this.getDefaultWireEncoding().isNull() && this.getDefaultWireEncodingFormat() == wireFormat) {
            return this.getDefaultWireEncoding();
        }
        int[] signedPortionBeginOffset = new int[1];
        int[] signedPortionEndOffset = new int[1];
        Blob encoding = wireFormat.encodeInterest(this, signedPortionBeginOffset, signedPortionEndOffset);
        SignedBlob wireEncoding = new SignedBlob(encoding, signedPortionBeginOffset[0], signedPortionEndOffset[0]);
        if (wireFormat == WireFormat.getDefaultWireFormat()) {
            this.setDefaultWireEncoding(wireEncoding, WireFormat.getDefaultWireFormat());
        }
        return wireEncoding;
    }

    public final SignedBlob wireEncode() {
        return this.wireEncode(WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(ByteBuffer input, WireFormat wireFormat) throws EncodingException {
        int[] signedPortionBeginOffset = new int[1];
        int[] signedPortionEndOffset = new int[1];
        wireFormat.decodeInterest(this, input, signedPortionBeginOffset, signedPortionEndOffset);
        if (wireFormat == WireFormat.getDefaultWireFormat()) {
            this.setDefaultWireEncoding(new SignedBlob(input, true, signedPortionBeginOffset[0], signedPortionEndOffset[0]), WireFormat.getDefaultWireFormat());
        } else {
            this.setDefaultWireEncoding(new SignedBlob(), null);
        }
    }

    public final void wireDecode(ByteBuffer input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        int[] signedPortionBeginOffset = new int[1];
        int[] signedPortionEndOffset = new int[1];
        wireFormat.decodeInterest(this, input.buf(), signedPortionBeginOffset, signedPortionEndOffset);
        if (wireFormat == WireFormat.getDefaultWireFormat()) {
            this.setDefaultWireEncoding(new SignedBlob(input, signedPortionBeginOffset[0], signedPortionEndOffset[0]), WireFormat.getDefaultWireFormat());
        } else {
            this.setDefaultWireEncoding(new SignedBlob(), null);
        }
    }

    public final void wireDecode(Blob input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final String toUri() {
        StringBuffer selectors = new StringBuffer();
        if (this.minSuffixComponents_ >= 0) {
            selectors.append("&ndn.MinSuffixComponents=").append(this.minSuffixComponents_);
        }
        if (this.maxSuffixComponents_ >= 0) {
            selectors.append("&ndn.MaxSuffixComponents=").append(this.maxSuffixComponents_);
        }
        if (this.childSelector_ >= 0) {
            selectors.append("&ndn.ChildSelector=").append(this.childSelector_);
        }
        if (this.answerOriginKind_ >= 0) {
            selectors.append("&ndn.AnswerOriginKind=").append(this.answerOriginKind_);
        }
        if (this.scope_ >= 0) {
            selectors.append("&ndn.Scope=").append(this.scope_);
        }
        if (this.interestLifetimeMilliseconds_ >= 0.0) {
            selectors.append("&ndn.InterestLifetime=").append(Math.round(this.interestLifetimeMilliseconds_));
        }
        if (this.getPublisherPublicKeyDigest().getPublisherPublicKeyDigest().size() > 0) {
            selectors.append("&ndn.PublisherPublicKeyDigest=");
            Name.toEscapedString(this.getPublisherPublicKeyDigest().getPublisherPublicKeyDigest().buf(), selectors);
        }
        if (this.nonce_.size() > 0) {
            selectors.append("&ndn.Nonce=");
            Name.toEscapedString(this.nonce_.buf(), selectors);
        }
        if (this.getExclude().size() > 0) {
            selectors.append("&ndn.Exclude=").append(this.getExclude().toUri());
        }
        StringBuffer result = new StringBuffer();
        result.append(this.getName().toUri());
        String selectorsString = selectors.toString();
        if (selectorsString.length() > 0) {
            result.append("?").append(selectorsString.substring(1));
        }
        return result.toString();
    }

    public final Name getName() {
        return (Name)this.name_.get();
    }

    public final int getMinSuffixComponents() {
        return this.minSuffixComponents_;
    }

    public final int getMaxSuffixComponents() {
        return this.maxSuffixComponents_;
    }

    public final PublisherPublicKeyDigest getPublisherPublicKeyDigest() {
        return (PublisherPublicKeyDigest)this.publisherPublicKeyDigest_.get();
    }

    public final KeyLocator getKeyLocator() {
        return (KeyLocator)this.keyLocator_.get();
    }

    public final Exclude getExclude() {
        return (Exclude)this.exclude_.get();
    }

    public final int getChildSelector() {
        return this.childSelector_;
    }

    public final int getAnswerOriginKind() {
        if (!WireFormat.ENABLE_NDNX) {
            throw new Error("getAnswerOriginKind is for NDNx and is deprecated. To enable while you upgrade your code to use NFD's getMustBeFresh(), set WireFormat.ENABLE_NDNX = true");
        }
        return this.answerOriginKind_;
    }

    public final boolean getMustBeFresh() {
        if (this.answerOriginKind_ < 0) {
            return true;
        }
        return (this.answerOriginKind_ & 4) == 0;
    }

    public final int getScope() {
        if (!WireFormat.ENABLE_NDNX) {
            throw new Error("getScope is for NDNx and is deprecated. To enable while you upgrade your code to not use Scope, set WireFormat.ENABLE_NDNX = true");
        }
        return this.scope_;
    }

    public final double getInterestLifetimeMilliseconds() {
        return this.interestLifetimeMilliseconds_;
    }

    public final Blob getNonce() {
        if (this.getNonceChangeCount_ != this.getChangeCount()) {
            this.nonce_ = new Blob();
            this.getNonceChangeCount_ = this.getChangeCount();
        }
        return this.nonce_;
    }

    public final long getIncomingFaceId() {
        return this.localControlHeader_.getIncomingFaceId();
    }

    public final long getNextHopFaceId() {
        return this.localControlHeader_.getNextHopFaceId();
    }

    public final Interest setName(Name name) {
        this.name_.set(name == null ? new Name() : new Name(name));
        ++this.changeCount_;
        return this;
    }

    public final Interest setMinSuffixComponents(int minSuffixComponents) {
        this.minSuffixComponents_ = minSuffixComponents;
        ++this.changeCount_;
        return this;
    }

    public final Interest setMaxSuffixComponents(int maxSuffixComponents) {
        this.maxSuffixComponents_ = maxSuffixComponents;
        ++this.changeCount_;
        return this;
    }

    public final Interest setChildSelector(int childSelector) {
        this.childSelector_ = childSelector;
        ++this.changeCount_;
        return this;
    }

    public final Interest setAnswerOriginKind(int answerOriginKind) {
        if (!WireFormat.ENABLE_NDNX) {
            throw new Error("setAnswerOriginKind is for NDNx and is deprecated. To enable while you upgrade your code to use NFD's setMustBeFresh(), set WireFormat.ENABLE_NDNX = true");
        }
        this.answerOriginKind_ = answerOriginKind;
        ++this.changeCount_;
        return this;
    }

    public final Interest setMustBeFresh(boolean mustBeFresh) {
        if (this.answerOriginKind_ < 0) {
            if (!mustBeFresh) {
                this.answerOriginKind_ = 4;
                ++this.changeCount_;
            }
        } else {
            this.answerOriginKind_ = mustBeFresh ? (this.answerOriginKind_ &= 0xFFFFFFFB) : (this.answerOriginKind_ |= 4);
            ++this.changeCount_;
        }
        return this;
    }

    public final Interest setScope(int scope) {
        if (!WireFormat.ENABLE_NDNX) {
            throw new Error("setScope is for NDNx and is deprecated. To enable while you upgrade your code to not use Scope, set WireFormat.ENABLE_NDNX = true");
        }
        this.scope_ = scope;
        ++this.changeCount_;
        return this;
    }

    public final Interest setInterestLifetimeMilliseconds(double interestLifetimeMilliseconds) {
        this.interestLifetimeMilliseconds_ = interestLifetimeMilliseconds;
        ++this.changeCount_;
        return this;
    }

    public final Interest setNonce(Blob nonce) {
        this.nonce_ = nonce == null ? new Blob() : nonce;
        ++this.changeCount_;
        this.getNonceChangeCount_ = this.getChangeCount();
        return this;
    }

    public final Interest setKeyLocator(KeyLocator keyLocator) {
        this.keyLocator_.set(keyLocator == null ? new KeyLocator() : new KeyLocator(keyLocator));
        ++this.changeCount_;
        return this;
    }

    public final Interest setExclude(Exclude exclude) {
        this.exclude_.set(exclude == null ? new Exclude() : new Exclude(exclude));
        ++this.changeCount_;
        return this;
    }

    final void setLocalControlHeader(LocalControlHeader localControlHeader) {
        this.localControlHeader_ = localControlHeader == null ? new LocalControlHeader() : new LocalControlHeader(localControlHeader);
    }

    public final boolean matchesName(Name name) {
        if (!this.getName().match(name)) {
            return false;
        }
        if (this.minSuffixComponents_ >= 0 && name.size() + 1 - this.getName().size() < this.minSuffixComponents_) {
            return false;
        }
        if (this.maxSuffixComponents_ >= 0 && name.size() + 1 - this.getName().size() > this.maxSuffixComponents_) {
            return false;
        }
        return this.getExclude().size() <= 0 || name.size() <= this.getName().size() || !this.getExclude().matches(name.get(this.getName().size()));
    }

    public final SignedBlob getDefaultWireEncoding() {
        if (this.getDefaultWireEncodingChangeCount_ != this.getChangeCount()) {
            this.defaultWireEncoding_ = new SignedBlob();
            this.defaultWireEncodingFormat_ = null;
            this.getDefaultWireEncodingChangeCount_ = this.getChangeCount();
        }
        return this.defaultWireEncoding_;
    }

    WireFormat getDefaultWireEncodingFormat() {
        return this.defaultWireEncodingFormat_;
    }

    @Override
    public final long getChangeCount() {
        boolean changed = this.name_.checkChanged();
        changed = this.publisherPublicKeyDigest_.checkChanged() || changed;
        changed = this.keyLocator_.checkChanged() || changed;
        boolean bl = changed = this.exclude_.checkChanged() || changed;
        if (changed) {
            ++this.changeCount_;
        }
        return this.changeCount_;
    }

    private void setDefaultWireEncoding(SignedBlob defaultWireEncoding, WireFormat defaultWireEncodingFormat) {
        this.defaultWireEncoding_ = defaultWireEncoding;
        this.defaultWireEncodingFormat_ = defaultWireEncodingFormat;
        this.getDefaultWireEncodingChangeCount_ = this.getChangeCount();
    }
}

