/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

public class ForwardingFlags {
    private static final int ForwardingEntryFlags_ACTIVE = 1;
    private static final int ForwardingEntryFlags_CHILD_INHERIT = 2;
    private static final int ForwardingEntryFlags_ADVERTISE = 4;
    private static final int ForwardingEntryFlags_LAST = 8;
    private static final int ForwardingEntryFlags_CAPTURE = 16;
    private static final int ForwardingEntryFlags_LOCAL = 32;
    private static final int ForwardingEntryFlags_TAP = 64;
    private static final int ForwardingEntryFlags_CAPTURE_OK = 128;
    private static final int NfdForwardingFlags_CHILD_INHERIT = 1;
    private static final int NfdForwardingFlags_CAPTURE = 2;
    private boolean active_ = true;
    private boolean childInherit_ = true;
    private boolean advertise_ = false;
    private boolean last_ = false;
    private boolean capture_ = false;
    private boolean local_ = false;
    private boolean tap_ = false;
    private boolean captureOk_ = false;

    public ForwardingFlags() {
    }

    public ForwardingFlags(ForwardingFlags forwardingFlags) {
        this.active_ = forwardingFlags.active_;
        this.childInherit_ = forwardingFlags.childInherit_;
        this.advertise_ = forwardingFlags.advertise_;
        this.last_ = forwardingFlags.last_;
        this.capture_ = forwardingFlags.capture_;
        this.local_ = forwardingFlags.local_;
        this.tap_ = forwardingFlags.tap_;
        this.captureOk_ = forwardingFlags.captureOk_;
    }

    public final boolean getActive() {
        return this.active_;
    }

    public final boolean getChildInherit() {
        return this.childInherit_;
    }

    public final boolean getAdvertise() {
        return this.advertise_;
    }

    public final boolean getLast() {
        return this.last_;
    }

    public final boolean getCapture() {
        return this.capture_;
    }

    public final boolean getLocal() {
        return this.local_;
    }

    public final boolean getTap() {
        return this.tap_;
    }

    public final boolean getCaptureOk() {
        return this.captureOk_;
    }

    public final void setActive(boolean active) {
        this.active_ = active;
    }

    public final void setChildInherit(boolean childInherit) {
        this.childInherit_ = childInherit;
    }

    public final void setAdvertise(boolean advertise) {
        this.advertise_ = advertise;
    }

    public final void setLast(boolean last) {
        this.last_ = last;
    }

    public final void setCapture(boolean capture) {
        this.capture_ = capture;
    }

    public final void setLocal(boolean local) {
        this.local_ = local;
    }

    public final void setTap(boolean tap) {
        this.tap_ = tap;
    }

    public final void setCaptureOk(boolean captureOk) {
        this.captureOk_ = captureOk;
    }

    public final int getForwardingEntryFlags() {
        int result = 0;
        if (this.active_) {
            result |= 1;
        }
        if (this.childInherit_) {
            result |= 2;
        }
        if (this.advertise_) {
            result |= 4;
        }
        if (this.last_) {
            result |= 8;
        }
        if (this.capture_) {
            result |= 0x10;
        }
        if (this.local_) {
            result |= 0x20;
        }
        if (this.tap_) {
            result |= 0x40;
        }
        if (this.captureOk_) {
            result |= 0x80;
        }
        return result;
    }

    public final void setForwardingEntryFlags(int forwardingEntryFlags) {
        this.active_ = (forwardingEntryFlags & 1) != 0;
        this.childInherit_ = (forwardingEntryFlags & 2) != 0;
        this.advertise_ = (forwardingEntryFlags & 4) != 0;
        this.last_ = (forwardingEntryFlags & 8) != 0;
        this.capture_ = (forwardingEntryFlags & 0x10) != 0;
        this.local_ = (forwardingEntryFlags & 0x20) != 0;
        this.tap_ = (forwardingEntryFlags & 0x40) != 0;
        this.captureOk_ = (forwardingEntryFlags & 0x80) != 0;
    }

    public final int getNfdForwardingFlags() {
        int result = 0;
        if (this.childInherit_) {
            result |= 1;
        }
        if (this.capture_) {
            result |= 2;
        }
        return result;
    }

    public final void setNfdForwardingFlags(int nfdForwardingFlags) {
        this.childInherit_ = (nfdForwardingFlags & 1) != 0;
        this.capture_ = (nfdForwardingFlags & 2) != 0;
    }
}

