/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn;

import java.nio.ByteBuffer;
import net.named_data.jndn.ForwardingFlags;
import net.named_data.jndn.Name;
import net.named_data.jndn.PublisherPublicKeyDigest;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.util.Blob;

public class ForwardingEntry {
    private String action_ = "";
    private Name prefix_ = new Name();
    private PublisherPublicKeyDigest publisherPublicKeyDigest_ = new PublisherPublicKeyDigest();
    private int faceId_ = -1;
    private ForwardingFlags forwardingFlags_ = new ForwardingFlags();
    private double freshnessPeriod_ = -1.0;

    public ForwardingEntry() {
        if (!WireFormat.ENABLE_NDNX) {
            throw new Error("ForwardingEntry is for NDNx and is deprecated. To enable while you upgrade your code to use NFD, set WireFormat.ENABLE_NDNX = true");
        }
    }

    public final String getAction() {
        return this.action_;
    }

    public final Name getPrefix() {
        return this.prefix_;
    }

    public final PublisherPublicKeyDigest getPublisherPublicKeyDigest() {
        return this.publisherPublicKeyDigest_;
    }

    public final int getFaceId() {
        return this.faceId_;
    }

    public final ForwardingFlags getForwardingFlags() {
        return this.forwardingFlags_;
    }

    public final double getFreshnessPeriod() {
        return this.freshnessPeriod_;
    }

    public final void setAction(String action) {
        this.action_ = action == null ? "" : action;
    }

    public final void setPrefix(Name prefix) {
        this.prefix_ = prefix == null ? new Name() : new Name(prefix);
    }

    public final void setFaceId(int faceId) {
        this.faceId_ = faceId;
    }

    public final void setForwardingFlags(ForwardingFlags forwardingFlags) {
        this.forwardingFlags_ = forwardingFlags == null ? new ForwardingFlags() : new ForwardingFlags(forwardingFlags);
    }

    public final void setFreshnessPeriod(double freshnessPeriod) {
        this.freshnessPeriod_ = freshnessPeriod;
    }

    public final Blob wireEncode(WireFormat wireFormat) {
        return wireFormat.encodeForwardingEntry(this);
    }

    public final Blob wireEncode() {
        return this.wireEncode(WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(ByteBuffer input, WireFormat wireFormat) throws EncodingException {
        wireFormat.decodeForwardingEntry(this, input);
    }

    public final void wireDecode(ByteBuffer input) throws EncodingException {
        this.wireDecode(input, WireFormat.getDefaultWireFormat());
    }

    public final void wireDecode(Blob input, WireFormat wireFormat) throws EncodingException {
        this.wireDecode(input.buf(), wireFormat);
    }

    public final void wireDecode(Blob input) throws EncodingException {
        this.wireDecode(input.buf());
    }
}

