/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.NetworkNack;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnNetworkNack;
import net.named_data.jndn.OnTimeout;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.OnDataValidationFailed;
import net.named_data.jndn.security.OnVerified;
import net.named_data.jndn.security.ValidatorConfigError;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.DataValidationFailureCallback;
import net.named_data.jndn.security.v2.DataValidationSuccessCallback;
import net.named_data.jndn.security.v2.ValidationError;
import net.named_data.jndn.security.v2.Validator;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.RttEstimator;

public class SegmentFetcher
implements OnData,
OnDataValidationFailed,
OnTimeout,
OnNetworkNack {
    public static final VerifySegment DontVerifySegment = new VerifySegment(){

        @Override
        public boolean verifySegment(Data data) {
            return true;
        }
    };
    private Runnable rtoTimeoutRunnable_ = new Runnable(){

        @Override
        public void run() {
            if (SegmentFetcher.this.shouldStop()) {
                return;
            }
            boolean hasTimeout = false;
            for (Map.Entry entry : SegmentFetcher.this.pendingSegments_.entrySet()) {
                long timeElapsed;
                PendingSegment ps = (PendingSegment)entry.getValue();
                if (ps.state == SegmentState.InRetxQueue || (timeElapsed = System.currentTimeMillis() - ps.sendTime) <= ps.rto) continue;
                hasTimeout = true;
                SegmentFetcher.this.enqueueForRetransmission((Long)entry.getKey());
            }
            if (hasTimeout) {
                if (!SegmentFetcher.this.checkMaxTimeout()) {
                    return;
                }
                SegmentFetcher.this.rttEstimator_.backoffRto();
                if (SegmentFetcher.this.receivedSegments_.size() == 0) {
                    SegmentFetcher.this.fetchFirstSegment(true);
                } else {
                    SegmentFetcher.this.windowDecrease();
                    SegmentFetcher.this.fetchSegmentsInWindow();
                }
            }
            SegmentFetcher.this.face_.callLater(((SegmentFetcher)SegmentFetcher.this).options_.rtoCheckInterval, SegmentFetcher.this.rtoTimeoutRunnable_);
        }
    };
    private double cwnd_ = 1.0;
    private final Options options_;
    private double ssThresh_;
    private final Face face_;
    private RttEstimator rttEstimator_;
    private long highData_ = 0L;
    private long recPoint_ = 0L;
    private long highInterest_ = 0L;
    private Interest baseInterest_;
    private int nSegmentsInFlight_ = 0;
    private long nSegments_ = -1L;
    private Map<Long, PendingSegment> pendingSegments_ = new HashMap<Long, PendingSegment>();
    private Map<Long, Blob> receivedSegments_ = new HashMap<Long, Blob>();
    private Queue<Long> retxQueue_ = new LinkedList<Long>();
    private long nextSegmentNum_ = 0L;
    private long timeLastSegmentReceived_ = 0L;
    private Name versionedDataName_;
    private boolean stop_ = false;
    private static final double MIN_SSTHRESH = 2.0;
    private final Validator validator_;
    private final KeyChain validatorKeyChain_;
    private final VerifySegment verifySegment_;
    private final OnComplete onComplete_;
    private final OnError onError_;
    private static final Logger logger_ = Logger.getLogger(SegmentFetcher.class.getName());

    public static void fetch(Face face, Interest baseInterest, Options options, VerifySegment verifySegment, OnComplete onComplete, OnError onError) {
        new SegmentFetcher(face, baseInterest, null, options, null, verifySegment, onComplete, onError).run();
    }

    public static void fetch(Face face, Interest baseInterest, VerifySegment verifySegment, OnComplete onComplete, OnError onError) {
        SegmentFetcher.fetch(face, baseInterest, new Options(), verifySegment, onComplete, onError);
    }

    public static void fetch(Face face, Interest baseInterest, Options options, KeyChain validatorKeyChain, OnComplete onComplete, OnError onError) {
        new SegmentFetcher(face, baseInterest, validatorKeyChain, options, null, DontVerifySegment, onComplete, onError).run();
    }

    public static void fetch(Face face, Interest baseInterest, KeyChain validatorKeyChain, OnComplete onComplete, OnError onError) {
        SegmentFetcher.fetch(face, baseInterest, new Options(), validatorKeyChain, onComplete, onError);
    }

    public static void fetch(Face face, Interest baseInterest, Options options, Validator validator, OnComplete onComplete, OnError onError) {
        new SegmentFetcher(face, baseInterest, null, options, validator, DontVerifySegment, onComplete, onError).run();
    }

    public static void fetch(Face face, Interest baseInterest, Validator validator, OnComplete onComplete, OnError onError) {
        new SegmentFetcher(face, baseInterest, null, new Options(), validator, DontVerifySegment, onComplete, onError).run();
    }

    private SegmentFetcher(Face face, Interest baseInterest, KeyChain validatorKeyChain, Options options, Validator validator, VerifySegment verifySegment, OnComplete onComplete, OnError onError) {
        this.options_ = options;
        this.face_ = face;
        this.validator_ = validator;
        this.validatorKeyChain_ = validatorKeyChain;
        this.verifySegment_ = verifySegment;
        this.onComplete_ = onComplete;
        this.onError_ = onError;
        this.rttEstimator_ = new RttEstimator(this.options_.rttOptions);
        this.cwnd_ = this.options_.initCwnd;
        this.ssThresh_ = this.options_.initSsthresh;
        this.timeLastSegmentReceived_ = System.currentTimeMillis();
        this.baseInterest_ = baseInterest;
    }

    private void run() {
        this.fetchFirstSegment(false);
        this.face_.callLater(this.options_.rtoCheckInterval, this.rtoTimeoutRunnable_);
    }

    private void fetchFirstSegment(boolean isRetransmission) {
        Interest interest = new Interest(this.baseInterest_);
        interest.setCanBePrefix(true);
        interest.setMustBeFresh(true);
        interest.setInterestLifetimeMilliseconds(this.options_.interestLifetime);
        if (isRetransmission) {
            interest.refreshNonce();
        }
        try {
            this.sendInterest(0L, interest, isRetransmission);
        }
        catch (IOException ex) {
            try {
                this.onError_.onError(ErrorCode.IO_ERROR, "I/O error fetching the first segment " + ex);
            }
            catch (Throwable exception) {
                logger_.log(Level.SEVERE, "Error in onError", exception);
            }
        }
    }

    private void fetchSegmentsInWindow() {
        if (this.checkAllSegmentsReceived()) {
            this.finalizeFetch();
            return;
        }
        double availableWindowSize = this.cwnd_ - (double)this.nSegmentsInFlight_;
        HashMap<Long, Boolean> segmentsToRequest = new HashMap<Long, Boolean>();
        while (availableWindowSize > 0.0) {
            if (!this.retxQueue_.isEmpty()) {
                Long key = this.retxQueue_.element();
                this.retxQueue_.remove();
                segmentsToRequest.put(key, true);
            } else {
                if (this.nSegments_ != -1L && this.nextSegmentNum_ >= this.nSegments_) break;
                if (this.receivedSegments_.containsKey(this.nextSegmentNum_)) {
                    ++this.nextSegmentNum_;
                    continue;
                }
                segmentsToRequest.put(this.nextSegmentNum_++, false);
            }
            availableWindowSize -= 1.0;
        }
        for (Map.Entry segment : segmentsToRequest.entrySet()) {
            Interest interest = new Interest(this.baseInterest_);
            interest.setName(this.versionedDataName_.getPrefix(-1).appendSegment((Long)segment.getKey()));
            interest.setCanBePrefix(false);
            interest.setMustBeFresh(false);
            interest.setInterestLifetimeMilliseconds(this.options_.interestLifetime);
            interest.refreshNonce();
            try {
                this.sendInterest((Long)segment.getKey(), interest, (Boolean)segment.getValue());
            }
            catch (IOException ex) {
                try {
                    this.onError_.onError(ErrorCode.IO_ERROR, "I/O error fetching the next segment " + ex);
                }
                catch (Throwable exception) {
                    logger_.log(Level.SEVERE, "Error in onError", exception);
                }
            }
        }
    }

    private void sendInterest(long segmentNum, Interest interest, boolean isRetransmission) throws IOException {
        int timeout;
        int n = timeout = this.options_.useConstantInterestTimeout ? this.options_.maxTimeout : this.getEstimatedRto();
        if (isRetransmission) {
            PendingSegment pendingSegmentIt = this.pendingSegments_.get(segmentNum);
            if (pendingSegmentIt == null) {
                return;
            }
            pendingSegmentIt.state = SegmentState.Retransmitted;
            pendingSegmentIt.sendTime = System.currentTimeMillis();
            pendingSegmentIt.rto = timeout;
        } else {
            this.pendingSegments_.put(segmentNum, new PendingSegment(SegmentState.FirstInterest, System.currentTimeMillis(), timeout));
            this.highInterest_ = segmentNum;
        }
        this.face_.expressInterest(interest, (OnData)this, (OnTimeout)this, (OnNetworkNack)this);
        ++this.nSegmentsInFlight_;
    }

    private int getEstimatedRto() {
        return Math.min(this.options_.maxTimeout, (int)this.rttEstimator_.getEstimatedRto());
    }

    private Long findFirstEntry() {
        Map.Entry o = (Map.Entry)this.pendingSegments_.entrySet().toArray()[0];
        return (Long)o.getKey();
    }

    private boolean checkAllSegmentsReceived() {
        boolean haveReceivedAllSegments = false;
        if (this.nSegments_ != -1L && (long)this.receivedSegments_.size() >= this.nSegments_) {
            haveReceivedAllSegments = true;
            for (long i = 0L; i < this.nSegments_; ++i) {
                if (this.receivedSegments_.containsKey(i)) continue;
                this.retxQueue_.offer(i);
                return false;
            }
        }
        return haveReceivedAllSegments;
    }

    private void finalizeFetch() {
        int totalSize = 0;
        for (long i = 0L; i < this.nSegments_; ++i) {
            totalSize += this.receivedSegments_.get(i).size();
        }
        ByteBuffer content = ByteBuffer.allocate(totalSize);
        for (long i = 0L; i < this.nSegments_; ++i) {
            if (this.receivedSegments_.get(i).size() == 0) continue;
            content.put(this.receivedSegments_.get(i).buf());
        }
        content.flip();
        this.stop();
        this.clean();
        try {
            this.onComplete_.onComplete(new Blob(content, false));
        }
        catch (Throwable ex) {
            logger_.log(Level.SEVERE, "Error in onComplete", ex);
        }
    }

    @Override
    public void onData(final Interest originalInterest, Data data) {
        long pendingSegmentIt;
        long segmentNum;
        if (this.shouldStop()) {
            return;
        }
        --this.nSegmentsInFlight_;
        Name.Component currentSegmentComponent = data.getName().get(-1);
        if (!currentSegmentComponent.isSegment()) {
            this.onError_.onError(ErrorCode.DATA_HAS_NO_SEGMENT, "Data Name has no segment number");
            return;
        }
        try {
            segmentNum = currentSegmentComponent.toSegment();
        }
        catch (EncodingException e) {
            this.onError_.onError(ErrorCode.DATA_HAS_NO_SEGMENT, "Error decoding the name segment number " + data.getName().get(-1).toEscapedString() + ": " + e);
            e.printStackTrace();
            return;
        }
        if (this.receivedSegments_.size() > 0) {
            if (this.receivedSegments_.containsKey(segmentNum) || !this.pendingSegments_.containsKey(segmentNum)) {
                return;
            }
            pendingSegmentIt = segmentNum;
        } else {
            pendingSegmentIt = this.findFirstEntry();
        }
        if (this.validatorKeyChain_ != null) {
            try {
                final SegmentFetcher thisSegmentFetcher = this;
                this.validatorKeyChain_.verifyData(data, new OnVerified(){

                    @Override
                    public void onVerified(Data localData) {
                        thisSegmentFetcher.onVerified(localData, originalInterest, pendingSegmentIt);
                    }
                }, this);
            }
            catch (Throwable ex) {
                this.onDataValidationFailed(data, "Error in KeyChain.verifyData " + ex.getMessage());
            }
        } else if (this.validator_ != null) {
            try {
                this.validator_.validate(data, new DataValidationSuccessCallback(){

                    @Override
                    public void successCallback(Data data) {
                        SegmentFetcher.this.onVerified(data, originalInterest, pendingSegmentIt);
                    }
                }, new DataValidationFailureCallback(){

                    @Override
                    public void failureCallback(Data data, ValidationError error) {
                        SegmentFetcher.this.onDataValidationFailed(data, error.toString());
                    }
                });
            }
            catch (ValidatorConfigError | CertificateV2.Error error) {
                this.onDataValidationFailed(data, "Error in KeyChain.verifyData " + error.getMessage());
            }
        } else {
            boolean verified = false;
            try {
                verified = this.verifySegment_.verifySegment(data);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in verifySegment", ex);
            }
            if (!verified) {
                this.onDataValidationFailed(data, "User verification failed");
                return;
            }
            this.onVerified(data, originalInterest, pendingSegmentIt);
        }
    }

    private void onVerified(Data data, Interest originalInterest, long pendingSegmentIt) {
        if (this.shouldStop()) {
            return;
        }
        if (!SegmentFetcher.endsWithSegmentNumber(data.getName())) {
            try {
                this.onError_.onError(ErrorCode.DATA_HAS_NO_SEGMENT, "Got an unexpected packet without a segment number: " + data.getName().toUri());
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onError", ex);
            }
        } else {
            long segmentNum;
            try {
                segmentNum = data.getName().get(-1).toSegment();
            }
            catch (EncodingException ex) {
                try {
                    this.onError_.onError(ErrorCode.DATA_HAS_NO_SEGMENT, "Error decoding the name segment number " + data.getName().get(-1).toEscapedString() + ": " + ex);
                }
                catch (Throwable exception) {
                    logger_.log(Level.SEVERE, "Error in onError", exception);
                }
                return;
            }
            this.timeLastSegmentReceived_ = System.currentTimeMillis();
            if (this.pendingSegments_.get((Object)Long.valueOf((long)pendingSegmentIt)).state == SegmentState.FirstInterest) {
                this.rttEstimator_.addMeasurement(this.timeLastSegmentReceived_ - this.pendingSegments_.get((Object)Long.valueOf((long)pendingSegmentIt)).sendTime, Math.max(this.nSegmentsInFlight_ + 1, 1));
            }
            this.pendingSegments_.remove(pendingSegmentIt);
            this.receivedSegments_.put(segmentNum, data.getContent());
            if (this.receivedSegments_.size() == 1) {
                this.versionedDataName_ = data.getName();
                if (segmentNum == 0L) {
                    ++this.nextSegmentNum_;
                }
            }
            if (data.getMetaInfo().getFinalBlockId().getValue().size() > 0) {
                try {
                    this.nSegments_ = data.getMetaInfo().getFinalBlockId().toSegment() + 1L;
                }
                catch (EncodingException ex) {
                    try {
                        this.onError_.onError(ErrorCode.DATA_HAS_NO_SEGMENT, "Error decoding the FinalBlockId segment number " + data.getMetaInfo().getFinalBlockId().toEscapedString() + ": " + ex);
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onError", exception);
                    }
                    return;
                }
            }
            if (this.highData_ < segmentNum) {
                this.highData_ = segmentNum;
            }
            if (data.getCongestionMark() > 0L && !this.options_.ignoreCongMarks) {
                this.windowDecrease();
            } else {
                this.windowIncrease();
            }
            this.fetchSegmentsInWindow();
        }
    }

    private void windowIncrease() {
        if (this.options_.useConstantCwnd || this.cwnd_ == (double)this.options_.maxWindowSize) {
            return;
        }
        this.cwnd_ = this.cwnd_ < this.ssThresh_ ? (this.cwnd_ += this.options_.aiStep) : (this.cwnd_ += this.options_.aiStep / this.cwnd_);
    }

    private void windowDecrease() {
        if (this.options_.disableCwa || this.highData_ > this.recPoint_) {
            this.recPoint_ = this.highInterest_;
            if (this.options_.useConstantCwnd) {
                return;
            }
            this.ssThresh_ = Math.max(2.0, this.cwnd_ * this.options_.mdCoef);
            this.cwnd_ = this.options_.resetCwndToInit ? this.options_.initCwnd : this.ssThresh_;
        }
    }

    @Override
    public void onDataValidationFailed(Data data, String reason) {
        if (this.shouldStop()) {
            return;
        }
        try {
            this.onError_.onError(ErrorCode.SEGMENT_VERIFICATION_FAILED, "Segment verification failed for " + data.getName().toUri() + " . Reason: " + reason);
        }
        catch (Throwable ex) {
            logger_.log(Level.SEVERE, "Error in onError", ex);
        }
    }

    @Override
    public void onNetworkNack(Interest interest, NetworkNack networkNack) {
        if (this.shouldStop()) {
            return;
        }
        switch (networkNack.getReason()) {
            case DUPLICATE: 
            case CONGESTION: {
                long segmentNum = this.getSegmentNumber(interest);
                if (segmentNum == -1L) {
                    return;
                }
                this.afterNackOrTimeout(segmentNum);
                break;
            }
            default: {
                try {
                    this.onError_.onError(ErrorCode.NACK_ERROR, "Nack Error");
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, "Error in onError", ex);
                }
                this.stop();
            }
        }
    }

    @Override
    public void onTimeout(Interest interest) {
        if (this.shouldStop()) {
            return;
        }
        long segmentNum = this.getSegmentNumber(interest);
        if (segmentNum == -1L) {
            return;
        }
        if (this.pendingSegments_.containsKey(segmentNum)) {
            try {
                this.onError_.onError(ErrorCode.INTEREST_TIMEOUT, "Lifetime expired for interest " + interest.getName().toUri());
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onError", ex);
            }
        }
        this.afterNackOrTimeout(segmentNum);
    }

    private boolean enqueueForRetransmission(Long segmentNumber) {
        if (this.pendingSegments_.containsKey(segmentNumber)) {
            PendingSegment pendingSegmentIt = this.pendingSegments_.get(segmentNumber);
            pendingSegmentIt.state = SegmentState.InRetxQueue;
            --this.nSegmentsInFlight_;
        } else {
            return false;
        }
        if (this.receivedSegments_.size() != 0) {
            this.retxQueue_.offer(segmentNumber);
        }
        return true;
    }

    private void afterNackOrTimeout(long segmentNum) {
        if (!this.checkMaxTimeout()) {
            return;
        }
        if (!this.enqueueForRetransmission(segmentNum)) {
            return;
        }
        this.rttEstimator_.backoffRto();
        if (this.receivedSegments_.size() == 0) {
            this.fetchFirstSegment(true);
        } else {
            this.windowDecrease();
            this.fetchSegmentsInWindow();
        }
    }

    private boolean checkMaxTimeout() {
        if (System.currentTimeMillis() >= this.timeLastSegmentReceived_ + (long)this.options_.maxTimeout) {
            try {
                this.onError_.onError(ErrorCode.INTEREST_TIMEOUT, "Timeout exceeded");
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onError", ex);
            }
            this.stop();
            return false;
        }
        return true;
    }

    private long getSegmentNumber(Interest interest) {
        Name.Component lastNameComponent = interest.getName().get(-1);
        if (lastNameComponent.isSegment()) {
            try {
                return lastNameComponent.toSegment();
            }
            catch (EncodingException e) {
                e.printStackTrace();
                return -1L;
            }
        }
        return 0L;
    }

    public boolean isStopped() {
        return this.stop_;
    }

    public void stop() {
        this.stop_ = true;
    }

    private boolean shouldStop() {
        if (this.stop_) {
            this.clean();
        }
        return this.stop_;
    }

    private void clean() {
        this.pendingSegments_.clear();
        this.receivedSegments_.clear();
    }

    private static boolean endsWithSegmentNumber(Name name) {
        return name.size() >= 1 && name.get(-1).isSegment();
    }

    public static interface OnError {
        public void onError(ErrorCode var1, String var2);
    }

    public static interface VerifySegment {
        public boolean verifySegment(Data var1);
    }

    public static interface OnComplete {
        public void onComplete(Blob var1);
    }

    public static enum ErrorCode {
        INTEREST_TIMEOUT,
        DATA_HAS_NO_SEGMENT,
        SEGMENT_VERIFICATION_FAILED,
        IO_ERROR,
        NACK_ERROR;

    }

    class PendingSegment {
        public SegmentState state;
        public long sendTime;
        public long rto;

        public PendingSegment(SegmentState state, long sendTime, long rto) {
            this.state = state;
            this.sendTime = sendTime;
            this.rto = rto;
        }
    }

    private static enum SegmentState {
        FirstInterest,
        InRetxQueue,
        Retransmitted;

    }

    public static class Options {
        public boolean useConstantCwnd = false;
        public int interestLifetime = 4000;
        public double initCwnd = 1.0;
        public int maxTimeout = 60000;
        public double initSsthresh = Double.MAX_VALUE;
        public double aiStep = 1.0;
        public double mdCoef = 0.5;
        public int rtoCheckInterval = 10;
        public boolean disableCwa = false;
        public boolean resetCwndToInit = false;
        public boolean ignoreCongMarks = false;
        public int maxWindowSize = Integer.MAX_VALUE;
        public boolean useConstantInterestTimeout = false;
        public RttEstimator.Options rttOptions = new RttEstimator.Options();
    }
}

