/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.sync.detail;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.Tlv0_2WireFormat;
import net.named_data.jndn.encoding.tlv.TlvDecoder;
import net.named_data.jndn.encoding.tlv.TlvEncoder;
import net.named_data.jndn.util.Blob;

public class PSyncState {
    public static final int Tlv_PSyncContent = 128;
    private ArrayList<Name> content_ = new ArrayList();

    public PSyncState() {
    }

    public PSyncState(ByteBuffer input) throws EncodingException {
        this.wireDecode(input);
    }

    public PSyncState(Blob input) throws EncodingException {
        this.wireDecode(input);
    }

    public final void addContent(Name name) {
        this.content_.add(new Name(name));
    }

    public final ArrayList<Name> getContent() {
        return this.content_;
    }

    public final void clear() {
        this.content_.clear();
    }

    public final Blob wireEncode() {
        TlvEncoder encoder = new TlvEncoder(256);
        int saveLength = encoder.getLength();
        for (int i = this.content_.size() - 1; i >= 0; --i) {
            Tlv0_2WireFormat.encodeName(this.content_.get(i), new int[1], new int[1], encoder);
        }
        encoder.writeTypeAndLength(128, encoder.getLength() - saveLength);
        return new Blob(encoder.getOutput(), false);
    }

    public final void wireDecode(ByteBuffer input) throws EncodingException {
        this.clear();
        TlvDecoder decoder = new TlvDecoder(input);
        int endOffset = decoder.readNestedTlvsStart(128);
        while (decoder.getOffset() < endOffset) {
            Name name = new Name();
            Tlv0_2WireFormat.decodeName(name, new int[1], new int[1], decoder, true);
            this.content_.add(name);
        }
        decoder.finishNestedTlvs(endOffset);
    }

    public final void wireDecode(Blob input) throws EncodingException {
        this.wireDecode(input.buf());
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        for (int i = 0; i < this.content_.size(); ++i) {
            result.append(this.content_.get(i).toUri());
            if (i >= this.content_.size() - 1) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }
}

