/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.sync.detail;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class InvertibleBloomLookupTable {
    public static final int N_HASH = 3;
    public static final int N_HASHCHECK = 11;
    private final ArrayList<HashTableEntry> hashTable_;
    private static final int INSERT = 1;
    private static final int ERASE = -1;

    public InvertibleBloomLookupTable(int expectedNEntries) {
        int nEntries = expectedNEntries + expectedNEntries / 2;
        int remainder = nEntries % 3;
        if (remainder != 0) {
            nEntries += 3 - remainder;
        }
        this.hashTable_ = new ArrayList(nEntries);
        for (int i = 0; i < nEntries; ++i) {
            this.hashTable_.add(new HashTableEntry());
        }
    }

    public InvertibleBloomLookupTable(InvertibleBloomLookupTable iblt) {
        this.hashTable_ = new ArrayList(iblt.hashTable_.size());
        for (int i = 0; i < iblt.hashTable_.size(); ++i) {
            this.hashTable_.add(new HashTableEntry(iblt.hashTable_.get(i)));
        }
    }

    public final void initialize(Blob encoding) throws IOException {
        long[] values = InvertibleBloomLookupTable.decode(encoding);
        if (3 * this.hashTable_.size() != values.length) {
            throw new AssertionError((Object)"The received Invertible Bloom Filter cannot be decoded");
        }
        for (int i = 0; i < this.hashTable_.size(); ++i) {
            HashTableEntry entry = this.hashTable_.get(i);
            if (values[i * 3] == 0L) continue;
            entry.count_ = (int)values[i * 3];
            entry.keySum_ = values[i * 3 + 1];
            entry.keyCheck_ = values[i * 3 + 2];
        }
    }

    public final void insert(long key) {
        this.update(1, key);
    }

    public final void erase(long key) {
        this.update(-1, key);
    }

    public final boolean listEntries(HashSet<Long> positive, HashSet<Long> negative) {
        positive.clear();
        negative.clear();
        InvertibleBloomLookupTable peeled = new InvertibleBloomLookupTable(this);
        int nErased = 0;
        do {
            nErased = 0;
            for (HashTableEntry entry : peeled.hashTable_) {
                if (!entry.isPure()) continue;
                if (entry.count_ == 1) {
                    positive.add(entry.keySum_);
                } else {
                    negative.add(entry.keySum_);
                }
                peeled.update(-entry.count_, entry.keySum_);
                ++nErased;
            }
        } while (nErased > 0);
        for (HashTableEntry entry : peeled.hashTable_) {
            if (entry.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public final InvertibleBloomLookupTable difference(InvertibleBloomLookupTable other) {
        if (this.hashTable_.size() != other.hashTable_.size()) {
            throw new Error("IBLT difference: Both tables must be the same size");
        }
        InvertibleBloomLookupTable result = new InvertibleBloomLookupTable(this);
        for (int i = 0; i < this.hashTable_.size(); ++i) {
            HashTableEntry e1 = result.hashTable_.get(i);
            HashTableEntry e2 = other.hashTable_.get(i);
            e1.count_ -= e2.count_;
            e1.keySum_ ^= e2.keySum_;
            e1.keyCheck_ ^= e2.keyCheck_;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Blob encode() throws IOException {
        int nEntries = this.hashTable_.size();
        int unitSize = 12;
        int tableSize = unitSize * nEntries;
        byte[] table = new byte[tableSize];
        for (int i = 0; i < nEntries; ++i) {
            HashTableEntry entry = this.hashTable_.get(i);
            table[i * unitSize] = (byte)(0xFF & entry.count_);
            table[i * unitSize + 1] = (byte)(0xFF & entry.count_ >> 8);
            table[i * unitSize + 2] = (byte)(0xFF & entry.count_ >> 16);
            table[i * unitSize + 3] = (byte)(0xFF & entry.count_ >> 24);
            table[i * unitSize + 4] = (byte)(0xFFL & entry.keySum_);
            table[i * unitSize + 5] = (byte)(0xFFL & entry.keySum_ >> 8);
            table[i * unitSize + 6] = (byte)(0xFFL & entry.keySum_ >> 16);
            table[i * unitSize + 7] = (byte)(0xFFL & entry.keySum_ >> 24);
            table[i * unitSize + 8] = (byte)(0xFFL & entry.keyCheck_);
            table[i * unitSize + 9] = (byte)(0xFFL & entry.keyCheck_ >> 8);
            table[i * unitSize + 10] = (byte)(0xFFL & entry.keyCheck_ >> 16);
            table[i * unitSize + 11] = (byte)(0xFFL & entry.keyCheck_ >> 24);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        int compressionLevel = 9;
        try (DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)outputStream, new Deflater(9));){
            deflaterStream.write(table);
            deflaterStream.flush();
        }
        return new Blob(outputStream.toByteArray(), false);
    }

    public final boolean equals(InvertibleBloomLookupTable other) {
        ArrayList<HashTableEntry> iblt1HashTable = this.hashTable_;
        ArrayList<HashTableEntry> iblt2HashTable = other.hashTable_;
        if (iblt1HashTable.size() != iblt2HashTable.size()) {
            return false;
        }
        for (int i = 0; i < iblt1HashTable.size(); ++i) {
            if (iblt1HashTable.get((int)i).count_ == iblt2HashTable.get((int)i).count_ && iblt1HashTable.get((int)i).keySum_ == iblt2HashTable.get((int)i).keySum_ && iblt1HashTable.get((int)i).keyCheck_ == iblt2HashTable.get((int)i).keyCheck_) continue;
            return false;
        }
        return true;
    }

    private void update(int plusOrMinus, long key) {
        int bucketsPerHash = this.hashTable_.size() / 3;
        for (int i = 0; i < 3; ++i) {
            int startEntry = i * bucketsPerHash;
            long h = Common.murmurHash3(i, key);
            HashTableEntry entry = this.hashTable_.get(startEntry + (int)(h % (long)bucketsPerHash));
            entry.count_ += plusOrMinus;
            entry.keySum_ ^= key;
            entry.keyCheck_ ^= Common.murmurHash3(11, key);
        }
    }

    private static long[] decode(Blob encoding) throws IOException {
        int count;
        InflaterInputStream inflaterStream = new InflaterInputStream(new ByteArrayInputStream(encoding.getImmutableArray()));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[encoding.size()];
        while ((count = inflaterStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, count);
        }
        byte[] ibltValues = outputStream.toByteArray();
        int nEntries = ibltValues.length / 4;
        long[] values = new long[nEntries];
        for (int i = 0; i < 4 * nEntries; i += 4) {
            long t;
            values[i / 4] = t = (((long)ibltValues[i + 3] & 0xFFL) << 24) + (((long)ibltValues[i + 2] & 0xFFL) << 16) + (((long)ibltValues[i + 1] & 0xFFL) << 8) + ((long)ibltValues[i] & 0xFFL);
        }
        return values;
    }

    private static class HashTableEntry {
        public int count_ = 0;
        public long keySum_ = 0L;
        public long keyCheck_ = 0L;

        public HashTableEntry() {
        }

        public HashTableEntry(HashTableEntry entry) {
            this.count_ = entry.count_;
            this.keySum_ = entry.keySum_;
            this.keyCheck_ = entry.keyCheck_;
        }

        public final boolean isPure() {
            if (this.count_ == 1 || this.count_ == -1) {
                long check = Common.murmurHash3(11, this.keySum_);
                return this.keyCheck_ == check;
            }
            return false;
        }

        public final boolean isEmpty() {
            return this.count_ == 0 && this.keySum_ == 0L && this.keyCheck_ == 0L;
        }
    }
}

