/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.sync;

import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Name;
import net.named_data.jndn.sync.detail.InvertibleBloomLookupTable;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class PSyncProducerBase {
    protected final InvertibleBloomLookupTable iblt_;
    protected final int expectedNEntries_;
    protected final int threshold_;
    protected final HashMap<Name, Object> nameToHash_ = new HashMap();
    protected final HashMap<Object, Name> hashToName_ = new HashMap();
    protected final Name syncPrefix_;
    protected final double syncReplyFreshnessPeriod_;
    private static final Logger logger_ = Logger.getLogger(PSyncProducerBase.class.getName());

    protected PSyncProducerBase(int expectedNEntries, Name syncPrefix, double syncReplyFreshnessPeriod) {
        this.iblt_ = new InvertibleBloomLookupTable(expectedNEntries);
        this.expectedNEntries_ = expectedNEntries;
        this.threshold_ = expectedNEntries / 2;
        this.syncPrefix_ = new Name(syncPrefix);
        this.syncReplyFreshnessPeriod_ = syncReplyFreshnessPeriod;
    }

    protected final void insertIntoIblt(Name name) {
        String uri = name.toUri();
        long newHash = Common.murmurHash3(11, new Blob(uri).getImmutableArray());
        this.nameToHash_.put(name, newHash);
        this.hashToName_.put(newHash, name);
        this.iblt_.insert(newHash);
    }

    protected final void removeFromIblt(Name name) {
        Object hash = this.nameToHash_.get(name);
        if (hash != null) {
            this.nameToHash_.remove(name);
            this.hashToName_.remove(hash);
            this.iblt_.erase((Long)hash);
        }
    }

    public static void onRegisterFailed(Name prefix) {
        logger_.log(Level.SEVERE, "PSyncProduerBase: Failed to register prefix: {0}", prefix);
    }
}

