/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2.validator_config;

import net.named_data.jndn.Name;
import net.named_data.jndn.security.ValidatorConfigError;

public class ConfigNameRelation {
    public static String toString(Relation relation) {
        if (relation == Relation.EQUAL) {
            return "equal";
        }
        if (relation == Relation.IS_PREFIX_OF) {
            return "is-prefix-of";
        }
        if (relation == Relation.IS_STRICT_PREFIX_OF) {
            return "is-strict-prefix-of";
        }
        return "";
    }

    public static boolean checkNameRelation(Relation relation, Name name1, Name name2) {
        if (relation == Relation.EQUAL) {
            return name1.equals(name2);
        }
        if (relation == Relation.IS_PREFIX_OF) {
            return name1.isPrefixOf(name2);
        }
        if (relation == Relation.IS_STRICT_PREFIX_OF) {
            return name1.isPrefixOf(name2) && name1.size() < name2.size();
        }
        return false;
    }

    public static Relation getNameRelationFromString(String relationString) throws ValidatorConfigError {
        if (relationString.equalsIgnoreCase("equal")) {
            return Relation.EQUAL;
        }
        if (relationString.equalsIgnoreCase("is-prefix-of")) {
            return Relation.IS_PREFIX_OF;
        }
        if (relationString.equalsIgnoreCase("is-strict-prefix-of")) {
            return Relation.IS_STRICT_PREFIX_OF;
        }
        throw new ValidatorConfigError("Unsupported relation: " + relationString);
    }

    public static enum Relation {
        EQUAL,
        IS_PREFIX_OF,
        IS_STRICT_PREFIX_OF;

    }
}

