/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.security.ValidatorConfigError;
import net.named_data.jndn.security.v2.CertificateRequest;
import net.named_data.jndn.security.v2.CertificateStorage;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.ValidationState;

public abstract class CertificateFetcher {
    protected CertificateStorage certificateStorage_ = null;
    private static final Logger logger_ = Logger.getLogger(CertificateFetcher.class.getName());

    public void setCertificateStorage(CertificateStorage certificateStorage) {
        this.certificateStorage_ = certificateStorage;
    }

    public final void fetch(CertificateRequest certificateRequest, ValidationState state, ValidationContinuation continueValidation) throws CertificateV2.Error, ValidatorConfigError {
        if (this.certificateStorage_ == null) {
            throw new Error("CertificateFetcher.fetch: You must first call setCertificateStorage");
        }
        CertificateV2 certificate = this.certificateStorage_.getUnverifiedCertificateCache().find(certificateRequest.interest_);
        if (certificate != null) {
            logger_.log(Level.FINE, "Found certificate in **un**verified key cache {0}", certificate.getName().toUri());
            continueValidation.continueValidation(certificate, state);
            return;
        }
        final ValidationContinuation outerContinueValidation = continueValidation;
        this.doFetch(certificateRequest, state, new ValidationContinuation(){

            @Override
            public void continueValidation(CertificateV2 certificate, ValidationState state) throws CertificateV2.Error, ValidatorConfigError {
                CertificateFetcher.this.certificateStorage_.cacheUnverifiedCertificate(certificate);
                outerContinueValidation.continueValidation(certificate, state);
            }
        });
    }

    protected abstract void doFetch(CertificateRequest var1, ValidationState var2, ValidationContinuation var3) throws CertificateV2.Error;

    public static interface ValidationContinuation {
        public void continueValidation(CertificateV2 var1, ValidationState var2) throws CertificateV2.Error, ValidatorConfigError;
    }
}

