/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.pib;

import java.util.HashMap;
import java.util.HashSet;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.pib.Pib;
import net.named_data.jndn.security.pib.PibIdentity;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.pib.detail.PibIdentityImpl;
import net.named_data.jndn.util.Common;

public class PibIdentityContainer {
    private HashSet<Name> identityNames_;
    private final HashMap<Name, PibIdentityImpl> identities_ = new HashMap();
    private final PibImpl pibImpl_;
    private static Common dummyCommon_ = new Common();

    public final int size() {
        return this.identityNames_.size();
    }

    public final PibIdentity add(Name identityName) throws PibImpl.Error, Pib.Error {
        if (!this.identityNames_.contains(identityName)) {
            Name identityNameCopy = new Name(identityName);
            this.identityNames_.add(identityNameCopy);
            this.identities_.put(identityNameCopy, new PibIdentityImpl(identityName, this.pibImpl_, true));
        }
        return this.get(identityName);
    }

    public final void remove(Name identityName) throws PibImpl.Error {
        this.identityNames_.remove(identityName);
        this.identities_.remove(identityName);
        this.pibImpl_.removeIdentity(identityName);
    }

    public final PibIdentity get(Name identityName) throws PibImpl.Error, Pib.Error {
        PibIdentityImpl pibIdentityImpl = this.identities_.get(identityName);
        if (pibIdentityImpl == null) {
            pibIdentityImpl = new PibIdentityImpl(identityName, this.pibImpl_, false);
            this.identities_.put(new Name(identityName), pibIdentityImpl);
        }
        return new PibIdentity(pibIdentityImpl);
    }

    void reset() throws PibImpl.Error {
        this.identities_.clear();
        this.identityNames_ = this.pibImpl_.getIdentities();
    }

    boolean isConsistent() throws PibImpl.Error {
        return this.identityNames_.equals(this.pibImpl_.getIdentities());
    }

    public PibIdentityContainer(PibImpl pibImpl) throws PibImpl.Error {
        this.pibImpl_ = pibImpl;
        if (pibImpl == null) {
            throw new AssertionError((Object)"The pibImpl is null");
        }
        this.identityNames_ = this.pibImpl_.getIdentities();
    }

    public final HashMap<Name, PibIdentityImpl> getIdentities_() {
        return this.identities_;
    }
}

