/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security;

import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.security.CommandInterestPreparer;
import net.named_data.jndn.security.KeyChain;
import net.named_data.jndn.security.SigningInfo;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.tpm.TpmBackEnd;

public class CommandInterestSigner
extends CommandInterestPreparer {
    public static final int POS_SIGNATURE_VALUE = -1;
    public static final int POS_SIGNATURE_INFO = -2;
    public static final int POS_NONCE = -3;
    public static final int POS_TIMESTAMP = -4;
    public static final int MINIMUM_SIZE = 4;
    private final KeyChain keyChain_;

    public CommandInterestSigner(KeyChain keyChain) {
        this.keyChain_ = keyChain;
    }

    public final Interest makeCommandInterest(Name name, SigningInfo params, WireFormat wireFormat) throws PibImpl.Error, KeyChain.Error, TpmBackEnd.Error {
        Interest commandInterest = new Interest(name);
        this.prepareCommandInterestName(commandInterest, wireFormat);
        this.keyChain_.sign(commandInterest, params, wireFormat);
        return commandInterest;
    }

    public final Interest makeCommandInterest(Name name, SigningInfo params) throws PibImpl.Error, KeyChain.Error, TpmBackEnd.Error {
        return this.makeCommandInterest(name, params, WireFormat.getDefaultWireFormat());
    }

    public final Interest makeCommandInterest(Name name) throws PibImpl.Error, KeyChain.Error, TpmBackEnd.Error {
        return this.makeCommandInterest(name, new SigningInfo(), WireFormat.getDefaultWireFormat());
    }
}

