/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security;

import java.nio.ByteBuffer;
import net.named_data.jndn.Interest;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.tlv.TlvEncoder;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class CommandInterestPreparer {
    private double lastUsedTimestamp_;
    private final Object lastUsedTimestampLock_ = new Object();
    private double nowOffsetMilliseconds_ = 0.0;

    public CommandInterestPreparer() {
        this.lastUsedTimestamp_ = Math.round(Common.getNowMilliseconds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareCommandInterestName(Interest interest, WireFormat wireFormat) {
        double timestamp;
        Object object = this.lastUsedTimestampLock_;
        synchronized (object) {
            double now = Common.getNowMilliseconds() + this.nowOffsetMilliseconds_;
            for (timestamp = (double)Math.round(now); timestamp <= this.lastUsedTimestamp_; timestamp += 1.0) {
            }
            this.lastUsedTimestamp_ = timestamp;
        }
        TlvEncoder encoder = new TlvEncoder(8);
        encoder.writeNonNegativeInteger((long)timestamp);
        interest.getName().append(new Blob(encoder.getOutput(), false));
        ByteBuffer randomBuffer = ByteBuffer.allocate(8);
        Common.getRandom().nextBytes(randomBuffer.array());
        interest.getName().append(new Blob(randomBuffer, false));
    }

    public void prepareCommandInterestName(Interest interest) {
        this.prepareCommandInterestName(interest, WireFormat.getDefaultWireFormat());
    }

    public final void setNowOffsetMilliseconds_(double nowOffsetMilliseconds) {
        this.nowOffsetMilliseconds_ = nowOffsetMilliseconds;
    }
}

