/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt.algo;

import java.nio.ByteBuffer;
import net.named_data.jndn.encrypt.algo.EncryptAlgorithmType;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class EncryptParams {
    private EncryptAlgorithmType algorithmType_;
    private Blob initialVector_;

    public EncryptParams(EncryptAlgorithmType algorithmType, int initialVectorLength) {
        this.algorithmType_ = algorithmType;
        if (initialVectorLength > 0) {
            ByteBuffer initialVector = ByteBuffer.allocate(initialVectorLength);
            Common.getRandom().nextBytes(initialVector.array());
            this.initialVector_ = new Blob(initialVector, false);
        } else {
            this.initialVector_ = new Blob();
        }
    }

    public EncryptParams(EncryptAlgorithmType algorithmType) {
        this.algorithmType_ = algorithmType;
        this.initialVector_ = new Blob();
    }

    public final EncryptAlgorithmType getAlgorithmType() {
        return this.algorithmType_;
    }

    public final Blob getInitialVector() {
        return this.initialVector_;
    }

    public final EncryptParams setAlgorithmType(EncryptAlgorithmType algorithmType) {
        this.algorithmType_ = algorithmType;
        return this;
    }

    public final EncryptParams setInitialVector(Blob initialVector) {
        this.initialVector_ = initialVector == null ? new Blob() : initialVector;
        return this;
    }
}

