/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util.regex;

import java.util.ArrayList;
import net.named_data.jndn.Name;
import net.named_data.jndn.util.regex.NdnRegexBackrefManager;
import net.named_data.jndn.util.regex.NdnRegexComponentMatcher;
import net.named_data.jndn.util.regex.NdnRegexMatcherBase;

public class NdnRegexComponentSetMatcher
extends NdnRegexMatcherBase {
    private final ArrayList<NdnRegexComponentMatcher> components_ = new ArrayList();
    boolean isInclusion_ = true;

    public NdnRegexComponentSetMatcher(String expr, NdnRegexBackrefManager backrefManager) throws NdnRegexMatcherBase.Error {
        super(expr, NdnRegexMatcherBase.NdnRegexExprType.COMPONENT_SET, backrefManager);
        this.compile();
    }

    @Override
    public boolean match(Name name, int offset, int len) throws NdnRegexMatcherBase.Error {
        boolean isMatched = false;
        if (len != 1) {
            return false;
        }
        for (NdnRegexComponentMatcher matcher : this.components_) {
            if (!matcher.match(name, offset, len)) continue;
            isMatched = true;
            break;
        }
        this.matchResult_.clear();
        if (this.isInclusion_ ? isMatched : !isMatched) {
            this.matchResult_.add(name.get(offset));
            return true;
        }
        return false;
    }

    @Override
    protected void compile() throws NdnRegexMatcherBase.Error {
        if (this.expr_.length() < 2) {
            throw new NdnRegexMatcherBase.Error("Regexp compile error (cannot parse " + this.expr_ + ")");
        }
        if (this.expr_.charAt(0) == '<') {
            this.compileSingleComponent();
        } else if (this.expr_.charAt(0) == '[') {
            int lastIndex = this.expr_.length() - 1;
            if (']' != this.expr_.charAt(lastIndex)) {
                throw new NdnRegexMatcherBase.Error("Regexp compile error (no matching ']' in " + this.expr_ + ")");
            }
            if ('^' == this.expr_.charAt(1)) {
                this.isInclusion_ = false;
                this.compileMultipleComponents(2, lastIndex);
            } else {
                this.compileMultipleComponents(1, lastIndex);
            }
        } else {
            throw new NdnRegexMatcherBase.Error("Regexp compile error (cannot parse " + this.expr_ + ")");
        }
    }

    private int extractComponent(int index) throws NdnRegexMatcherBase.Error {
        int lcount = 1;
        int rcount = 0;
        while (lcount > rcount) {
            if (index >= this.expr_.length()) {
                throw new NdnRegexMatcherBase.Error("Error: angle brackets mismatch");
            }
            if (this.expr_.charAt(index) == '<') {
                ++lcount;
            } else if (this.expr_.charAt(index) == '>') {
                ++rcount;
            }
            ++index;
        }
        return index;
    }

    private void compileSingleComponent() throws NdnRegexMatcherBase.Error {
        int end = this.extractComponent(1);
        if (this.expr_.length() != end) {
            throw new NdnRegexMatcherBase.Error("Component expr error " + this.expr_);
        }
        NdnRegexComponentMatcher component = new NdnRegexComponentMatcher(this.expr_.substring(1, end - 1), this.backrefManager_);
        this.components_.add(component);
    }

    private void compileMultipleComponents(int start, int lastIndex) throws NdnRegexMatcherBase.Error {
        int index = start;
        int tempIndex = start;
        while (index < lastIndex) {
            if ('<' != this.expr_.charAt(index)) {
                throw new NdnRegexMatcherBase.Error("Component expr error " + this.expr_);
            }
            tempIndex = index + 1;
            index = this.extractComponent(tempIndex);
            NdnRegexComponentMatcher component = new NdnRegexComponentMatcher(this.expr_.substring(tempIndex, index - 1), this.backrefManager_);
            this.components_.add(component);
        }
        if (index != lastIndex) {
            throw new NdnRegexMatcherBase.Error("Not sufficient expr to parse " + this.expr_);
        }
    }
}

