/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Data;
import net.named_data.jndn.Face;
import net.named_data.jndn.ForwardingFlags;
import net.named_data.jndn.Interest;
import net.named_data.jndn.InterestFilter;
import net.named_data.jndn.Name;
import net.named_data.jndn.OnInterestCallback;
import net.named_data.jndn.OnRegisterFailed;
import net.named_data.jndn.OnRegisterSuccess;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class MemoryContentCache
implements OnInterestCallback {
    private final Face face_;
    private final double cleanupIntervalMilliseconds_;
    private double nextCleanupTime_;
    private final HashMap onDataNotFoundForPrefix_ = new HashMap();
    private final ArrayList<Long> interestFilterIdList_ = new ArrayList();
    private final ArrayList<Long> registeredPrefixIdList_ = new ArrayList();
    private final ArrayList<Content> noStaleTimeCache_ = new ArrayList();
    private final ArrayList<StaleTimeContent> staleTimeCache_ = new ArrayList();
    private final Name.Component emptyComponent_ = new Name.Component();
    private final ArrayList<PendingInterest> pendingInterestTable_ = new ArrayList();
    private OnInterestCallback storePendingInterestCallback_;
    private double minimumCacheLifetime_ = 0.0;
    private static final Logger logger_ = Logger.getLogger(MemoryContentCache.class.getName());

    public MemoryContentCache(Face face, double cleanupIntervalMilliseconds) {
        this.face_ = face;
        this.cleanupIntervalMilliseconds_ = cleanupIntervalMilliseconds;
        this.construct();
    }

    public MemoryContentCache(Face face) {
        this.face_ = face;
        this.cleanupIntervalMilliseconds_ = 1000.0;
        this.construct();
    }

    private void construct() {
        this.nextCleanupTime_ = Common.getNowMilliseconds() + this.cleanupIntervalMilliseconds_;
        this.storePendingInterestCallback_ = new OnInterestCallback(){

            @Override
            public void onInterest(Name localPrefix, Interest localInterest, Face localFace, long localInterestFilterId, InterestFilter localFilter) {
                MemoryContentCache.this.storePendingInterest(localInterest, localFace);
            }
        };
    }

    public final void registerPrefix(Name prefix, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, OnInterestCallback onDataNotFound, ForwardingFlags flags, WireFormat wireFormat) throws IOException, SecurityException {
        if (onDataNotFound != null) {
            this.onDataNotFoundForPrefix_.put(prefix.toUri(), onDataNotFound);
        }
        long registeredPrefixId = this.face_.registerPrefix(prefix, (OnInterestCallback)this, onRegisterFailed, onRegisterSuccess, flags, wireFormat);
        this.registeredPrefixIdList_.add(registeredPrefixId);
    }

    public final void registerPrefix(Name prefix, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, OnInterestCallback onDataNotFound, ForwardingFlags flags) throws IOException, SecurityException {
        this.registerPrefix(prefix, onRegisterFailed, onRegisterSuccess, onDataNotFound, flags, WireFormat.getDefaultWireFormat());
    }

    public final void registerPrefix(Name prefix, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess, OnInterestCallback onDataNotFound) throws IOException, SecurityException {
        this.registerPrefix(prefix, onRegisterFailed, onRegisterSuccess, onDataNotFound, new ForwardingFlags(), WireFormat.getDefaultWireFormat());
    }

    public final void registerPrefix(Name prefix, OnRegisterFailed onRegisterFailed, OnRegisterSuccess onRegisterSuccess) throws IOException, SecurityException {
        this.registerPrefix(prefix, onRegisterFailed, onRegisterSuccess, null, new ForwardingFlags(), WireFormat.getDefaultWireFormat());
    }

    public final void registerPrefix(Name prefix, OnRegisterFailed onRegisterFailed, OnInterestCallback onDataNotFound, ForwardingFlags flags, WireFormat wireFormat) throws IOException, SecurityException {
        this.registerPrefix(prefix, onRegisterFailed, null, onDataNotFound, flags, wireFormat);
    }

    public final void registerPrefix(Name prefix, OnRegisterFailed onRegisterFailed, OnInterestCallback onDataNotFound, ForwardingFlags flags) throws IOException, SecurityException {
        this.registerPrefix(prefix, onRegisterFailed, onDataNotFound, flags, WireFormat.getDefaultWireFormat());
    }

    public final void registerPrefix(Name prefix, OnRegisterFailed onRegisterFailed, OnInterestCallback onDataNotFound) throws IOException, SecurityException {
        this.registerPrefix(prefix, onRegisterFailed, onDataNotFound, new ForwardingFlags(), WireFormat.getDefaultWireFormat());
    }

    public final void registerPrefix(Name prefix, OnRegisterFailed onRegisterFailed) throws IOException, SecurityException {
        this.registerPrefix(prefix, onRegisterFailed, null, new ForwardingFlags(), WireFormat.getDefaultWireFormat());
    }

    public final void setInterestFilter(InterestFilter filter, OnInterestCallback onDataNotFound) {
        if (onDataNotFound != null) {
            this.onDataNotFoundForPrefix_.put(filter.getPrefix().toUri(), onDataNotFound);
        }
        long interestFilterId = this.face_.setInterestFilter(filter, (OnInterestCallback)this);
        this.interestFilterIdList_.add(interestFilterId);
    }

    public final void setInterestFilter(InterestFilter filter) {
        this.setInterestFilter(filter, null);
    }

    public final void setInterestFilter(Name prefix, OnInterestCallback onDataNotFound) {
        if (onDataNotFound != null) {
            this.onDataNotFoundForPrefix_.put(prefix.toUri(), onDataNotFound);
        }
        long interestFilterId = this.face_.setInterestFilter(prefix, (OnInterestCallback)this);
        this.interestFilterIdList_.add(interestFilterId);
    }

    public final void setInterestFilter(Name prefix) {
        this.setInterestFilter(prefix, null);
    }

    public final void unregisterAll() {
        int i;
        for (i = 0; i < this.interestFilterIdList_.size(); ++i) {
            this.face_.unsetInterestFilter(this.interestFilterIdList_.get(i));
        }
        this.interestFilterIdList_.clear();
        for (i = 0; i < this.registeredPrefixIdList_.size(); ++i) {
            this.face_.removeRegisteredPrefix(this.registeredPrefixIdList_.get(i));
        }
        this.registeredPrefixIdList_.clear();
        this.onDataNotFoundForPrefix_.clear();
    }

    public final void add(Data data) {
        double nowMilliseconds = Common.getNowMilliseconds();
        this.doCleanup(nowMilliseconds);
        if (data.getMetaInfo().getFreshnessPeriod() >= 0.0) {
            int i;
            StaleTimeContent content = new StaleTimeContent(data, nowMilliseconds, this.minimumCacheLifetime_);
            for (i = this.staleTimeCache_.size() - 1; i >= 0 && !(this.staleTimeCache_.get(i).getCacheRemovalTimeMilliseconds() <= content.getCacheRemovalTimeMilliseconds()); --i) {
            }
            this.staleTimeCache_.add(i + 1, content);
        } else {
            this.noStaleTimeCache_.add(new Content(data));
        }
        for (int i = this.pendingInterestTable_.size() - 1; i >= 0; --i) {
            PendingInterest pendingInterest = this.pendingInterestTable_.get(i);
            if (pendingInterest.isTimedOut(nowMilliseconds)) {
                this.pendingInterestTable_.remove(i);
                continue;
            }
            if (!pendingInterest.getInterest().matchesName(data.getName())) continue;
            try {
                pendingInterest.getFace().send(data.wireEncode());
            }
            catch (IOException ex) {
                Logger.getLogger(MemoryContentCache.class.getName()).log(Level.SEVERE, ex.getMessage());
                return;
            }
            this.pendingInterestTable_.remove(i);
        }
    }

    public final void storePendingInterest(Interest interest, Face face) {
        this.pendingInterestTable_.add(new PendingInterest(interest, face));
    }

    public final OnInterestCallback getStorePendingInterest() {
        return this.storePendingInterestCallback_;
    }

    public final double getMinimumCacheLifetime() {
        return this.minimumCacheLifetime_;
    }

    public final void setMinimumCacheLifetime(double minimumCacheLifetime) {
        this.minimumCacheLifetime_ = minimumCacheLifetime;
    }

    @Override
    public final void onInterest(Name prefix, Interest interest, Face face, long interestFilterId, InterestFilter filter) {
        double nowMilliseconds = Common.getNowMilliseconds();
        this.doCleanup(nowMilliseconds);
        Name.Component selectedComponent = null;
        Blob selectedEncoding = null;
        int totalSize = this.staleTimeCache_.size() + this.noStaleTimeCache_.size();
        for (int i = 0; i < totalSize; ++i) {
            Content content;
            boolean isFresh = true;
            if (i < this.staleTimeCache_.size()) {
                StaleTimeContent staleTimeContent = this.staleTimeCache_.get(i);
                content = staleTimeContent;
                isFresh = staleTimeContent.isFresh(nowMilliseconds);
            } else {
                content = this.noStaleTimeCache_.get(i - this.staleTimeCache_.size());
            }
            if (!interest.matchesName(content.getName()) || interest.getMustBeFresh() && !isFresh) continue;
            if (interest.getChildSelector() < 0) {
                try {
                    face.send(content.getDataEncoding());
                }
                catch (IOException ex) {
                    Logger.getLogger(MemoryContentCache.class.getName()).log(Level.SEVERE, null, ex);
                }
                return;
            }
            Name.Component component = content.getName().size() > interest.getName().size() ? content.getName().get(interest.getName().size()) : this.emptyComponent_;
            boolean gotBetterMatch = false;
            if (selectedEncoding == null) {
                gotBetterMatch = true;
            } else if (interest.getChildSelector() == 0) {
                if (component.compare(selectedComponent) < 0) {
                    gotBetterMatch = true;
                }
            } else if (component.compare(selectedComponent) > 0) {
                gotBetterMatch = true;
            }
            if (!gotBetterMatch) continue;
            selectedComponent = component;
            selectedEncoding = content.getDataEncoding();
        }
        if (selectedEncoding != null) {
            try {
                face.send(selectedEncoding);
            }
            catch (IOException ex) {
                Logger.getLogger(MemoryContentCache.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            Object onDataNotFound = this.onDataNotFoundForPrefix_.get(prefix.toUri());
            if (onDataNotFound != null) {
                try {
                    ((OnInterestCallback)onDataNotFound).onInterest(prefix, interest, face, interestFilterId, filter);
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, "Error in onDataNotFound", ex);
                }
            }
        }
    }

    private void doCleanup(double nowMilliseconds) {
        if (nowMilliseconds >= this.nextCleanupTime_) {
            while (this.staleTimeCache_.size() > 0 && this.staleTimeCache_.get(0).isPastRemovalTime(nowMilliseconds)) {
                this.staleTimeCache_.remove(0);
            }
            this.nextCleanupTime_ = nowMilliseconds + this.cleanupIntervalMilliseconds_;
        }
    }

    private static class PendingInterest {
        private final Interest interest_;
        private final Face face_;
        private final double timeoutTimeMilliseconds_;

        public PendingInterest(Interest interest, Face face) {
            this.interest_ = interest;
            this.face_ = face;
            this.timeoutTimeMilliseconds_ = this.interest_.getInterestLifetimeMilliseconds() >= 0.0 ? Common.getNowMilliseconds() + this.interest_.getInterestLifetimeMilliseconds() : -1.0;
        }

        public final Interest getInterest() {
            return this.interest_;
        }

        public final Face getFace() {
            return this.face_;
        }

        public final boolean isTimedOut(double nowMilliseconds) {
            return this.timeoutTimeMilliseconds_ >= 0.0 && nowMilliseconds >= this.timeoutTimeMilliseconds_;
        }
    }

    private class StaleTimeContent
    extends Content {
        private final double cacheRemovalTimeMilliseconds_;
        private final double freshnessExpiryTimeMilliseconds_;

        public StaleTimeContent(Data data, double nowMilliseconds, double minimumCacheLifetime) {
            super(data);
            this.cacheRemovalTimeMilliseconds_ = nowMilliseconds + Math.max(data.getMetaInfo().getFreshnessPeriod(), minimumCacheLifetime);
            this.freshnessExpiryTimeMilliseconds_ = nowMilliseconds + data.getMetaInfo().getFreshnessPeriod();
        }

        public final boolean isPastRemovalTime(double nowMilliseconds) {
            return this.cacheRemovalTimeMilliseconds_ <= nowMilliseconds;
        }

        public final boolean isFresh(double nowMilliseconds) {
            return this.freshnessExpiryTimeMilliseconds_ > nowMilliseconds;
        }

        public final double getCacheRemovalTimeMilliseconds() {
            return this.cacheRemovalTimeMilliseconds_;
        }
    }

    private class Content {
        private final Name name_;
        private final Blob dataEncoding_;

        public Content(Data data) {
            this.name_ = data.getName();
            this.dataEncoding_ = data.wireEncode();
        }

        public final Name getName() {
            return this.name_;
        }

        public final Blob getDataEncoding() {
            return this.dataEncoding_;
        }
    }
}

