/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.util;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Face;
import net.named_data.jndn.Interest;
import net.named_data.jndn.OnData;
import net.named_data.jndn.OnTimeout;

public class ExponentialReExpress
implements OnTimeout {
    private final Face face_;
    private final OnData callerOnData_;
    private final OnTimeout callerOnTimeout_;
    private final double maxInterestLifetime_;
    private static final Logger logger_ = Logger.getLogger(ExponentialReExpress.class.getName());

    public static OnTimeout makeOnTimeout(Face face, OnData onData, OnTimeout onTimeout, double maxInterestLifetime) {
        return new ExponentialReExpress(face, onData, onTimeout, maxInterestLifetime);
    }

    public static OnTimeout makeOnTimeout(Face face, OnData onData, OnTimeout onTimeout) {
        return ExponentialReExpress.makeOnTimeout(face, onData, onTimeout, 16000.0);
    }

    private ExponentialReExpress(Face face, OnData onData, OnTimeout onTimeout, double maxInterestLifetime) {
        this.face_ = face;
        this.callerOnData_ = onData;
        this.callerOnTimeout_ = onTimeout;
        this.maxInterestLifetime_ = maxInterestLifetime;
    }

    @Override
    public void onTimeout(Interest interest) {
        double interestLifetime = interest.getInterestLifetimeMilliseconds();
        if (interestLifetime < 0.0) {
            if (this.callerOnTimeout_ != null) {
                try {
                    this.callerOnTimeout_.onTimeout(interest);
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, "Error in onTimeout", ex);
                }
            }
            return;
        }
        double nextInterestLifetime = interestLifetime * 2.0;
        if (nextInterestLifetime > this.maxInterestLifetime_) {
            if (this.callerOnTimeout_ != null) {
                try {
                    this.callerOnTimeout_.onTimeout(interest);
                }
                catch (Throwable ex) {
                    logger_.log(Level.SEVERE, "Error in onTimeout", ex);
                }
            }
            return;
        }
        Interest nextInterest = new Interest(interest);
        nextInterest.setInterestLifetimeMilliseconds(nextInterestLifetime);
        logger_.log(Level.FINE, "ExponentialReExpress: Increasing interest lifetime from {0} to {1} ms. Re-express interest {2}", new Object[]{interestLifetime, nextInterestLifetime, nextInterest.getName().toUri()});
        try {
            this.face_.expressInterest(nextInterest, this.callerOnData_, (OnTimeout)this);
        }
        catch (IOException ex) {
            logger_.log(Level.SEVERE, null, ex);
        }
    }
}

