/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2.validator_config;

import net.named_data.jndn.Name;
import net.named_data.jndn.security.ValidatorConfigError;
import net.named_data.jndn.security.pib.PibKey;
import net.named_data.jndn.security.v2.ValidationError;
import net.named_data.jndn.security.v2.ValidationState;
import net.named_data.jndn.security.v2.validator_config.ConfigChecker;
import net.named_data.jndn.security.v2.validator_config.ConfigNameRelation;

public class ConfigNameRelationChecker
extends ConfigChecker {
    private final Name name_;
    private final ConfigNameRelation.Relation relation_;

    public ConfigNameRelationChecker(Name name, ConfigNameRelation.Relation relation) {
        this.name_ = name;
        this.relation_ = relation;
    }

    @Override
    protected boolean checkNames(Name packetName, Name keyLocatorName, ValidationState state) throws ValidatorConfigError {
        Name identity = PibKey.extractIdentityFromKeyName(keyLocatorName);
        boolean result = ConfigNameRelation.checkNameRelation(this.relation_, this.name_, identity);
        if (!result) {
            state.fail(new ValidationError(9, "KeyLocator check failed: name relation " + this.name_.toUri() + " " + ConfigNameRelation.toString(this.relation_) + " for packet " + packetName.toUri() + " is invalid (KeyLocator=" + keyLocatorName.toUri() + ", identity=" + identity.toUri() + ")"));
        }
        return result;
    }
}

