/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2.validator_config;

import net.named_data.jndn.Name;
import net.named_data.jndn.security.ValidatorConfigError;
import net.named_data.jndn.security.v2.validator_config.ConfigNameRelation;
import net.named_data.jndn.security.v2.validator_config.ConfigRegexNameFilter;
import net.named_data.jndn.security.v2.validator_config.ConfigRelationNameFilter;
import net.named_data.jndn.util.BoostInfoTree;

public abstract class ConfigFilter {
    public final boolean match(boolean isForInterest, Name packetName) throws ValidatorConfigError {
        if (isForInterest) {
            int signedInterestMinSize = 2;
            if (packetName.size() < 2) {
                return false;
            }
            return this.matchName(packetName.getPrefix(-2));
        }
        return this.matchName(packetName);
    }

    public static ConfigFilter create(BoostInfoTree configSection) throws ValidatorConfigError {
        String filterType = configSection.getFirstValue("type");
        if (filterType == null) {
            throw new ValidatorConfigError("Expected <filter.type>");
        }
        if (filterType.equalsIgnoreCase("name")) {
            return ConfigFilter.createNameFilter(configSection);
        }
        throw new ValidatorConfigError("Unsupported filter.type: " + filterType);
    }

    protected abstract boolean matchName(Name var1) throws ValidatorConfigError;

    private static ConfigFilter createNameFilter(BoostInfoTree configSection) throws ValidatorConfigError {
        String nameUri = configSection.getFirstValue("name");
        if (nameUri != null) {
            Name name = new Name(nameUri);
            String relationValue = configSection.getFirstValue("relation");
            if (relationValue == null) {
                throw new ValidatorConfigError("Expected <filter.relation>");
            }
            ConfigNameRelation.Relation relation = ConfigNameRelation.getNameRelationFromString(relationValue);
            return new ConfigRelationNameFilter(name, relation);
        }
        String regexString = configSection.getFirstValue("regex");
        if (regexString != null) {
            try {
                return new ConfigRegexNameFilter(regexString);
            }
            catch (Exception e) {
                throw new ValidatorConfigError("Wrong filter.regex: " + regexString);
            }
        }
        throw new ValidatorConfigError("Wrong filter(name) properties");
    }
}

