/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2.validator_config;

import java.util.ArrayList;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.ValidatorConfigError;
import net.named_data.jndn.security.v2.ValidationState;
import net.named_data.jndn.security.v2.validator_config.ConfigHyperRelationChecker;
import net.named_data.jndn.security.v2.validator_config.ConfigNameRelation;
import net.named_data.jndn.security.v2.validator_config.ConfigNameRelationChecker;
import net.named_data.jndn.security.v2.validator_config.ConfigRegexChecker;
import net.named_data.jndn.util.BoostInfoTree;
import net.named_data.jndn.util.regex.NdnRegexMatcherBase;

public abstract class ConfigChecker {
    public final boolean check(boolean isForInterest, Name packetName, Name keyLocatorName, ValidationState state) throws ValidatorConfigError {
        if (isForInterest) {
            int signedInterestMinSize = 2;
            if (packetName.size() < 2) {
                return false;
            }
            return this.checkNames(packetName.getPrefix(-2), keyLocatorName, state);
        }
        return this.checkNames(packetName, keyLocatorName, state);
    }

    public static ConfigChecker create(BoostInfoTree configSection) throws ValidatorConfigError {
        String checkerType = configSection.getFirstValue("type");
        if (checkerType == null) {
            throw new ValidatorConfigError("Expected <checker.type>");
        }
        if (checkerType.equalsIgnoreCase("customized")) {
            return ConfigChecker.createCustomizedChecker(configSection);
        }
        if (checkerType.equalsIgnoreCase("hierarchical")) {
            return ConfigChecker.createHierarchicalChecker(configSection);
        }
        throw new ValidatorConfigError("Unsupported checker type: " + checkerType);
    }

    protected abstract boolean checkNames(Name var1, Name var2, ValidationState var3) throws ValidatorConfigError;

    private static ConfigChecker createCustomizedChecker(BoostInfoTree configSection) throws ValidatorConfigError {
        ArrayList<BoostInfoTree> keyLocatorSection = configSection.get("key-locator");
        if (keyLocatorSection.size() != 1) {
            throw new ValidatorConfigError("Expected one <checker.key-locator>");
        }
        return ConfigChecker.createKeyLocatorChecker(keyLocatorSection.get(0));
    }

    private static ConfigChecker createHierarchicalChecker(BoostInfoTree configSection) throws ValidatorConfigError {
        try {
            return new ConfigHyperRelationChecker("^(<>*)$", "\\1", "^(<>*)<KEY><>$", "\\1", ConfigNameRelation.Relation.IS_PREFIX_OF);
        }
        catch (NdnRegexMatcherBase.Error ex) {
            throw new ValidatorConfigError("Error creating ConfigHyperRelationChecker: " + ex);
        }
    }

    private static ConfigChecker createKeyLocatorChecker(BoostInfoTree configSection) throws ValidatorConfigError {
        String keyLocatorType = configSection.getFirstValue("type");
        if (keyLocatorType == null) {
            throw new ValidatorConfigError("Expected <checker.key-locator.type>");
        }
        if (keyLocatorType.equalsIgnoreCase("name")) {
            return ConfigChecker.createKeyLocatorNameChecker(configSection);
        }
        throw new ValidatorConfigError("Unsupported checker.key-locator.type: " + keyLocatorType);
    }

    private static ConfigChecker createKeyLocatorNameChecker(BoostInfoTree configSection) throws ValidatorConfigError {
        String nameUri = configSection.getFirstValue("name");
        if (nameUri != null) {
            Name name = new Name(nameUri);
            String relationValue = configSection.getFirstValue("relation");
            if (relationValue == null) {
                throw new ValidatorConfigError("Expected <checker.key-locator.relation>");
            }
            ConfigNameRelation.Relation relation = ConfigNameRelation.getNameRelationFromString(relationValue);
            return new ConfigNameRelationChecker(name, relation);
        }
        String regexString = configSection.getFirstValue("regex");
        if (regexString != null) {
            try {
                return new ConfigRegexChecker(regexString);
            }
            catch (Exception e) {
                throw new ValidatorConfigError("Invalid checker.key-locator.regex: " + regexString);
            }
        }
        ArrayList<BoostInfoTree> hyperRelationList = configSection.get("hyper-relation");
        if (hyperRelationList.size() == 1) {
            BoostInfoTree hyperRelation = hyperRelationList.get(0);
            String keyRegex = hyperRelation.getFirstValue("k-regex");
            if (keyRegex == null) {
                throw new ValidatorConfigError("Expected <checker.key-locator.hyper-relation.k-regex>");
            }
            String keyExpansion = hyperRelation.getFirstValue("k-expand");
            if (keyExpansion == null) {
                throw new ValidatorConfigError("Expected <checker.key-locator.hyper-relation.k-expand");
            }
            String hyperRelationString = hyperRelation.getFirstValue("h-relation");
            if (hyperRelationString == null) {
                throw new ValidatorConfigError("Expected <checker.key-locator.hyper-relation.h-relation>");
            }
            String packetNameRegex = hyperRelation.getFirstValue("p-regex");
            if (packetNameRegex == null) {
                throw new ValidatorConfigError("Expected <checker.key-locator.hyper-relation.p-regex>");
            }
            String packetNameExpansion = hyperRelation.getFirstValue("p-expand");
            if (packetNameExpansion == null) {
                throw new ValidatorConfigError("Expected <checker.key-locator.hyper-relation.p-expand>");
            }
            ConfigNameRelation.Relation relation = ConfigNameRelation.getNameRelationFromString(hyperRelationString);
            try {
                return new ConfigHyperRelationChecker(packetNameRegex, packetNameExpansion, keyRegex, keyExpansion, relation);
            }
            catch (Exception e) {
                throw new ValidatorConfigError("Invalid regex for key-locator.hyper-relation");
            }
        }
        throw new ValidatorConfigError("Unsupported checker.key-locator");
    }
}

