/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.v2;

import net.named_data.jndn.Data;
import net.named_data.jndn.Interest;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.ValidatorConfigError;
import net.named_data.jndn.security.pib.Pib;
import net.named_data.jndn.security.pib.PibIdentity;
import net.named_data.jndn.security.pib.PibKey;
import net.named_data.jndn.security.v2.CertificateRequest;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.security.v2.ValidationError;
import net.named_data.jndn.security.v2.ValidationPolicy;
import net.named_data.jndn.security.v2.ValidationState;

public class ValidationPolicyFromPib
extends ValidationPolicy {
    private final Pib pib_;

    public ValidationPolicyFromPib(Pib pib) {
        this.pib_ = pib;
    }

    @Override
    public void checkPolicy(Data data, ValidationState state, ValidationPolicy.ValidationContinuation continueValidation) throws CertificateV2.Error, ValidatorConfigError {
        Name keyName = ValidationPolicyFromPib.getKeyLocatorName(data, state);
        if (state.isOutcomeFailed()) {
            return;
        }
        this.checkPolicyHelper(keyName, state, continueValidation);
    }

    @Override
    public void checkPolicy(Interest interest, ValidationState state, ValidationPolicy.ValidationContinuation continueValidation) throws CertificateV2.Error, ValidatorConfigError {
        Name keyName = ValidationPolicyFromPib.getKeyLocatorName(interest, state);
        if (state.isOutcomeFailed()) {
            return;
        }
        this.checkPolicyHelper(keyName, state, continueValidation);
    }

    private void checkPolicyHelper(Name keyName, ValidationState state, ValidationPolicy.ValidationContinuation continueValidation) throws CertificateV2.Error, ValidatorConfigError {
        CertificateV2 certificate;
        PibKey key;
        PibIdentity identity;
        try {
            identity = this.pib_.getIdentity(PibKey.extractIdentityFromKeyName(keyName));
        }
        catch (Throwable ex) {
            state.fail(new ValidationError(3, "Cannot get the PIB identity for key " + keyName.toUri() + ": " + ex));
            return;
        }
        try {
            key = identity.getKey(keyName);
        }
        catch (Throwable ex) {
            state.fail(new ValidationError(3, "Cannot get the PIB key " + keyName.toUri() + ": " + ex));
            return;
        }
        try {
            certificate = key.getDefaultCertificate();
        }
        catch (Throwable ex) {
            state.fail(new ValidationError(3, "Cannot get the default certificate for key " + keyName.toUri() + ": " + ex));
            return;
        }
        this.validator_.resetAnchors();
        try {
            this.validator_.loadAnchor("", certificate);
        }
        catch (Throwable ex) {
            state.fail(new ValidationError(3, "Cannot load the trust anchor for key " + keyName.toUri() + ": " + ex));
            return;
        }
        continueValidation.continueValidation(new CertificateRequest(new Interest(keyName)), state);
        this.validator_.resetAnchors();
    }
}

