/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.tpm;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.List;
import javax.crypto.Cipher;
import net.named_data.jndn.encoding.OID;
import net.named_data.jndn.encoding.der.DerDecodingException;
import net.named_data.jndn.encoding.der.DerEncodingException;
import net.named_data.jndn.encoding.der.DerNode;
import net.named_data.jndn.encrypt.algo.EncryptAlgorithmType;
import net.named_data.jndn.security.DigestAlgorithm;
import net.named_data.jndn.security.EcKeyParams;
import net.named_data.jndn.security.KeyParams;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.RsaKeyParams;
import net.named_data.jndn.util.Blob;

public class TpmPrivateKey {
    private static String RSA_ENCRYPTION_OID = "1.2.840.113549.1.1.1";
    private static String EC_ENCRYPTION_OID = "1.2.840.10045.2.1";
    private KeyType keyType_ = null;
    private PrivateKey privateKey_;

    public final void loadPkcs1(ByteBuffer encoding, KeyType keyType) throws Error {
        if (keyType == null) {
            try {
                DerNode parsedNode = DerNode.parse(encoding);
                List children = parsedNode.getChildren();
                keyType = children.size() == 9 && children.get(0) instanceof DerNode.DerInteger && (Integer)((DerNode.DerInteger)children.get(0)).toVal() == 0 && children.get(1) instanceof DerNode.DerInteger && children.get(2) instanceof DerNode.DerInteger && children.get(3) instanceof DerNode.DerInteger && children.get(4) instanceof DerNode.DerInteger && children.get(5) instanceof DerNode.DerInteger && children.get(6) instanceof DerNode.DerInteger && children.get(7) instanceof DerNode.DerInteger && children.get(8) instanceof DerNode.DerInteger ? KeyType.RSA : KeyType.EC;
            }
            catch (DerDecodingException ex) {
                keyType = KeyType.EC;
            }
        }
        if (keyType == KeyType.EC) {
            throw new Error("TODO: loadPkcs1 for EC is not implemented");
        }
        if (keyType != KeyType.RSA) {
            throw new Error("loadPkcs1: Unrecognized keyType: " + (Object)((Object)keyType));
        }
        Blob pkcs8 = TpmPrivateKey.encodePkcs8PrivateKey(encoding, new OID(RSA_ENCRYPTION_OID), new DerNode.DerNull());
        this.loadPkcs8(pkcs8.buf(), keyType);
    }

    public final void loadPkcs1(ByteBuffer encoding) throws Error {
        this.loadPkcs1(encoding, null);
    }

    public final void loadPkcs8(ByteBuffer encoding, KeyType keyType) throws Error {
        KeyFactory kf;
        if (keyType == null) {
            String oidString = null;
            try {
                DerNode parsedNode = DerNode.parse(encoding, 0);
                List pkcs8Children = parsedNode.getChildren();
                List algorithmIdChildren = DerNode.getSequence(pkcs8Children, 1).getChildren();
                oidString = "" + ((DerNode.DerOid)algorithmIdChildren.get(0)).toVal();
            }
            catch (DerDecodingException ex) {
                throw new Error("Cannot decode the PKCS #8 private key: " + ex);
            }
            if (oidString.equals(EC_ENCRYPTION_OID)) {
                keyType = KeyType.EC;
            } else if (oidString.equals(RSA_ENCRYPTION_OID)) {
                keyType = KeyType.RSA;
            } else {
                throw new Error("loadPkcs8: Unrecognized private key OID: " + oidString);
            }
        }
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(new Blob(encoding, false).getImmutableArray());
        if (keyType == KeyType.EC) {
            try {
                kf = KeyFactory.getInstance("EC");
                this.privateKey_ = kf.generatePrivate(spec);
                this.keyType_ = KeyType.EC;
            }
            catch (InvalidKeySpecException ex) {
                throw new Error("loadPkcs8: EC is not supported: " + ex);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new Error("loadPkcs8: PKCS8EncodedKeySpec is not supported for EC: " + ex);
            }
        } else if (keyType == KeyType.RSA) {
            try {
                kf = KeyFactory.getInstance("RSA");
                this.privateKey_ = kf.generatePrivate(spec);
                this.keyType_ = KeyType.RSA;
            }
            catch (InvalidKeySpecException ex) {
                throw new Error("loadPkcs8: RSA is not supported: " + ex);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new Error("loadPkcs8: PKCS8EncodedKeySpec is not supported for RSA: " + ex);
            }
        } else {
            throw new Error("loadPkcs8: Unrecognized keyType: " + (Object)((Object)keyType));
        }
    }

    public final void loadPkcs8(ByteBuffer encoding) throws Error {
        this.loadPkcs8(encoding, null);
    }

    public final Blob derivePublicKey() throws Error {
        if (this.keyType_ == KeyType.EC) {
            throw new Error("TODO: derivePublicKey for EC is not implemented");
        }
        if (this.keyType_ == KeyType.RSA) {
            List rsaPrivateKeyChildren;
            try {
                DerNode parsedNode = DerNode.parse(this.toPkcs1().buf(), 0);
                rsaPrivateKeyChildren = parsedNode.getChildren();
            }
            catch (DerDecodingException ex) {
                throw new Error("Error parsing RSA PKCS #1 key: " + ex);
            }
            Blob modulus = ((DerNode)rsaPrivateKeyChildren.get(1)).getPayload();
            Blob publicExponent = ((DerNode)rsaPrivateKeyChildren.get(2)).getPayload();
            try {
                PublicKey publicKey = KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(new BigInteger(modulus.getImmutableArray()), new BigInteger(publicExponent.getImmutableArray())));
                return new Blob(publicKey.getEncoded(), false);
            }
            catch (Exception ex) {
                throw new Error("Error making RSA public key: " + ex);
            }
        }
        throw new Error("derivePublicKey: The private key is not loaded");
    }

    public final Blob decrypt(ByteBuffer cipherText, EncryptAlgorithmType algorithmType) throws Error {
        String transformation;
        if (this.keyType_ == null) {
            throw new Error("decrypt: The private key is not loaded");
        }
        if (algorithmType == EncryptAlgorithmType.RsaPkcs) {
            transformation = "RSA/ECB/PKCS1Padding";
        } else if (algorithmType == EncryptAlgorithmType.RsaOaep) {
            transformation = "RSA/ECB/OAEPWithSHA-1AndMGF1Padding";
        } else {
            throw new Error("unsupported padding scheme");
        }
        try {
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(2, this.privateKey_);
            byte[] cipherByteArray = new Blob(cipherText, false).getImmutableArray();
            return new Blob(cipher.doFinal(cipherByteArray), false);
        }
        catch (Exception ex) {
            throw new Error("Error decrypting with private key: " + ex.getMessage());
        }
    }

    public final Blob decrypt(ByteBuffer cipherText) throws Error {
        return this.decrypt(cipherText, EncryptAlgorithmType.RsaOaep);
    }

    public final Blob sign(ByteBuffer data, DigestAlgorithm digestAlgorithm) throws Error {
        if (digestAlgorithm != DigestAlgorithm.SHA256) {
            throw new Error("TpmPrivateKey.sign: Unsupported digest algorithm");
        }
        Signature signature = null;
        if (this.keyType_ == KeyType.EC) {
            try {
                signature = Signature.getInstance("SHA256withECDSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error("SHA256withECDSA algorithm is not supported");
            }
        } else if (this.keyType_ == KeyType.RSA) {
            try {
                signature = Signature.getInstance("SHA256withRSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new Error("SHA256withRSA algorithm is not supported");
            }
        } else {
            return new Blob();
        }
        try {
            signature.initSign(this.privateKey_);
        }
        catch (InvalidKeyException exception) {
            throw new Error("InvalidKeyException: " + exception.getMessage());
        }
        try {
            signature.update(data);
            return new Blob(signature.sign(), false);
        }
        catch (SignatureException exception) {
            throw new Error("SignatureException: " + exception.getMessage());
        }
    }

    public final Blob toPkcs1() throws Error {
        if (this.keyType_ == null) {
            throw new Error("toPkcs1: The private key is not loaded");
        }
        try {
            DerNode parsedNode = DerNode.parse(this.toPkcs8().buf(), 0);
            List pkcs8Children = parsedNode.getChildren();
            return ((DerNode)pkcs8Children.get(2)).getPayload();
        }
        catch (DerDecodingException ex) {
            throw new Error("Error decoding PKCS #8 private key: " + ex);
        }
    }

    public final Blob toPkcs8() throws Error {
        if (this.keyType_ == null) {
            throw new Error("toPkcs8: The private key is not loaded");
        }
        return new Blob(this.privateKey_.getEncoded());
    }

    public static TpmPrivateKey generatePrivateKey(KeyParams keyParams) throws IllegalArgumentException, Error {
        int keySize;
        String keyAlgorithm;
        if (keyParams.getKeyType() == KeyType.RSA) {
            keyAlgorithm = "RSA";
            keySize = ((RsaKeyParams)keyParams).getKeySize();
        } else if (keyParams.getKeyType() == KeyType.EC) {
            keyAlgorithm = "EC";
            keySize = ((EcKeyParams)keyParams).getKeySize();
        } else {
            throw new IllegalArgumentException("Cannot generate a key pair of type " + (Object)((Object)keyParams.getKeyType()));
        }
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance(keyAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("TpmPrivateKey: Could not create the key generator: " + e.getMessage());
        }
        generator.initialize(keySize);
        KeyPair pair = generator.generateKeyPair();
        TpmPrivateKey result = new TpmPrivateKey();
        result.keyType_ = keyParams.getKeyType();
        result.privateKey_ = pair.getPrivate();
        return result;
    }

    private static Blob encodePkcs8PrivateKey(ByteBuffer privateKeyDer, OID oid, DerNode parameters) throws Error {
        try {
            DerNode.DerSequence algorithmIdentifier = new DerNode.DerSequence();
            algorithmIdentifier.addChild(new DerNode.DerOid(oid));
            algorithmIdentifier.addChild(parameters);
            DerNode.DerSequence result = new DerNode.DerSequence();
            result.addChild(new DerNode.DerInteger(0));
            result.addChild(algorithmIdentifier);
            result.addChild(new DerNode.DerOctetString(privateKeyDer));
            return result.encode();
        }
        catch (DerEncodingException ex) {
            throw new Error("Error encoding PKCS #8 private key: " + ex);
        }
    }

    public static class Error
    extends Exception {
        public Error(String message) {
            super(message);
        }
    }
}

