/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.tpm;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.named_data.jndn.Name;
import net.named_data.jndn.security.KeyParams;
import net.named_data.jndn.security.tpm.TpmBackEnd;
import net.named_data.jndn.security.tpm.TpmKeyHandle;
import net.named_data.jndn.security.tpm.TpmKeyHandleMemory;
import net.named_data.jndn.security.tpm.TpmPrivateKey;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class TpmBackEndFile
extends TpmBackEnd {
    private File keyStorePath_;

    public TpmBackEndFile() {
        this.keyStorePath_ = new File(TpmBackEndFile.getDefaultDirecoryPath(Common.getHomeDirectory()));
        this.keyStorePath_.mkdirs();
    }

    public TpmBackEndFile(String locationPath) {
        this.keyStorePath_ = new File(locationPath);
        this.keyStorePath_.mkdirs();
    }

    public static String getDefaultDirecoryPath(File filesRoot) {
        return TpmBackEndFile.getDefaultDirecoryPath(filesRoot.getAbsolutePath());
    }

    public static String getDefaultDirecoryPath(String filesRoot) {
        return new File(new File(new File(filesRoot), ".ndn"), "ndnsec-key-file").getAbsolutePath();
    }

    public static String getScheme() {
        return "tpm-file";
    }

    @Override
    protected boolean doHasKey(Name keyName) throws TpmBackEnd.Error {
        if (!this.toFilePath(keyName).exists()) {
            return false;
        }
        try {
            this.loadKey(keyName);
            return true;
        }
        catch (TpmBackEnd.Error ex) {
            return false;
        }
    }

    @Override
    protected TpmKeyHandle doGetKeyHandle(Name keyName) throws TpmBackEnd.Error {
        if (!this.doHasKey(keyName)) {
            return null;
        }
        return new TpmKeyHandleMemory(this.loadKey(keyName));
    }

    @Override
    protected TpmKeyHandle doCreateKey(Name identityName, KeyParams params) throws TpmBackEnd.Error {
        TpmPrivateKey key;
        try {
            key = TpmPrivateKey.generatePrivateKey(params);
        }
        catch (TpmPrivateKey.Error ex) {
            throw new Error("Error in TpmPrivateKey.generatePrivateKey: " + ex);
        }
        TpmKeyHandleMemory keyHandle = new TpmKeyHandleMemory(key);
        TpmBackEndFile.setKeyName(keyHandle, identityName, params);
        this.saveKey(keyHandle.getKeyName(), key);
        return keyHandle;
    }

    @Override
    protected void doDeleteKey(Name keyName) throws TpmBackEnd.Error {
        this.toFilePath(keyName).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TpmPrivateKey loadKey(Name keyName) throws TpmBackEnd.Error {
        TpmPrivateKey key = new TpmPrivateKey();
        StringBuilder base64 = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.toFilePath(keyName).getAbsolutePath()));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                base64.append(line);
            }
        }
        catch (FileNotFoundException ex) {
            throw new Error("Error reading private key file: " + ex);
        }
        catch (IOException ex) {
            throw new Error("Error reading private key file: " + ex);
        }
        byte[] pkcs = Common.base64Decode(base64.toString());
        try {
            key.loadPkcs1(ByteBuffer.wrap(pkcs), null);
        }
        catch (TpmPrivateKey.Error ex) {
            throw new Error("Error decoding private key file: " + ex);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveKey(Name keyName, TpmPrivateKey key) throws TpmBackEnd.Error {
        String base64;
        String filePath = this.toFilePath(keyName).getAbsolutePath();
        try {
            base64 = Common.base64Encode(key.toPkcs1().getImmutableArray(), true);
        }
        catch (TpmPrivateKey.Error ex) {
            throw new Error("Error encoding private key file: " + ex);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(filePath));){
            writer.write(base64, 0, base64.length());
            writer.flush();
        }
        catch (IOException ex) {
            throw new Error("Error writing private key file: " + ex);
        }
    }

    private File toFilePath(Name keyName) {
        Blob keyEncoding = keyName.wireEncode();
        byte[] digest = Common.digestSha256(keyEncoding.buf());
        return new File(this.keyStorePath_, new Blob(digest, false).toHex() + ".privkey");
    }

    public static class Error
    extends TpmBackEnd.Error {
        public Error(String message) {
            super(message);
        }
    }
}

