/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.policy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.named_data.jndn.Data;
import net.named_data.jndn.Interest;
import net.named_data.jndn.KeyLocator;
import net.named_data.jndn.KeyLocatorType;
import net.named_data.jndn.Name;
import net.named_data.jndn.Signature;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.encoding.WireFormat;
import net.named_data.jndn.encoding.der.DerDecodingException;
import net.named_data.jndn.security.OnDataValidationFailed;
import net.named_data.jndn.security.OnInterestValidationFailed;
import net.named_data.jndn.security.OnVerified;
import net.named_data.jndn.security.OnVerifiedInterest;
import net.named_data.jndn.security.SecurityException;
import net.named_data.jndn.security.ValidationRequest;
import net.named_data.jndn.security.certificate.IdentityCertificate;
import net.named_data.jndn.security.policy.CertificateCache;
import net.named_data.jndn.security.policy.PolicyManager;
import net.named_data.jndn.security.v2.CertificateCacheV2;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.BoostInfoParser;
import net.named_data.jndn.util.BoostInfoTree;
import net.named_data.jndn.util.Common;
import net.named_data.jndn.util.SignedBlob;
import net.named_data.jndn.util.regex.NdnRegexMatcherBase;
import net.named_data.jndn.util.regex.NdnRegexTopMatcher;

public class ConfigPolicyManager
extends PolicyManager {
    private final boolean isSecurityV1_;
    private CertificateCache certificateCache_ = new CertificateCache();
    private CertificateCacheV2 certificateCacheV2_ = new CertificateCacheV2();
    private int maxDepth_ = 5;
    private double keyGraceInterval_ = 3000.0;
    private double keyTimestampTtl_ = 3600000.0;
    private int maxTrackedKeys_ = 1000;
    private final HashMap fixedCertificateCache_ = new HashMap();
    private final HashMap keyTimestamps_ = new HashMap();
    private BoostInfoParser config_ = new BoostInfoParser();
    private boolean requiresVerification_ = true;
    private TrustAnchorRefreshManager refreshManager_;
    private static final Logger logger_ = Logger.getLogger(ConfigPolicyManager.class.getName());

    public ConfigPolicyManager(String configFileName, CertificateCache certificateCache, int searchDepth, double graceInterval, double keyTimestampTtl, int maxTrackedKeys) throws IOException, SecurityException, CertificateV2.Error {
        this.isSecurityV1_ = true;
        this.certificateCache_ = certificateCache;
        this.maxDepth_ = searchDepth;
        this.keyGraceInterval_ = graceInterval;
        this.keyTimestampTtl_ = keyTimestampTtl;
        this.maxTrackedKeys_ = maxTrackedKeys;
        this.reset();
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager(String configFileName, CertificateCache certificateCache, int searchDepth, double graceInterval, double keyTimestampTtl) throws IOException, SecurityException, CertificateV2.Error {
        this.isSecurityV1_ = true;
        this.certificateCache_ = certificateCache;
        this.maxDepth_ = searchDepth;
        this.keyGraceInterval_ = graceInterval;
        this.keyTimestampTtl_ = keyTimestampTtl;
        this.reset();
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager(String configFileName, CertificateCache certificateCache, int searchDepth, double graceInterval) throws IOException, SecurityException, CertificateV2.Error {
        this.isSecurityV1_ = true;
        this.certificateCache_ = certificateCache;
        this.maxDepth_ = searchDepth;
        this.keyGraceInterval_ = graceInterval;
        this.reset();
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager(String configFileName, CertificateCache certificateCache, int searchDepth) throws IOException, SecurityException, CertificateV2.Error {
        this.isSecurityV1_ = true;
        this.certificateCache_ = certificateCache;
        this.maxDepth_ = searchDepth;
        this.reset();
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager(String configFileName, CertificateCache certificateCache) throws IOException, SecurityException, CertificateV2.Error {
        this.isSecurityV1_ = true;
        this.certificateCache_ = certificateCache;
        this.reset();
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager(String configFileName) throws IOException, SecurityException, CertificateV2.Error {
        this.isSecurityV1_ = true;
        this.reset();
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager() {
        this.isSecurityV1_ = true;
        this.reset();
    }

    public ConfigPolicyManager(String configFileName, CertificateCacheV2 certificateCache, int searchDepth, double graceInterval, double keyTimestampTtl, int maxTrackedKeys) throws IOException, SecurityException, CertificateV2.Error {
        this.isSecurityV1_ = false;
        this.certificateCacheV2_ = certificateCache;
        this.maxDepth_ = searchDepth;
        this.keyGraceInterval_ = graceInterval;
        this.keyTimestampTtl_ = keyTimestampTtl;
        this.maxTrackedKeys_ = maxTrackedKeys;
        this.reset();
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager(String configFileName, CertificateCacheV2 certificateCache, int searchDepth, double graceInterval, double keyTimestampTtl) throws IOException, SecurityException, CertificateV2.Error {
        this.isSecurityV1_ = false;
        this.certificateCacheV2_ = certificateCache;
        this.maxDepth_ = searchDepth;
        this.keyGraceInterval_ = graceInterval;
        this.keyTimestampTtl_ = keyTimestampTtl;
        this.reset();
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager(String configFileName, CertificateCacheV2 certificateCache, int searchDepth, double graceInterval) throws IOException, SecurityException, CertificateV2.Error {
        this.isSecurityV1_ = false;
        this.certificateCacheV2_ = certificateCache;
        this.maxDepth_ = searchDepth;
        this.keyGraceInterval_ = graceInterval;
        this.reset();
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager(String configFileName, CertificateCacheV2 certificateCache, int searchDepth) throws IOException, SecurityException, CertificateV2.Error {
        this.isSecurityV1_ = false;
        this.certificateCacheV2_ = certificateCache;
        this.maxDepth_ = searchDepth;
        this.reset();
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public ConfigPolicyManager(String configFileName, CertificateCacheV2 certificateCache) throws IOException, SecurityException, CertificateV2.Error {
        this.isSecurityV1_ = false;
        this.certificateCacheV2_ = certificateCache;
        this.reset();
        if (configFileName != null && !configFileName.equals("")) {
            this.load(configFileName);
        }
    }

    public final void reset() {
        if (this.isSecurityV1_) {
            this.certificateCache_.reset();
        } else {
            this.certificateCacheV2_.clear();
        }
        this.fixedCertificateCache_.clear();
        this.keyTimestamps_.clear();
        this.requiresVerification_ = true;
        this.config_ = new BoostInfoParser();
        this.refreshManager_ = new TrustAnchorRefreshManager(this.isSecurityV1_);
    }

    public final void load(String configFileName) throws IOException, SecurityException, CertificateV2.Error {
        this.reset();
        this.config_.read(configFileName);
        this.loadTrustAnchorCertificates();
    }

    public void load(String input, String inputName) throws IOException, SecurityException, CertificateV2.Error {
        this.reset();
        this.config_.read(input, inputName);
        this.loadTrustAnchorCertificates();
    }

    @Override
    public final boolean skipVerifyAndTrust(Data data) {
        return !this.requiresVerification_;
    }

    @Override
    public final boolean skipVerifyAndTrust(Interest interest) {
        return !this.requiresVerification_;
    }

    @Override
    public final boolean requireVerify(Data data) {
        return this.requiresVerification_;
    }

    @Override
    public final boolean requireVerify(Interest interest) {
        return this.requiresVerification_;
    }

    @Override
    public final ValidationRequest checkVerificationPolicy(Data data, int stepCount, OnVerified onVerified, OnDataValidationFailed onValidationFailed) throws SecurityException {
        Interest certificateInterest;
        String[] failureReason = new String[]{"unknown"};
        try {
            certificateInterest = this.getCertificateInterest(stepCount, "data", data.getName(), data.getSignature(), failureReason);
        }
        catch (CertificateV2.Error ex) {
            throw new SecurityException(ex.getMessage());
        }
        catch (NdnRegexMatcherBase.Error ex) {
            throw new SecurityException("ConfigPolicyManager: Error in getCertificateInterest:" + ex);
        }
        if (certificateInterest == null) {
            try {
                onValidationFailed.onDataValidationFailed(data, failureReason[0]);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onDataValidationFailed", ex);
            }
            return null;
        }
        if (certificateInterest.getName().size() > 0) {
            return new ValidationRequest(certificateInterest, new OnCertificateDownloadComplete(data, stepCount, onVerified, onValidationFailed), onValidationFailed, 2, stepCount + 1);
        }
        if (this.verify(data.getSignature(), data.wireEncode(), failureReason)) {
            try {
                onVerified.onVerified(data);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onVerified", ex);
            }
        } else {
            try {
                onValidationFailed.onDataValidationFailed(data, failureReason[0]);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onDataValidationFailed", ex);
            }
        }
        return null;
    }

    @Override
    public final ValidationRequest checkVerificationPolicy(Interest interest, int stepCount, OnVerifiedInterest onVerified, OnInterestValidationFailed onValidationFailed, WireFormat wireFormat) throws SecurityException {
        double timestamp;
        Interest certificateInterest;
        String[] failureReason = new String[]{"unknown"};
        Signature signature = ConfigPolicyManager.extractSignature(interest, wireFormat, failureReason);
        if (signature == null) {
            try {
                onValidationFailed.onInterestValidationFailed(interest, failureReason[0]);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onInterestValidationFailed", ex);
            }
            return null;
        }
        try {
            certificateInterest = this.getCertificateInterest(stepCount, "interest", interest.getName().getPrefix(-4), signature, failureReason);
        }
        catch (CertificateV2.Error ex) {
            throw new SecurityException(ex.getMessage());
        }
        catch (NdnRegexMatcherBase.Error ex) {
            throw new SecurityException("ConfigPolicyManager: Error in getCertificateInterest:" + ex);
        }
        if (certificateInterest == null) {
            try {
                onValidationFailed.onInterestValidationFailed(interest, failureReason[0]);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onInterestValidationFailed", ex);
            }
            return null;
        }
        if (certificateInterest.getName().size() > 0) {
            return new ValidationRequest(certificateInterest, new OnCertificateDownloadCompleteForInterest(interest, stepCount, onVerified, onValidationFailed, wireFormat), new OnVerifyInterestFailedWrapper(onValidationFailed, interest), 2, stepCount + 1);
        }
        Name signatureName = KeyLocator.getFromSignature(signature).getKeyName();
        Name keyName = this.isSecurityV1_ ? IdentityCertificate.certificateNameToPublicKeyName(signatureName) : signatureName;
        if (!this.interestTimestampIsFresh(keyName, timestamp = (double)interest.getName().get(-4).toNumber(), failureReason)) {
            try {
                onValidationFailed.onInterestValidationFailed(interest, failureReason[0]);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onInterestValidationFailed", ex);
            }
            return null;
        }
        if (this.verify(signature, interest.wireEncode(), failureReason)) {
            try {
                onVerified.onVerifiedInterest(interest);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onVerifiedInterest", ex);
            }
            this.updateTimestampForKey(keyName, timestamp);
        } else {
            try {
                onValidationFailed.onInterestValidationFailed(interest, failureReason[0]);
            }
            catch (Throwable ex) {
                logger_.log(Level.SEVERE, "Error in onInterestValidationFailed", ex);
            }
        }
        return null;
    }

    @Override
    public final boolean checkSigningPolicy(Name dataName, Name certificateName) {
        return true;
    }

    @Override
    public final Name inferSigningIdentity(Name dataName) {
        throw new UnsupportedOperationException("ConfigPolicyManager.inferSigningIdentity is not implemented");
    }

    private void loadTrustAnchorCertificates() throws SecurityException, CertificateV2.Error {
        ArrayList<BoostInfoTree> anchors = this.config_.getRoot().get("validator/trust-anchor");
        for (int i = 0; i < anchors.size(); ++i) {
            BoostInfoTree anchor = anchors.get(i);
            String typeName = anchor.getFirstValue("type");
            boolean isPath = false;
            String certID = null;
            if (typeName.equals("file")) {
                certID = anchor.getFirstValue("file-name");
                isPath = true;
            } else if (typeName.equals("base64")) {
                certID = anchor.getFirstValue("base64-string");
                isPath = false;
            } else {
                if (typeName.equals("dir")) {
                    String dirName = anchor.getFirstValue("dir");
                    double refreshPeriod = 0.0;
                    ArrayList<BoostInfoTree> refreshTrees = anchor.get("refresh");
                    if (refreshTrees.size() >= 1) {
                        String refreshPeriodStr = refreshTrees.get(0).getValue();
                        Pattern regex1 = Pattern.compile("(\\d+)([hms])");
                        Matcher refreshMatch = regex1.matcher(refreshPeriodStr);
                        if (!refreshMatch.find()) {
                            refreshPeriod = 0.0;
                        } else {
                            refreshPeriod = Integer.parseInt(refreshMatch.group(1));
                            if (!refreshMatch.group(2).equals("s")) {
                                refreshPeriod *= 60.0;
                                if (!refreshMatch.group(2).equals("m")) {
                                    refreshPeriod *= 60.0;
                                }
                            }
                        }
                    }
                    this.refreshManager_.addDirectory(dirName, refreshPeriod * 1000.0);
                    continue;
                }
                if (typeName.equals("any")) {
                    this.requiresVerification_ = false;
                    break;
                }
            }
            if (this.isSecurityV1_) {
                this.lookupCertificate(certID, isPath);
                continue;
            }
            this.lookupCertificateV2(certID, isPath);
        }
    }

    private boolean checkSignatureMatch(Name signatureName, Name objectName, BoostInfoTree rule, String[] failureReason) throws SecurityException, NdnRegexMatcherBase.Error, CertificateV2.Error {
        BoostInfoTree checker = rule.get("checker").get(0);
        String checkerType = checker.getFirstValue("type");
        if (checkerType.equals("fixed-signer")) {
            Name certificateName;
            BoostInfoTree signerInfo = checker.get("signer").get(0);
            String signerType = signerInfo.getFirstValue("type");
            if (signerType.equals("file")) {
                if (this.isSecurityV1_) {
                    IdentityCertificate cert = this.lookupCertificate(signerInfo.getFirstValue("file-name"), true);
                    if (cert == null) {
                        failureReason[0] = "Can't find fixed-signer certificate file: " + signerInfo.getFirstValue("file-name");
                        return false;
                    }
                    certificateName = cert.getName();
                } else {
                    CertificateV2 cert = this.lookupCertificateV2(signerInfo.getFirstValue("file-name"), true);
                    if (cert == null) {
                        failureReason[0] = "Can't find fixed-signer certificate file: " + signerInfo.getFirstValue("file-name");
                        return false;
                    }
                    certificateName = cert.getName();
                }
            } else if (signerType.equals("base64")) {
                if (this.isSecurityV1_) {
                    IdentityCertificate cert = this.lookupCertificate(signerInfo.getFirstValue("base64-string"), false);
                    if (cert == null) {
                        failureReason[0] = "Can't find fixed-signer certificate base64: " + signerInfo.getFirstValue("base64-string");
                        return false;
                    }
                    certificateName = cert.getName();
                } else {
                    CertificateV2 cert = this.lookupCertificateV2(signerInfo.getFirstValue("base64-string"), false);
                    if (cert == null) {
                        failureReason[0] = "Can't find fixed-signer certificate base64: " + signerInfo.getFirstValue("base64-string");
                        return false;
                    }
                    certificateName = cert.getName();
                }
            } else {
                failureReason[0] = "Unrecognized fixed-signer signerType: " + signerType;
                return false;
            }
            if (certificateName.equals(signatureName)) {
                return true;
            }
            failureReason[0] = "fixed-signer cert name \"" + certificateName.toUri() + "\" does not equal signatureName \"" + signatureName.toUri() + "\"";
            return false;
        }
        if (checkerType.equals("hierarchical")) {
            String identityRegex = "^([^<KEY>]*)<KEY>(<>*)<ksk-.+><ID-CERT>";
            NdnRegexTopMatcher identityMatch = new NdnRegexTopMatcher(identityRegex);
            if (identityMatch.match(signatureName)) {
                Name identityPrefix = identityMatch.expand("\\1").append(identityMatch.expand("\\2"));
                if (ConfigPolicyManager.matchesRelation(objectName, identityPrefix, "is-prefix-of")) {
                    return true;
                }
                failureReason[0] = "The hierarchical objectName \"" + objectName.toUri() + "\" is not a prefix of \"" + identityPrefix + "\"";
                return false;
            }
            failureReason[0] = "The hierarchical identityRegex \"" + identityRegex + "\" does not match signatureName \"" + signatureName.toUri() + "\"";
            return false;
        }
        if (checkerType.equals("customized")) {
            BoostInfoTree keyLocatorInfo = checker.get("key-locator").get(0);
            String simpleRelationType = keyLocatorInfo.getFirstValue("relation");
            if (simpleRelationType != null) {
                Name matchName = new Name(keyLocatorInfo.getFirstValue("name"));
                if (ConfigPolicyManager.matchesRelation(signatureName, matchName, simpleRelationType)) {
                    return true;
                }
                failureReason[0] = "The custom signatureName \"" + signatureName.toUri() + "\" does not match matchName \"" + matchName.toUri() + "\" using relation " + simpleRelationType;
                return false;
            }
            String simpleKeyRegex = keyLocatorInfo.getFirstValue("regex");
            if (simpleKeyRegex != null) {
                if (new NdnRegexTopMatcher(simpleKeyRegex).match(signatureName)) {
                    return true;
                }
                failureReason[0] = "The custom signatureName \"" + signatureName.toUri() + "\" does not regex match simpleKeyRegex \"" + simpleKeyRegex + "\"";
                return false;
            }
            ArrayList<BoostInfoTree> hyperRelationList = keyLocatorInfo.get("hyper-relation");
            if (hyperRelationList.size() >= 1) {
                BoostInfoTree hyperRelation = hyperRelationList.get(0);
                String keyRegex = hyperRelation.getFirstValue("k-regex");
                String keyExpansion = hyperRelation.getFirstValue("k-expand");
                String nameRegex = hyperRelation.getFirstValue("p-regex");
                String nameExpansion = hyperRelation.getFirstValue("p-expand");
                String relationType = hyperRelation.getFirstValue("h-relation");
                if (keyRegex != null && keyExpansion != null && nameRegex != null && nameExpansion != null && relationType != null) {
                    NdnRegexTopMatcher keyMatch = new NdnRegexTopMatcher(keyRegex);
                    if (!keyMatch.match(signatureName)) {
                        failureReason[0] = "The custom hyper-relation signatureName \"" + signatureName.toUri() + "\" does not match the keyRegex \"" + keyRegex + "\"";
                        return false;
                    }
                    Name keyMatchPrefix = keyMatch.expand(keyExpansion);
                    NdnRegexTopMatcher nameMatch = new NdnRegexTopMatcher(nameRegex);
                    if (!nameMatch.match(objectName)) {
                        failureReason[0] = "The custom hyper-relation objectName \"" + objectName.toUri() + "\" does not match the nameRegex \"" + nameRegex + "\"";
                        return false;
                    }
                    Name nameMatchExpansion = nameMatch.expand(nameExpansion);
                    if (ConfigPolicyManager.matchesRelation(nameMatchExpansion, keyMatchPrefix, relationType)) {
                        return true;
                    }
                    failureReason[0] = "The custom hyper-relation nameMatch \"" + nameMatchExpansion.toUri() + "\" does not match the keyMatchPrefix \"" + keyMatchPrefix + "\" using relation " + relationType;
                    return false;
                }
            }
        }
        failureReason[0] = "Unrecognized checkerType: " + checkerType;
        return false;
    }

    private static String expand(Matcher match, String expansion) {
        String result = "";
        int beginIndex = 0;
        Pattern regex = Pattern.compile("\\\\(\\d)");
        Matcher expansionMatcher = regex.matcher(expansion);
        while (expansionMatcher.find()) {
            result = result + expansion.substring(beginIndex, expansionMatcher.start());
            result = result + match.group(Integer.parseInt(expansionMatcher.group(1)));
            beginIndex = expansionMatcher.end();
        }
        result = result + expansion.substring(beginIndex, expansion.length());
        return result;
    }

    private IdentityCertificate lookupCertificate(String certID, boolean isPath) throws SecurityException {
        IdentityCertificate cert;
        if (!this.isSecurityV1_) {
            throw new SecurityException("lookupCertificate: For security v2, use lookupCertificateV2()");
        }
        if (!this.fixedCertificateCache_.containsKey(certID)) {
            if (isPath) {
                cert = TrustAnchorRefreshManager.loadIdentityCertificateFromFile(certID);
            } else {
                byte[] certData = Common.base64Decode(certID);
                cert = new IdentityCertificate();
                try {
                    cert.wireDecode(new Blob(certData, false));
                }
                catch (EncodingException ex) {
                    throw new SecurityException("Cannot base64 decode the cert data: " + ex.getMessage());
                }
            }
            String certUri = cert.getName().getPrefix(-1).toUri();
            this.fixedCertificateCache_.put(certID, certUri);
            this.certificateCache_.insertCertificate(cert);
        } else {
            cert = this.certificateCache_.getCertificate(new Name((String)this.fixedCertificateCache_.get(certID)));
        }
        return cert;
    }

    private CertificateV2 lookupCertificateV2(String certID, boolean isPath) throws SecurityException, CertificateV2.Error {
        CertificateV2 cert;
        if (this.isSecurityV1_) {
            throw new SecurityException("lookupCertificateV2: For security v1, use lookupCertificate()");
        }
        if (!this.fixedCertificateCache_.containsKey(certID)) {
            if (isPath) {
                cert = TrustAnchorRefreshManager.loadCertificateV2FromFile(certID);
            } else {
                byte[] certData = Common.base64Decode(certID);
                cert = new CertificateV2();
                try {
                    cert.wireDecode(new Blob(certData, false));
                }
                catch (EncodingException ex) {
                    throw new SecurityException("Cannot base64 decode the cert data: " + ex.getMessage());
                }
            }
            String certUri = cert.getName().getPrefix(-1).toUri();
            this.fixedCertificateCache_.put(certID, certUri);
            this.certificateCacheV2_.insert(cert);
        } else {
            cert = this.certificateCacheV2_.find(new Name((String)this.fixedCertificateCache_.get(certID)));
        }
        return cert;
    }

    private BoostInfoTree findMatchingRule(Name objName, String matchType) throws NdnRegexMatcherBase.Error {
        ArrayList<BoostInfoTree> rules = this.config_.getRoot().get("validator/rule");
        for (int iRule = 0; iRule < rules.size(); ++iRule) {
            BoostInfoTree r = rules.get(iRule);
            if (!r.getFirstValue("for").equals(matchType)) continue;
            boolean passed = true;
            ArrayList<BoostInfoTree> filters = r.get("filter");
            if (filters.isEmpty()) {
                return r;
            }
            for (int iFilter = 0; iFilter < filters.size(); ++iFilter) {
                BoostInfoTree f = filters.get(iFilter);
                String regexPattern = f.getFirstValue("regex");
                if (regexPattern == null) {
                    String matchRelation = f.getFirstValue("relation");
                    String matchUri = f.getFirstValue("name");
                    Name matchName = new Name(matchUri);
                    passed = ConfigPolicyManager.matchesRelation(objName, matchName, matchRelation);
                } else {
                    passed = new NdnRegexTopMatcher(regexPattern).match(objName);
                }
                if (!passed) break;
            }
            if (!passed) continue;
            return r;
        }
        return null;
    }

    private static boolean matchesRelation(Name name, Name matchName, String matchRelation) {
        boolean passed = false;
        if (matchRelation.equals("is-strict-prefix-of")) {
            if (matchName.size() == name.size()) {
                passed = false;
            } else if (matchName.match(name)) {
                passed = true;
            }
        } else if (matchRelation.equals("is-prefix-of")) {
            if (matchName.match(name)) {
                passed = true;
            }
        } else if (matchRelation.equals("equal") && matchName.equals(name)) {
            passed = true;
        }
        return passed;
    }

    private static Signature extractSignature(Interest interest, WireFormat wireFormat, String[] failureReason) {
        if (interest.getName().size() < 2) {
            failureReason[0] = "The signed interest has less than 2 components: " + interest.getName().toUri();
            return null;
        }
        try {
            return wireFormat.decodeSignatureInfoAndValue(interest.getName().get(-2).getValue().buf(), interest.getName().get(-1).getValue().buf(), false);
        }
        catch (EncodingException ex) {
            failureReason[0] = "Error decoding the signed interest signature: " + ex;
            return null;
        }
    }

    private boolean interestTimestampIsFresh(Name keyName, double timestamp, String[] failureReason) {
        String keyNameUri = keyName.toUri();
        if (!this.keyTimestamps_.containsKey(keyNameUri)) {
            double now = Common.getNowMilliseconds();
            double notBefore = now - this.keyGraceInterval_;
            double notAfter = now + this.keyGraceInterval_;
            if (!(timestamp > notBefore) || !(timestamp < notAfter)) {
                failureReason[0] = "The command interest timestamp is not within the first use grace period of " + this.keyGraceInterval_ + " milliseconds.";
                return false;
            }
            return true;
        }
        double lastTimestamp = (Double)this.keyTimestamps_.get(keyNameUri);
        if (timestamp <= lastTimestamp) {
            failureReason[0] = "The command interest timestamp is not newer than the previous timestamp";
            return false;
        }
        return true;
    }

    private void updateTimestampForKey(Name keyName, double timestamp) {
        this.keyTimestamps_.put(keyName.toUri(), timestamp);
        if (this.keyTimestamps_.size() >= this.maxTrackedKeys_) {
            int i;
            double now;
            double oldestTimestamp = now = Common.getNowMilliseconds();
            String oldestKey = "";
            ArrayList<String> keysToErase = new ArrayList<String>();
            Object[] keys = this.keyTimestamps_.keySet().toArray();
            for (i = 0; i < keys.length; ++i) {
                String keyUri = (String)keys[i];
                double ts = (Double)this.keyTimestamps_.get(keyUri);
                if (now - ts > this.keyTimestampTtl_) {
                    keysToErase.add(keyUri);
                    continue;
                }
                if (!(ts < oldestTimestamp)) continue;
                oldestTimestamp = ts;
                oldestKey = keyUri;
            }
            for (i = 0; i < keysToErase.size(); ++i) {
                this.keyTimestamps_.remove(keysToErase.get(i));
            }
            if (this.keyTimestamps_.size() > this.maxTrackedKeys_ && oldestKey.length() != 0) {
                this.keyTimestamps_.remove(oldestKey);
            }
        }
    }

    private boolean verify(Signature signatureInfo, SignedBlob signedBlob, String[] failureReason) throws SecurityException {
        KeyLocator keyLocator = KeyLocator.getFromSignature(signatureInfo);
        if (keyLocator.getType() == KeyLocatorType.KEYNAME) {
            Blob publicKeyDer;
            Name signatureName = keyLocator.getKeyName();
            if (this.isSecurityV1_) {
                IdentityCertificate certificate = this.refreshManager_.getCertificate(signatureName);
                if (certificate == null) {
                    certificate = this.certificateCache_.getCertificate(signatureName);
                }
                if (certificate == null) {
                    failureReason[0] = "Cannot find a certificate with name " + signatureName.toUri();
                    return false;
                }
                publicKeyDer = certificate.getPublicKeyInfo().getKeyDer();
                if (publicKeyDer.isNull()) {
                    failureReason[0] = "There is no public key in the certificate with name " + certificate.getName().toUri();
                    return false;
                }
            } else {
                CertificateV2 certificate = this.refreshManager_.getCertificateV2(signatureName);
                if (certificate == null) {
                    certificate = this.certificateCacheV2_.find(signatureName);
                }
                if (certificate == null) {
                    failureReason[0] = "Cannot find a certificate with name " + signatureName.toUri();
                    return false;
                }
                try {
                    publicKeyDer = certificate.getPublicKey();
                }
                catch (CertificateV2.Error ex) {
                    failureReason[0] = "There is no public key in the certificate with name " + certificate.getName().toUri();
                    return false;
                }
            }
            if (ConfigPolicyManager.verifySignature(signatureInfo, signedBlob, publicKeyDer)) {
                return true;
            }
            failureReason[0] = "The signature did not verify with the given public key";
            return false;
        }
        failureReason[0] = "The KeyLocator does not have a key name";
        return false;
    }

    private Interest getCertificateInterest(int stepCount, String matchType, Name objectName, Signature signature, String[] failureReason) throws SecurityException, NdnRegexMatcherBase.Error, CertificateV2.Error {
        if (stepCount > this.maxDepth_) {
            failureReason[0] = "The verification stepCount " + stepCount + " exceeded the maxDepth " + this.maxDepth_;
            return null;
        }
        BoostInfoTree matchedRule = this.findMatchingRule(objectName, matchType);
        if (matchedRule == null) {
            failureReason[0] = "No matching rule found for " + objectName.toUri();
            return null;
        }
        if (!KeyLocator.canGetFromSignature(signature)) {
            failureReason[0] = "The signature type does not support a KeyLocator";
            return null;
        }
        KeyLocator keyLocator = KeyLocator.getFromSignature(signature);
        Name signatureName = keyLocator.getKeyName();
        if (signatureName.size() == 0) {
            failureReason[0] = "The signature KeyLocator doesn't have a key name";
            return null;
        }
        boolean signatureMatches = this.checkSignatureMatch(signatureName, objectName, matchedRule, failureReason);
        if (!signatureMatches) {
            return null;
        }
        this.refreshManager_.refreshAnchors();
        if (this.isSecurityV1_) {
            IdentityCertificate foundCert = this.refreshManager_.getCertificate(signatureName);
            if (foundCert == null) {
                foundCert = this.certificateCache_.getCertificate(signatureName);
            }
            if (foundCert == null) {
                return new Interest(signatureName);
            }
        } else {
            CertificateV2 foundCert = this.refreshManager_.getCertificateV2(signatureName);
            if (foundCert == null) {
                foundCert = this.certificateCacheV2_.find(signatureName);
            }
            if (foundCert == null) {
                return new Interest(signatureName);
            }
        }
        return new Interest();
    }

    public static void setFriendAccess(Friend friend) {
        if (friend.getClass().getName().endsWith("net.named_data.jndn.tests.integration_tests.TestPolicyManager") || friend.getClass().getName().endsWith("net.named_data.jndn.tests.integration_tests.TestVerificationRules")) {
            friend.setConfigPolicyManagerFriendAccess(new FriendAccessImpl());
        }
    }

    private static class FriendAccessImpl
    extends FriendAccess {
        private FriendAccessImpl() {
        }

        @Override
        public BoostInfoTree findMatchingRule(ConfigPolicyManager policyManager, Name objName, String matchType) throws NdnRegexMatcherBase.Error {
            return policyManager.findMatchingRule(objName, matchType);
        }

        @Override
        public boolean checkSignatureMatch(ConfigPolicyManager policyManager, Name signatureName, Name objectName, BoostInfoTree rule, String[] failureReason) throws SecurityException, NdnRegexMatcherBase.Error, CertificateV2.Error {
            return policyManager.checkSignatureMatch(signatureName, objectName, rule, failureReason);
        }
    }

    public static abstract class FriendAccess {
        public abstract BoostInfoTree findMatchingRule(ConfigPolicyManager var1, Name var2, String var3) throws NdnRegexMatcherBase.Error;

        public abstract boolean checkSignatureMatch(ConfigPolicyManager var1, Name var2, Name var3, BoostInfoTree var4, String[] var5) throws SecurityException, NdnRegexMatcherBase.Error, CertificateV2.Error;
    }

    public static interface Friend {
        public void setConfigPolicyManagerFriendAccess(FriendAccess var1);
    }

    private class OnVerifyInterestFailedWrapper
    implements OnDataValidationFailed {
        private final OnInterestValidationFailed onValidationFailed_;
        private final Interest interest_;

        public OnVerifyInterestFailedWrapper(OnInterestValidationFailed onValidationFailed, Interest interest) {
            this.onValidationFailed_ = onValidationFailed;
            this.interest_ = interest;
        }

        @Override
        public final void onDataValidationFailed(Data data, String reason) {
            this.onValidationFailed_.onInterestValidationFailed(this.interest_, reason);
        }
    }

    private class OnCertificateDownloadCompleteForInterest
    implements OnVerified {
        private final Interest originalInterest_;
        private final int stepCount_;
        private final OnVerifiedInterest onVerified_;
        private final OnInterestValidationFailed onValidationFailed_;
        private final WireFormat wireFormat_;

        public OnCertificateDownloadCompleteForInterest(Interest originalInterest, int stepCount, OnVerifiedInterest onVerified, OnInterestValidationFailed onValidationFailed, WireFormat wireFormat) {
            this.originalInterest_ = originalInterest;
            this.stepCount_ = stepCount;
            this.onVerified_ = onVerified;
            this.onValidationFailed_ = onValidationFailed;
            this.wireFormat_ = wireFormat;
        }

        @Override
        public final void onVerified(Data data) {
            Data certificate;
            if (ConfigPolicyManager.this.isSecurityV1_) {
                try {
                    certificate = new IdentityCertificate(data);
                }
                catch (DerDecodingException ex) {
                    try {
                        this.onValidationFailed_.onInterestValidationFailed(this.originalInterest_, "Cannot decode certificate " + data.getName().toUri());
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onInterestValidationFailed", exception);
                    }
                    return;
                }
                ConfigPolicyManager.this.certificateCache_.insertCertificate((IdentityCertificate)certificate);
            } else {
                try {
                    certificate = new CertificateV2(data);
                }
                catch (CertificateV2.Error ex) {
                    try {
                        this.onValidationFailed_.onInterestValidationFailed(this.originalInterest_, "Cannot decode certificate " + data.getName().toUri());
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onInterestValidationFailed", exception);
                    }
                    return;
                }
                try {
                    ConfigPolicyManager.this.certificateCacheV2_.insert((CertificateV2)certificate);
                }
                catch (CertificateV2.Error ex) {
                    try {
                        this.onValidationFailed_.onInterestValidationFailed(this.originalInterest_, "Cannot insert certificate " + data.getName().toUri());
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onDataValidationFailed", exception);
                    }
                    return;
                }
            }
            try {
                ConfigPolicyManager.this.checkVerificationPolicy(this.originalInterest_, this.stepCount_ + 1, this.onVerified_, this.onValidationFailed_, this.wireFormat_);
            }
            catch (Exception ex) {
                try {
                    this.onValidationFailed_.onInterestValidationFailed(this.originalInterest_, "Error in checkVerificationPolicy: " + ex);
                }
                catch (Throwable exception) {
                    logger_.log(Level.SEVERE, "Error in onInterestValidationFailed", exception);
                }
            }
        }
    }

    private class OnCertificateDownloadComplete
    implements OnVerified {
        private final Data originalData_;
        private final int stepCount_;
        private final OnVerified onVerified_;
        private final OnDataValidationFailed onValidationFailed_;

        public OnCertificateDownloadComplete(Data originalData, int stepCount, OnVerified onVerified, OnDataValidationFailed onValidationFailed) {
            this.originalData_ = originalData;
            this.stepCount_ = stepCount;
            this.onVerified_ = onVerified;
            this.onValidationFailed_ = onValidationFailed;
        }

        @Override
        public final void onVerified(Data data) {
            Data certificate;
            if (ConfigPolicyManager.this.isSecurityV1_) {
                try {
                    certificate = new IdentityCertificate(data);
                }
                catch (DerDecodingException ex) {
                    try {
                        this.onValidationFailed_.onDataValidationFailed(this.originalData_, "Cannot decode certificate " + data.getName().toUri());
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onDataValidationFailed", exception);
                    }
                    return;
                }
                ConfigPolicyManager.this.certificateCache_.insertCertificate((IdentityCertificate)certificate);
            } else {
                try {
                    certificate = new CertificateV2(data);
                }
                catch (CertificateV2.Error ex) {
                    try {
                        this.onValidationFailed_.onDataValidationFailed(this.originalData_, "Cannot decode certificate " + data.getName().toUri());
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onDataValidationFailed", exception);
                    }
                    return;
                }
                try {
                    ConfigPolicyManager.this.certificateCacheV2_.insert((CertificateV2)certificate);
                }
                catch (CertificateV2.Error ex) {
                    try {
                        this.onValidationFailed_.onDataValidationFailed(this.originalData_, "Cannot insert certificate " + data.getName().toUri());
                    }
                    catch (Throwable exception) {
                        logger_.log(Level.SEVERE, "Error in onDataValidationFailed", exception);
                    }
                    return;
                }
            }
            try {
                ConfigPolicyManager.this.checkVerificationPolicy(this.originalData_, this.stepCount_ + 1, this.onVerified_, this.onValidationFailed_);
            }
            catch (Exception ex) {
                try {
                    this.onValidationFailed_.onDataValidationFailed(this.originalData_, "Error in checkVerificationPolicy: " + ex);
                }
                catch (Throwable exception) {
                    logger_.log(Level.SEVERE, "Error in onDataValidationFailed", exception);
                }
            }
        }
    }

    private static class TrustAnchorRefreshManager {
        private final boolean isSecurityV1_;
        private final CertificateCache certificateCache_ = new CertificateCache();
        private final CertificateCacheV2 certificateCacheV2_ = new CertificateCacheV2();
        private final HashMap refreshDirectories_ = new HashMap();

        public TrustAnchorRefreshManager(boolean isSecurityV1) {
            this.isSecurityV1_ = isSecurityV1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static IdentityCertificate loadIdentityCertificateFromFile(String filename) throws SecurityException {
            StringBuilder encodedData = new StringBuilder();
            try (BufferedReader certFile = new BufferedReader(new FileReader(filename));){
                String line;
                while ((line = certFile.readLine()) != null) {
                    encodedData.append(line);
                }
            }
            catch (FileNotFoundException ex) {
                throw new SecurityException("Can't find IdentityCertificate file " + filename + ": " + ex.getMessage());
            }
            catch (IOException ex) {
                throw new SecurityException("Error reading IdentityCertificate file " + filename + ": " + ex.getMessage());
            }
            byte[] decodedData = Common.base64Decode(encodedData.toString());
            IdentityCertificate cert = new IdentityCertificate();
            try {
                cert.wireDecode(new Blob(decodedData, false));
            }
            catch (EncodingException ex) {
                throw new SecurityException("Can't decode the IdentityCertificate from file " + filename + ": " + ex.getMessage());
            }
            return cert;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static CertificateV2 loadCertificateV2FromFile(String filename) throws SecurityException {
            StringBuilder encodedData = new StringBuilder();
            try (BufferedReader certFile = new BufferedReader(new FileReader(filename));){
                String line;
                while ((line = certFile.readLine()) != null) {
                    encodedData.append(line);
                }
            }
            catch (FileNotFoundException ex) {
                throw new SecurityException("Can't find the certificate file " + filename + ": " + ex.getMessage());
            }
            catch (IOException ex) {
                throw new SecurityException("Error reading the certificate file " + filename + ": " + ex.getMessage());
            }
            byte[] decodedData = Common.base64Decode(encodedData.toString());
            CertificateV2 cert = new CertificateV2();
            try {
                cert.wireDecode(new Blob(decodedData, false));
            }
            catch (EncodingException ex) {
                throw new SecurityException("Can't decode the certificate from file " + filename + ": " + ex.getMessage());
            }
            return cert;
        }

        public IdentityCertificate getCertificate(Name certificateName) throws SecurityException {
            if (!this.isSecurityV1_) {
                throw new SecurityException("getCertificate: For security v2, use getCertificateV2()");
            }
            return this.certificateCache_.getCertificate(certificateName);
        }

        public CertificateV2 getCertificateV2(Name certificateName) throws SecurityException {
            if (this.isSecurityV1_) {
                throw new SecurityException("getCertificateV2: For security v1, use getCertificate()");
            }
            return this.certificateCacheV2_.find(certificateName);
        }

        public void addDirectory(String directoryName, double refreshPeriod) throws SecurityException, CertificateV2.Error {
            File[] allFiles = new File(directoryName).listFiles();
            if (allFiles == null) {
                throw new SecurityException("Cannot find files in directory " + directoryName);
            }
            ArrayList<String> certificateNames = new ArrayList<String>();
            for (int i = 0; i < allFiles.length; ++i) {
                String certUri;
                Data cert;
                File file = allFiles[i];
                if (this.isSecurityV1_) {
                    try {
                        cert = TrustAnchorRefreshManager.loadIdentityCertificateFromFile(file.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    certUri = cert.getName().getPrefix(-1).toUri();
                    this.certificateCache_.insertCertificate((IdentityCertificate)cert);
                    certificateNames.add(certUri);
                    continue;
                }
                try {
                    cert = TrustAnchorRefreshManager.loadCertificateV2FromFile(file.getAbsolutePath());
                }
                catch (Exception ex) {
                    continue;
                }
                certUri = CertificateV2.extractKeyNameFromCertName(cert.getName()).toUri();
                this.certificateCacheV2_.insert((CertificateV2)cert);
                certificateNames.add(certUri);
            }
            this.refreshDirectories_.put(directoryName, new DirectoryInfo(certificateNames, Common.getNowMilliseconds() + refreshPeriod, refreshPeriod));
        }

        public void refreshAnchors() throws SecurityException, CertificateV2.Error {
            double refreshTime = Common.getNowMilliseconds();
            Object[] directories = this.refreshDirectories_.keySet().toArray();
            for (int iDirectory = 0; iDirectory < directories.length; ++iDirectory) {
                String directory = (String)directories[iDirectory];
                DirectoryInfo info = (DirectoryInfo)this.refreshDirectories_.get(directory);
                double nextRefreshTime = info.nextRefresh_;
                if (!(nextRefreshTime <= refreshTime)) continue;
                ArrayList certificateList = (ArrayList)info.certificateNames_.clone();
                for (int i = 0; i < certificateList.size(); ++i) {
                    if (this.isSecurityV1_) {
                        this.certificateCache_.deleteCertificate(new Name((String)certificateList.get(i)));
                        continue;
                    }
                    CertificateV2 foundCertificate = this.certificateCacheV2_.find(new Name((String)certificateList.get(i)));
                    if (foundCertificate == null) continue;
                    this.certificateCacheV2_.deleteCertificate(foundCertificate.getName());
                }
                this.addDirectory(directory, info.refreshPeriod_);
            }
        }

        private static class DirectoryInfo {
            ArrayList certificateNames_;
            double nextRefresh_;
            double refreshPeriod_;

            public DirectoryInfo(ArrayList certificateNames, double nextRefresh, double refreshPeriod) {
                this.certificateNames_ = certificateNames;
                this.nextRefresh_ = nextRefresh;
                this.refreshPeriod_ = refreshPeriod;
            }
        }
    }
}

