/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.pib;

import java.io.File;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.named_data.jndn.Name;
import net.named_data.jndn.encoding.EncodingException;
import net.named_data.jndn.security.pib.Pib;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.pib.PibSqlite3Base;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.util.Blob;
import net.named_data.jndn.util.Common;

public class PibSqlite3
extends PibSqlite3Base {
    private Connection database_ = null;

    public PibSqlite3(String databaseDirectoryPath, String databaseFilename) throws PibImpl.Error {
        this.construct(databaseDirectoryPath, databaseFilename);
    }

    public PibSqlite3(String databaseDirectoryPath) throws PibImpl.Error {
        this.construct(databaseDirectoryPath, "pib.db");
    }

    public PibSqlite3() throws PibImpl.Error {
        this.construct("", "pib.db");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void construct(String databaseDirectoryPathIn, String databaseFilename) throws PibImpl.Error {
        File databaseDirectoryPath = !databaseDirectoryPathIn.equals("") ? new File(databaseDirectoryPathIn) : PibSqlite3.getDefaultDatabaseDirectoryPath();
        databaseDirectoryPath.mkdirs();
        File databaseFilePath = new File(databaseDirectoryPath, databaseFilename);
        try {
            Class.forName("org.sqlite.JDBC");
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PibSqlite3.class.getName()).log(Level.SEVERE, null, ex);
            return;
        }
        try {
            this.database_ = DriverManager.getConnection("jdbc:sqlite:" + databaseFilePath);
            try (Statement statement = this.database_.createStatement();){
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS                         \n  tpmInfo(                                         \n    tpm_locator           BLOB                     \n  );                                               \n");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS                         \n  identities(                                      \n    id                    INTEGER PRIMARY KEY,     \n    identity              BLOB NOT NULL,           \n    is_default            INTEGER DEFAULT 0        \n  );                                               \n");
                statement.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS                  \n  identityIndex ON identities(identity);           \n");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS                         \n  keys(                                            \n    id                    INTEGER PRIMARY KEY,     \n    identity_id           INTEGER NOT NULL,        \n    key_name              BLOB NOT NULL,           \n    key_bits              BLOB NOT NULL,           \n    is_default            INTEGER DEFAULT 0        \n  );                                               \n");
                statement.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS                  \n  keyIndex ON keys(key_name);                      \n");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS                         \n  certificates(                                    \n    id                    INTEGER PRIMARY KEY,     \n    key_id                INTEGER NOT NULL,        \n    certificate_name      BLOB NOT NULL,           \n    certificate_data      BLOB NOT NULL,           \n    is_default            INTEGER DEFAULT 0        \n  );                                               \n");
                statement.executeUpdate("CREATE UNIQUE INDEX IF NOT EXISTS                  \n  certIndex ON certificates(certificate_name);     \n");
            }
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
    }

    public static String getScheme() {
        return "pib-sqlite3";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTpmLocator(String tpmLocator) throws PibImpl.Error {
        block9: {
            try {
                if (this.getTpmLocator().equals("")) {
                    statement.setString(1, tpmLocator);
                    try (PreparedStatement statement = this.database_.prepareStatement("INSERT INTO tpmInfo (tpm_locator) values (?)");){
                        statement.executeUpdate();
                        break block9;
                    }
                }
                statement.setString(1, tpmLocator);
                try (PreparedStatement statement = this.database_.prepareStatement("UPDATE tpmInfo SET tpm_locator=?");){
                    statement.executeUpdate();
                }
            }
            catch (SQLException exception) {
                throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getTpmLocator() throws PibImpl.Error {
        try (PreparedStatement statement = this.database_.prepareStatement("SELECT tpm_locator FROM TpmInfo");){
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                String string = result.getString(1);
                return string;
            }
            String string = "";
            return string;
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasIdentity(Name identityName) throws PibImpl.Error {
        boolean bl;
        PreparedStatement statement = this.database_.prepareStatement("SELECT id FROM identities WHERE identity=?");
        statement.setBytes(1, identityName.wireEncode().getImmutableArray());
        try {
            ResultSet result = statement.executeQuery();
            bl = result.next();
        }
        catch (Throwable throwable) {
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
            }
        }
        statement.close();
        return bl;
    }

    @Override
    public void addIdentity(Name identityName) throws PibImpl.Error {
        if (!this.hasIdentity(identityName)) {
            try {
                statement.setBytes(1, identityName.wireEncode().getImmutableArray());
                try (PreparedStatement statement = this.database_.prepareStatement("INSERT INTO identities (identity) values (?)");){
                    statement.executeUpdate();
                }
            }
            catch (SQLException exception) {
                throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
            }
        }
        if (!this.hasDefaultIdentity()) {
            this.setDefaultIdentity(identityName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIdentity(Name identityName) throws PibImpl.Error {
        byte[] identityBytes = identityName.wireEncode().getImmutableArray();
        try {
            int keyId;
            ArrayList<Integer> keyIds = new ArrayList<Integer>();
            statement.setBytes(1, identityBytes);
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT keys.id FROM keys JOIN identities ON keys.identity_id=identities.id WHERE identities.identity=?");){
                ResultSet result = statement.executeQuery();
                while (result.next()) {
                    keyIds.add(result.getInt(1));
                }
            }
            Iterator iterator = keyIds.iterator();
            while (iterator.hasNext()) {
                keyId = (Integer)iterator.next();
                statement = this.database_.prepareStatement("DELETE FROM certificates WHERE key_id=?");
                statement.setInt(1, keyId);
                try {
                    statement.executeUpdate();
                }
                finally {
                    statement.close();
                }
            }
            iterator = keyIds.iterator();
            while (iterator.hasNext()) {
                keyId = (Integer)iterator.next();
                statement = this.database_.prepareStatement("DELETE FROM keys WHERE id=?");
                statement.setInt(1, keyId);
                try {
                    statement.executeUpdate();
                }
                finally {
                    statement.close();
                }
            }
            statement = this.database_.prepareStatement("DELETE FROM identities WHERE identity=?");
            statement.setBytes(1, identityBytes);
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
    }

    @Override
    public void clearIdentities() throws PibImpl.Error {
        try {
            Statement statement = this.database_.createStatement();
            statement.executeUpdate("DELETE FROM certificates");
            statement.executeUpdate("DELETE FROM keys");
            statement.executeUpdate("DELETE FROM identities");
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashSet<Name> getIdentities() throws PibImpl.Error {
        HashSet<Name> identityNames = new HashSet<Name>();
        try (PreparedStatement statement = this.database_.prepareStatement("SELECT identity FROM identities");){
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                Name name = new Name();
                try {
                    name.wireDecode(new Blob(result.getBytes(1)));
                }
                catch (EncodingException ex) {
                    throw new PibImpl.Error("PibSqlite3: Error decoding name: " + ex);
                }
                identityNames.add(name);
            }
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
        return identityNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultIdentity(Name identityName) throws PibImpl.Error {
        try {
            PreparedStatement statement;
            byte[] identityBytes = identityName.wireEncode().getImmutableArray();
            if (!this.hasIdentity(identityName)) {
                statement = this.database_.prepareStatement("INSERT INTO identities (identity) values (?)");
                statement.setBytes(1, identityBytes);
                try {
                    statement.executeUpdate();
                }
                finally {
                    statement.close();
                }
            }
            statement = this.database_.prepareStatement("UPDATE identities SET is_default=0 WHERE is_default=1");
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
            statement = this.database_.prepareStatement("UPDATE identities SET is_default=1 WHERE identity=?");
            statement.setBytes(1, identityBytes);
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Name getDefaultIdentity() throws Pib.Error, PibImpl.Error {
        try (Statement statement = this.database_.createStatement();){
            ResultSet result = statement.executeQuery("SELECT identity FROM identities WHERE is_default=1");
            if (!result.next()) throw new Pib.Error("No default identity");
            Name name = new Name();
            try {
                name.wireDecode(new Blob(result.getBytes(1)));
            }
            catch (EncodingException ex) {
                throw new PibImpl.Error("PibSqlite3: Error decoding name: " + ex);
            }
            Name name2 = name;
            return name2;
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasKey(Name keyName) throws PibImpl.Error {
        boolean bl;
        PreparedStatement statement = this.database_.prepareStatement("SELECT id FROM keys WHERE key_name=?");
        statement.setBytes(1, keyName.wireEncode().getImmutableArray());
        try {
            ResultSet result = statement.executeQuery();
            bl = result.next();
        }
        catch (Throwable throwable) {
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
            }
        }
        statement.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKey(Name identityName, Name keyName, ByteBuffer key) throws PibImpl.Error {
        block14: {
            PreparedStatement statement;
            this.addIdentity(identityName);
            if (!this.hasKey(keyName)) {
                try {
                    statement = this.database_.prepareStatement("INSERT INTO keys (identity_id, key_name, key_bits) VALUES ((SELECT id FROM identities WHERE identity=?), ?, ?)");
                    statement.setBytes(1, identityName.wireEncode().getImmutableArray());
                    statement.setBytes(2, keyName.wireEncode().getImmutableArray());
                    statement.setBytes(3, new Blob(key, false).getImmutableArray());
                    try {
                        statement.executeUpdate();
                        break block14;
                    }
                    finally {
                        statement.close();
                    }
                }
                catch (SQLException exception) {
                    throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
                }
            }
            try {
                statement = this.database_.prepareStatement("UPDATE keys SET key_bits=? WHERE key_name=?");
                statement.setBytes(1, new Blob(key, false).getImmutableArray());
                statement.setBytes(2, keyName.wireEncode().getImmutableArray());
                try {
                    statement.executeUpdate();
                }
                finally {
                    statement.close();
                }
            }
            catch (SQLException exception) {
                throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
            }
        }
        if (!this.hasDefaultKeyOfIdentity(identityName)) {
            try {
                this.setDefaultKeyOfIdentity(identityName, keyName);
            }
            catch (Pib.Error ex) {
                throw new PibImpl.Error("PibSqlite3: Error setting the default key: " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeKey(Name keyName) throws PibImpl.Error {
        byte[] keyNameBytes = keyName.wireEncode().getImmutableArray();
        try {
            statement.setBytes(1, keyNameBytes);
            try (PreparedStatement statement = this.database_.prepareStatement("DELETE FROM certificates WHERE key_id=(SELECT id FROM keys WHERE key_name=?)");){
                statement.executeUpdate();
            }
            statement = this.database_.prepareStatement("DELETE FROM keys WHERE key_name=?");
            statement.setBytes(1, keyNameBytes);
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Blob getKeyBits(Name keyName) throws Pib.Error, PibImpl.Error {
        try {
            statement.setBytes(1, keyName.wireEncode().getImmutableArray());
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT key_bits FROM keys WHERE key_name=?");){
                ResultSet result = statement.executeQuery();
                if (!result.next()) throw new Pib.Error("Key `" + keyName.toUri() + "` does not exist");
                Blob blob = new Blob(result.getBytes(1), false);
                return blob;
            }
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashSet<Name> getKeysOfIdentity(Name identityName) throws PibImpl.Error {
        HashSet<Name> keyNames = new HashSet<Name>();
        try {
            statement.setBytes(1, identityName.wireEncode().getImmutableArray());
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT key_name FROM keys JOIN identities ON keys.identity_id=identities.id WHERE identities.identity=?");){
                ResultSet result = statement.executeQuery();
                while (result.next()) {
                    Name name = new Name();
                    try {
                        name.wireDecode(new Blob(result.getBytes(1)));
                    }
                    catch (EncodingException ex) {
                        throw new PibImpl.Error("PibSqlite3: Error decoding name: " + ex);
                    }
                    keyNames.add(name);
                }
            }
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
        return keyNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultKeyOfIdentity(Name identityName, Name keyName) throws Pib.Error, PibImpl.Error {
        if (!this.hasKey(keyName)) {
            throw new Pib.Error("Key `" + keyName.toUri() + "` does not exist");
        }
        try {
            try (PreparedStatement statement = this.database_.prepareStatement("UPDATE keys SET is_default=0 WHERE is_default=1");){
                statement.executeUpdate();
            }
            statement = this.database_.prepareStatement("UPDATE keys SET is_default=1 WHERE key_name=?");
            statement.setBytes(1, keyName.wireEncode().getImmutableArray());
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Name getDefaultKeyOfIdentity(Name identityName) throws Pib.Error, PibImpl.Error {
        if (!this.hasIdentity(identityName)) {
            throw new Pib.Error("Identity `" + identityName.toUri() + "` does not exist");
        }
        try {
            statement.setBytes(1, identityName.wireEncode().getImmutableArray());
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT key_name FROM keys JOIN identities ON keys.identity_id=identities.id WHERE identities.identity=? AND keys.is_default=1");){
                ResultSet result = statement.executeQuery();
                if (!result.next()) throw new Pib.Error("No default key for identity `" + identityName.toUri() + "`");
                Name name = new Name();
                try {
                    name.wireDecode(new Blob(result.getBytes(1)));
                }
                catch (EncodingException ex) {
                    throw new PibImpl.Error("PibSqlite3: Error decoding name: " + ex);
                }
                Name name2 = name;
                return name2;
            }
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasCertificate(Name certificateName) throws PibImpl.Error {
        boolean bl;
        PreparedStatement statement = this.database_.prepareStatement("SELECT id FROM certificates WHERE certificate_name=?");
        statement.setBytes(1, certificateName.wireEncode().getImmutableArray());
        try {
            ResultSet result = statement.executeQuery();
            bl = result.next();
        }
        catch (Throwable throwable) {
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
            }
        }
        statement.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCertificate(CertificateV2 certificate) throws PibImpl.Error {
        block14: {
            PreparedStatement statement;
            Blob content = certificate.getContent();
            this.addKey(certificate.getIdentity(), certificate.getKeyName(), content.buf());
            if (!this.hasCertificate(certificate.getName())) {
                try {
                    statement = this.database_.prepareStatement("INSERT INTO certificates (key_id, certificate_name, certificate_data) VALUES ((SELECT id FROM keys WHERE key_name=?), ?, ?)");
                    statement.setBytes(1, certificate.getKeyName().wireEncode().getImmutableArray());
                    statement.setBytes(2, certificate.getName().wireEncode().getImmutableArray());
                    statement.setBytes(3, certificate.wireEncode().getImmutableArray());
                    try {
                        statement.executeUpdate();
                        break block14;
                    }
                    finally {
                        statement.close();
                    }
                }
                catch (SQLException exception) {
                    throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
                }
            }
            try {
                statement = this.database_.prepareStatement("UPDATE certificates SET certificate_data=? WHERE certificate_name=?");
                statement.setBytes(1, certificate.wireEncode().getImmutableArray());
                statement.setBytes(2, certificate.getName().wireEncode().getImmutableArray());
                try {
                    statement.executeUpdate();
                }
                finally {
                    statement.close();
                }
            }
            catch (SQLException exception) {
                throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
            }
        }
        if (!this.hasDefaultCertificateOfKey(certificate.getKeyName())) {
            try {
                this.setDefaultCertificateOfKey(certificate.getKeyName(), certificate.getName());
            }
            catch (Pib.Error ex) {
                throw new PibImpl.Error("PibSqlite3: Error setting the default certificate: " + ex);
            }
        }
    }

    @Override
    public void removeCertificate(Name certificateName) throws PibImpl.Error {
        try {
            statement.setBytes(1, certificateName.wireEncode().getImmutableArray());
            try (PreparedStatement statement = this.database_.prepareStatement("DELETE FROM certificates WHERE certificate_name=?");){
                statement.executeUpdate();
            }
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CertificateV2 getCertificate(Name certificateName) throws Pib.Error, PibImpl.Error {
        try {
            statement.setBytes(1, certificateName.wireEncode().getImmutableArray());
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT certificate_data FROM certificates WHERE certificate_name=?");){
                ResultSet result = statement.executeQuery();
                if (!result.next()) throw new Pib.Error("Certificate `" + certificateName.toUri() + "` does not exit");
                CertificateV2 certificate = new CertificateV2();
                try {
                    certificate.wireDecode(new Blob(result.getBytes(1)));
                }
                catch (EncodingException ex) {
                    throw new PibImpl.Error("PibSqlite3: Error decoding certificate: " + ex);
                }
                CertificateV2 certificateV2 = certificate;
                return certificateV2;
            }
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashSet<Name> getCertificatesOfKey(Name keyName) throws PibImpl.Error {
        HashSet<Name> certNames = new HashSet<Name>();
        try {
            statement.setBytes(1, keyName.wireEncode().getImmutableArray());
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT certificate_name FROM certificates JOIN keys ON certificates.key_id=keys.id WHERE keys.key_name=?");){
                ResultSet result = statement.executeQuery();
                while (result.next()) {
                    Name name = new Name();
                    try {
                        name.wireDecode(new Blob(result.getBytes(1)));
                    }
                    catch (EncodingException ex) {
                        throw new PibImpl.Error("PibSqlite3: Error decoding name: " + ex);
                    }
                    certNames.add(name);
                }
            }
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
        return certNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultCertificateOfKey(Name keyName, Name certificateName) throws Pib.Error, PibImpl.Error {
        if (!this.hasCertificate(certificateName)) {
            throw new Pib.Error("Certificate `" + certificateName.toUri() + "` does not exist");
        }
        try {
            try (PreparedStatement statement = this.database_.prepareStatement("UPDATE certificates SET is_default=0 WHERE is_default=1");){
                statement.executeUpdate();
            }
            statement = this.database_.prepareStatement("UPDATE certificates SET is_default=1 WHERE certificate_name=?");
            statement.setBytes(1, certificateName.wireEncode().getImmutableArray());
            try {
                statement.executeUpdate();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CertificateV2 getDefaultCertificateOfKey(Name keyName) throws Pib.Error, PibImpl.Error {
        try {
            statement.setBytes(1, keyName.wireEncode().getImmutableArray());
            try (PreparedStatement statement = this.database_.prepareStatement("SELECT certificate_data FROM certificates JOIN keys ON certificates.key_id=keys.id WHERE certificates.is_default=1 AND keys.key_name=?");){
                ResultSet result = statement.executeQuery();
                if (!result.next()) throw new Pib.Error("No default certificate for key `" + keyName.toUri() + "`");
                CertificateV2 certificate = new CertificateV2();
                try {
                    certificate.wireDecode(new Blob(result.getBytes(1)));
                }
                catch (EncodingException ex) {
                    throw new PibImpl.Error("PibSqlite3: Error decoding certificate: " + ex);
                }
                CertificateV2 certificateV2 = certificate;
                return certificateV2;
            }
        }
        catch (SQLException exception) {
            throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
        }
    }

    public static File getDefaultDatabaseDirectoryPath() {
        return new File(Common.getHomeDirectory(), ".ndn");
    }

    public static File getDefaultDatabaseFilePath() {
        return new File(PibSqlite3.getDefaultDatabaseDirectoryPath(), "pib.db");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDefaultIdentity() throws PibImpl.Error {
        boolean bl;
        Statement statement = this.database_.createStatement();
        try {
            ResultSet result = statement.executeQuery("SELECT id FROM identities WHERE is_default=1");
            bl = result.next();
        }
        catch (Throwable throwable) {
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
            }
        }
        statement.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDefaultKeyOfIdentity(Name identityName) throws PibImpl.Error {
        boolean bl;
        PreparedStatement statement = this.database_.prepareStatement("SELECT keys.id FROM keys JOIN identities ON keys.identity_id=identities.id WHERE identities.identity=? AND keys.is_default=1");
        statement.setBytes(1, identityName.wireEncode().getImmutableArray());
        try {
            ResultSet result = statement.executeQuery();
            bl = result.next();
        }
        catch (Throwable throwable) {
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
            }
        }
        statement.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDefaultCertificateOfKey(Name keyName) throws PibImpl.Error {
        boolean bl;
        PreparedStatement statement = this.database_.prepareStatement("SELECT certificates.id FROM certificates JOIN keys ON certificates.key_id=keys.id WHERE certificates.is_default=1 AND keys.key_name=?");
        statement.setBytes(1, keyName.wireEncode().getImmutableArray());
        try {
            ResultSet result = statement.executeQuery();
            bl = result.next();
        }
        catch (Throwable throwable) {
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException exception) {
                throw new PibImpl.Error("PibSqlite3: SQLite error: " + exception);
            }
        }
        statement.close();
        return bl;
    }
}

