/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.security.pib;

import net.named_data.jndn.Name;
import net.named_data.jndn.security.KeyType;
import net.named_data.jndn.security.pib.Pib;
import net.named_data.jndn.security.pib.PibCertificateContainer;
import net.named_data.jndn.security.pib.PibImpl;
import net.named_data.jndn.security.pib.detail.PibKeyImpl;
import net.named_data.jndn.security.v2.CertificateV2;
import net.named_data.jndn.util.Blob;

public class PibKey {
    private final PibKeyImpl impl_;

    public final Name getName() {
        return this.lockImpl().getName();
    }

    public final Name getIdentityName() {
        return this.lockImpl().getIdentityName();
    }

    public final KeyType getKeyType() {
        return this.lockImpl().getKeyType();
    }

    public final Blob getPublicKey() {
        return this.lockImpl().getPublicKey();
    }

    public final CertificateV2 getCertificate(Name certificateName) throws Pib.Error, PibImpl.Error {
        return this.lockImpl().getCertificate(certificateName);
    }

    public final CertificateV2 getDefaultCertificate() throws Pib.Error, PibImpl.Error {
        return this.lockImpl().getDefaultCertificate();
    }

    public static Name constructKeyName(Name identityName, Name.Component keyId) {
        Name keyName = new Name(identityName);
        keyName.append(CertificateV2.KEY_COMPONENT).append(keyId);
        return keyName;
    }

    public static boolean isValidKeyName(Name keyName) {
        return keyName.size() > 2 && keyName.get(-2).equals(CertificateV2.KEY_COMPONENT);
    }

    public static Name extractIdentityFromKeyName(Name keyName) {
        if (!PibKey.isValidKeyName(keyName)) {
            throw new IllegalArgumentException("Key name `" + keyName.toUri() + "` does not follow the naming conventions");
        }
        return keyName.getPrefix(-2);
    }

    public PibKey(PibKeyImpl impl) {
        this.impl_ = impl;
    }

    public final void addCertificate_(CertificateV2 certificate) throws CertificateV2.Error, PibImpl.Error {
        this.lockImpl().addCertificate(certificate);
    }

    public final void removeCertificate_(Name certificateName) throws PibImpl.Error {
        this.lockImpl().removeCertificate(certificateName);
    }

    public final CertificateV2 setDefaultCertificate_(Name certificateName) throws Pib.Error, PibImpl.Error {
        return this.lockImpl().setDefaultCertificate(certificateName);
    }

    public final CertificateV2 setDefaultCertificate_(CertificateV2 certificate) throws CertificateV2.Error, PibImpl.Error, Pib.Error {
        return this.lockImpl().setDefaultCertificate(certificate);
    }

    public final PibCertificateContainer getCertificates_() {
        return this.lockImpl().getCertificates_();
    }

    private PibKeyImpl lockImpl() {
        if (this.impl_ == null) {
            throw new AssertionError((Object)"Invalid key instance");
        }
        return this.impl_;
    }
}

