/*
 * Decompiled with CFR 0.152.
 */
package net.named_data.jndn.encrypt;

public class Interval {
    private double startTime_;
    private double endTime_;
    private boolean isValid_;

    public Interval(boolean isValid) {
        this.isValid_ = isValid;
        this.startTime_ = -1.7976931348623157E308;
        this.endTime_ = -1.7976931348623157E308;
    }

    public Interval(double startTime, double endTime) {
        if (!(startTime < endTime)) {
            throw new java.lang.Error("Interval start time must be less than the end time");
        }
        this.startTime_ = startTime;
        this.endTime_ = endTime;
        this.isValid_ = true;
    }

    public Interval(Interval interval) {
        this.startTime_ = interval.startTime_;
        this.endTime_ = interval.endTime_;
        this.isValid_ = interval.isValid_;
    }

    public Interval() {
        this.isValid_ = false;
        this.startTime_ = -1.7976931348623157E308;
        this.endTime_ = -1.7976931348623157E308;
    }

    public void set(Interval interval) {
        this.startTime_ = interval.startTime_;
        this.endTime_ = interval.endTime_;
        this.isValid_ = interval.isValid_;
    }

    public final boolean covers(double timePoint) {
        if (!this.isValid_) {
            throw new java.lang.Error("Interval.covers: This Interval is invalid");
        }
        if (this.isEmpty()) {
            return false;
        }
        return this.startTime_ <= timePoint && timePoint < this.endTime_;
    }

    public final Interval intersectWith(Interval interval) {
        if (!this.isValid_) {
            throw new java.lang.Error("Interval.intersectWith: This Interval is invalid");
        }
        if (!interval.isValid_) {
            throw new java.lang.Error("Interval.intersectWith: The other Interval is invalid");
        }
        if (this.isEmpty() || interval.isEmpty()) {
            this.startTime_ = this.endTime_;
            return this;
        }
        if (this.startTime_ >= interval.endTime_ || this.endTime_ <= interval.startTime_) {
            this.startTime_ = this.endTime_;
            return this;
        }
        if (this.startTime_ <= interval.startTime_) {
            this.startTime_ = interval.startTime_;
        }
        if (this.endTime_ > interval.endTime_) {
            this.endTime_ = interval.endTime_;
        }
        return this;
    }

    public final Interval unionWith(Interval interval) throws Error {
        if (!this.isValid_) {
            throw new java.lang.Error("Interval.intersectWith: This Interval is invalid");
        }
        if (!interval.isValid_) {
            throw new java.lang.Error("Interval.intersectWith: The other Interval is invalid");
        }
        if (this.isEmpty()) {
            this.startTime_ = interval.startTime_;
            this.endTime_ = interval.endTime_;
            return this;
        }
        if (interval.isEmpty()) {
            return this;
        }
        if (this.startTime_ >= interval.endTime_ || this.endTime_ <= interval.startTime_) {
            throw new Error("Interval.unionWith: The two intervals do not have an intersection");
        }
        if (this.startTime_ > interval.startTime_) {
            this.startTime_ = interval.startTime_;
        }
        if (this.endTime_ < interval.endTime_) {
            this.endTime_ = interval.endTime_;
        }
        return this;
    }

    public final double getStartTime() {
        if (!this.isValid_) {
            throw new java.lang.Error("Interval.getStartTime: This Interval is invalid");
        }
        return this.startTime_;
    }

    public final double getEndTime() {
        if (!this.isValid_) {
            throw new java.lang.Error("Interval.getEndTime: This Interval is invalid");
        }
        return this.endTime_;
    }

    public final boolean isValid() {
        return this.isValid_;
    }

    public final boolean isEmpty() {
        if (!this.isValid_) {
            throw new java.lang.Error("Interval.isEmpty: This Interval is invalid");
        }
        return this.startTime_ == this.endTime_;
    }

    public static class Error
    extends Exception {
        public Error(String message) {
            super(message);
        }
    }
}

